/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.mat.services;

import java.util.Map;
import org.eclipse.andmore.android.DDMSUtils;
import org.eclipse.andmore.android.ISerialNumbered;
import org.eclipse.andmore.android.mat.i18n.MatNLS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.sequoyah.device.framework.model.handler.IServiceHandler;
import org.eclipse.sequoyah.device.framework.model.handler.ServiceHandler;

public class DumpHPROFHandler
extends ServiceHandler {
    public IServiceHandler newInstance() {
        return new DumpHPROFHandler();
    }

    public IStatus runService(IInstance instance, Map<Object, Object> arg1, IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        if (instance instanceof ISerialNumbered) {
            ISerialNumbered serialNumbered = (ISerialNumbered)instance;
            final String serialNumber = serialNumbered.getSerialNumber();
            int deviceApiVersion = DDMSUtils.getDeviceApiVersion((String)serialNumber);
            if (deviceApiVersion > 0) {
                if (deviceApiVersion > 2) {
                    Job job = new Job(MatNLS.JOB_Name_Dump_Hprof){

                        protected IStatus run(IProgressMonitor monitor) {
                            return DDMSUtils.dumpHPROF((String)serialNumber, (IProgressMonitor)monitor);
                        }
                    };
                    job.setUser(true);
                    job.schedule();
                } else {
                    status = new Status(4, "org.eclipse.andmore.android.mat", MatNLS.DumpHPROFHandler_UNSUPPORTED_DEVICE);
                }
            } else {
                status = new Status(4, "org.eclipse.andmore.android.mat", MatNLS.DumpHPROFHandler_DEVICE_NOT_READY);
            }
        }
        return status;
    }

    public IStatus updatingService(IInstance arg0, IProgressMonitor arg1) {
        return Status.OK_STATUS;
    }
}

