/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.localization.translators.preferences.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.localization.translators.TranslationPlugin;
import org.eclipse.andmore.android.localization.translators.i18n.TranslateNLS;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.osgi.service.prefs.BackingStoreException;

public class TranslationPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private final String GOOGLE_APIS_CONSOLE_LINK = "http://code.google.com/apis/console/";
    private Text apiKeyText;
    private String apiKeyValue;

    public void init(IWorkbench workbench) {
        this.noDefaultAndApplyButton();
    }

    public boolean performOk() {
        InstanceScope scope = (InstanceScope)InstanceScope.INSTANCE;
        IEclipsePreferences prefs = scope.getNode("org.eclipse.andmore.android.translation");
        if (this.apiKeyValue.trim().length() == 0) {
            prefs.remove("google.translator.apikey");
        } else {
            prefs.put("google.translator.apikey", this.apiKeyValue.trim());
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {}
        return super.performOk();
    }

    protected Control createContents(Composite parent) {
        Composite entryTable = new Composite(parent, 0);
        GridData data = new GridData(4, 128, true, false);
        entryTable.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        entryTable.setLayout((Layout)layout);
        layout = new GridLayout(2, false);
        layout = new GridLayout(2, false);
        Group translatorAPIGroup = new Group(entryTable, 0);
        translatorAPIGroup.setLayout((Layout)layout);
        translatorAPIGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        translatorAPIGroup.setText(TranslateNLS.AndroidPreferencePage_googleApiKey_GroupLabel);
        Link noteLabel = new Link((Composite)translatorAPIGroup, 64);
        noteLabel.setText(NLS.bind((String)TranslateNLS.AndroidPreferencePage_googleApiKey_Note, (Object)"http://code.google.com/apis/console/"));
        data = new GridData(4, 0x1000000, true, false, 2, 1);
        data.widthHint = 450;
        noteLabel.setLayoutData((Object)data);
        noteLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                try {
                    IWebBrowser browser = browserSupport.createBrowser(134, "ANDMORE", null, null);
                    browser.openURL(new URL("http://code.google.com/apis/console/"));
                }
                catch (PartInitException ex) {
                    AndmoreLogger.error((String)("Error opening the Google APIs Console link: " + ex.getMessage()));
                }
                catch (MalformedURLException ex) {
                    AndmoreLogger.error((String)("Error opening the Google APIs Console link: " + ex.getMessage()));
                }
            }
        });
        Label apiKeyLabel = new Label((Composite)translatorAPIGroup, 0);
        apiKeyLabel.setText(TranslateNLS.AndroidPreferencePage_googleApiKey_Label);
        data = new GridData(16384, 0x1000000, false, false, 1, 1);
        apiKeyLabel.setLayoutData((Object)data);
        this.apiKeyText = new Text((Composite)translatorAPIGroup, 2048);
        this.apiKeyValue = TranslationPreferencePage.getApiKey();
        this.apiKeyText.setText(this.apiKeyValue);
        this.apiKeyText.setToolTipText(TranslateNLS.AndroidPreferencePage_googleApiKey_Tooltip);
        data = new GridData(4, 0x1000000, true, false, 1, 1);
        this.apiKeyText.setLayoutData((Object)data);
        this.apiKeyText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TranslationPreferencePage.this.apiKeyValue = TranslationPreferencePage.this.apiKeyText.getText();
            }
        });
        return entryTable;
    }

    private static String getApiKey() {
        String apiKey = "";
        IPreferenceStore prefStore = TranslationPlugin.getDefault().getPreferenceStore();
        if (!prefStore.isDefault("google.translator.apikey") && (apiKey = prefStore.getString("google.translator.apikey")) == null) {
            apiKey = "";
        }
        return apiKey;
    }
}

