/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.logger;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.andmore.android.AndroidPlugin;
import org.eclipse.andmore.android.DDMSFacade;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.logger.collector.core.ILogFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class DevicePropertyLogger
implements ILogFile {
    private final Collection<String> serialNumbers = DDMSFacade.getConnectedSerialNumbers();
    private final Map<String, Map<String, String>> properties = new HashMap<String, Map<String, String>>(this.serialNumbers.size());

    public DevicePropertyLogger() {
        for (String serialNumber : this.serialNumbers) {
            HashMap<String, String> propertiesMap = new HashMap<String, String>(140);
            String deviceName = DDMSFacade.getNameBySerialNumber(serialNumber);
            try {
                Collection<String> lines = DDMSFacade.execRemoteApp(serialNumber, "getprop", (IProgressMonitor)new NullProgressMonitor());
                for (String line : lines) {
                    String[] split = line.split(":");
                    StringBuffer buffer = new StringBuffer();
                    int i = 1;
                    while (i < split.length) {
                        buffer.append(split[i]);
                        ++i;
                    }
                    if ("".equals(split[0])) continue;
                    propertiesMap.put(split[0], buffer.toString());
                }
            }
            catch (IOException e) {
                AndmoreLogger.error(this.getClass(), (String)("Unable to execute getprop command on device " + deviceName), (Throwable)e);
            }
            this.properties.put(deviceName, propertiesMap);
        }
    }

    public List<IPath> getLogFilePath() {
        ArrayList<IPath> logs = new ArrayList<IPath>(this.properties.keySet().size());
        IPath LOG_PATH = AndroidPlugin.getDefault().getStateLocation();
        for (String devicename : this.properties.keySet()) {
            IPath log = LOG_PATH.append(String.valueOf(devicename) + "_devProperties.log");
            this.writeLogFile(log, this.properties.get(devicename));
            logs.add(log);
        }
        return logs;
    }

    private void writeLogFile(IPath log, Map<String, String> devProperties) {
        File logFile = log.toFile();
        BufferedWriter bw = null;
        try {
            try {
                bw = new BufferedWriter(new FileWriter(logFile));
                for (String propKey : devProperties.keySet()) {
                    bw.append(String.valueOf(propKey) + "=" + devProperties.get(propKey) + System.getProperty("line.separator"));
                }
            }
            catch (IOException e) {
                AndmoreLogger.error(this.getClass(), (String)("An error occurred while trying to write device Properties log file, " + logFile.getAbsolutePath()), (Throwable)e);
                try {
                    bw.flush();
                    bw.close();
                }
                catch (IOException e2) {
                    AndmoreLogger.error((String)("Could not close stream while writing device property log. " + e2.getMessage()));
                }
            }
        }
        finally {
            try {
                bw.flush();
                bw.close();
            }
            catch (IOException e) {
                AndmoreLogger.error((String)("Could not close stream while writing device property log. " + e.getMessage()));
            }
        }
    }

    public String getLogName() {
        return "Device properties";
    }

    public String getOutputSubfolderName() {
        return "Devices";
    }
}

