/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.model;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.android.AndroidPlugin;
import org.eclipse.andmore.android.ProjectUtils;
import org.eclipse.andmore.android.SdkUtils;
import org.eclipse.andmore.android.common.exception.AndroidException;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.AndroidStatus;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.common.utilities.FileUtil;
import org.eclipse.andmore.android.i18n.AndroidNLS;
import org.eclipse.andmore.android.model.AndroidProject;
import org.eclipse.andmore.android.utilities.DictionaryUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.osgi.framework.Bundle;

public class ProjectCreationSupport {
    private static final String PACKAGE_NAME = "PACKAGE";
    private static final String APP_NAME = "app_name";
    private static final String APPLICATION_NAME = "APPLICATION_NAME";
    private static final String STRING_RSRC_PREFIX = "@string/";
    private static final String MIN_SDK_VERSION = "MIN_SDK_VERSION";
    private static final String BIN_DIR = "bin/";
    private static final String RES_DIR = "res/";
    private static final String ASSETS_DIR = "assets/";
    private static final String DRAWABLE_DIR = "drawable";
    private static final String LAYOUT_DIR = "layout/";
    private static final String VALUES_DIR = "values/";
    private static final String GEN_DIR = "gen/";
    private static final String XML_DIR = "xml/";
    private static final String TEMPLATES_DIRECTORY = "templates/";
    private static final String MANIFEST_TEMPLATE = "templates/AndroidManifest.template";
    private static final String ACTIVITY_NAME = "ACTIVITY_NAME";
    private static final String ACTIVITY_TEMPLATE = "templates/activity.template";
    private static final String LAUNCHER_INTENT_TEMPLATE = "templates/launcher_intent_filter.template";
    private static final String INTENT_FILTERS = "INTENT_FILTERS";
    private static final String ACTIVITIES = "ACTIVITIES";
    private static final String USES_SDK_TEMPLATE = "templates/uses-sdk.template";
    private static final String USES_SDK = "USES-SDK";
    private static final String ICON = "ic_launcher.png";
    private static final String JAVA_ACTIVITY_TEMPLATE = "java_file.template";
    private static final String MAIN_LAYOUT_XML = "main.xml";
    private static final String LAYOUT_TEMPLATE = "layout.template";
    private static final String STRING_HELLO_WORLD = "hello";
    private static final String TEST_USES_LIBRARY = "TEST-USES-LIBRARY";
    private static final String TEST_INSTRUMENTATION = "TEST-INSTRUMENTATION";
    private static final String[] DPIS = new String[]{"hdpi", "ldpi", "mdpi"};
    private static final String WIDGET_TEMPLATE_FOLDER = "templates/widget_project/";
    private static final String WIDGET_MANIFEST_TEMPLATE_PATH = "templates/widget_project/AndroidWidgetManifest.template";
    private static final String WIDGET_ACTIVITY_TEMPLATE_PATH = "templates/widget_project/activity.template";
    private static final String WIDGET_RECEIVER_TEMPLATE_PATH = "templates/widget_project/receiver.template";
    private static final String WIDGET_USES_SDK_TEMPLATE_PATH = "templates/widget_project/uses-sdk.template";
    private static final String RECEIVERS = "RECEIVERS";
    private static final String WIDGET_INITIAL_LAYOUT_XML = "widget_initial_layout.xml";
    private static final String WIDGET_INFO_XML = "widget_info.xml";
    private static final String WIDGET_PROVIDER_SAMPLE_NAME = "WidgetProvider";
    private static final String WIDGET_PROVIDER_SAMPLE_TEMPLATE = "WidgetProvider.template";
    private static final String IMPORT_RESOURCE_CLASS = "IMPORT_RESOURCE_CLASS";

    private ProjectCreationSupport() {
    }

    public static boolean createProject(final AndroidProject androidProject, IWizardContainer container) throws AndroidException {
        Path destination;
        boolean created = true;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProject project = workspace.getRoot().getProject(androidProject.getName());
        if (!ProjectCreationSupport.canCreateProject(workspace.getRoot(), androidProject.getName())) {
            throw new AndroidException(AndroidNLS.EXC_ProjectCreationSupport_CannotCreateProjectReadOnlyWorkspace);
        }
        final IProjectDescription description = workspace.newProjectDescription(project.getName());
        final HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(MIN_SDK_VERSION, androidProject.getMinSdkVersion());
        if (androidProject.getSourceType() == AndroidProject.SourceTypes.NEW || androidProject.getSourceType() == AndroidProject.SourceTypes.WIDGET) {
            String activityName = androidProject.getActivityName();
            if (activityName.startsWith(".")) {
                activityName = activityName.substring(1);
            }
            parameters.put(ACTIVITY_NAME, androidProject.getActivityName());
            parameters.put(PACKAGE_NAME, androidProject.getPackageName());
            parameters.put(APPLICATION_NAME, "@string/app_name");
            parameters.put(IMPORT_RESOURCE_CLASS, "");
        }
        final HashMap<String, String> stringDictionary = new HashMap<String, String>();
        stringDictionary.put(APP_NAME, androidProject.getApplicationName());
        if (!androidProject.isUsingDefaultLocation() && androidProject.isNewProject()) {
            destination = new Path(androidProject.getLocation());
            description.setLocation((IPath)destination);
            if (!FileUtil.canWrite((File)destination.toFile())) {
                String errMsg = NLS.bind((String)AndroidNLS.EXC_ProjectCreationSupport_CannotCreateProjectReadOnlyDestination, (Object)destination.toOSString());
                throw new AndroidException(errMsg);
            }
            if (!ProjectCreationSupport.validateNewProjectLocationIsEmpty((IPath)destination)) {
                throw new AndroidException(AndroidNLS.UI_ProjectCreationSupport_NonEmptyFolder);
            }
        }
        if (androidProject.getSourceType() == AndroidProject.SourceTypes.EXISTING) {
            destination = new Path(androidProject.getLocation());
            description.setLocation((IPath)destination);
        }
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws InvocationTargetException {
                ProjectCreationSupport.createProjectAsync(project, androidProject, description, monitor, parameters, stringDictionary);
            }
        };
        created = ProjectCreationSupport.runAsyncOperation(op, container);
        return created;
    }

    protected static void createProjectAsync(IProject project, AndroidProject androidProject, IProjectDescription description, IProgressMonitor monitor, Map<String, Object> parameters, Map<String, String> stringDictionary) throws InvocationTargetException {
        monitor.beginTask(AndroidNLS.UI_ProjectCreationSupport_CopyingSamplesMonitorTaskTitle, 1000);
        try {
            try {
                project.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                if (monitor.isCanceled()) {
                    ProjectCreationSupport.undoProjectCreation(project);
                    throw new OperationCanceledException();
                }
                project.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                ProjectUtils.setupAndroidNatures(project, monitor);
                ProjectCreationSupport.createDefaultDir(project, "/", BIN_DIR, (IProgressMonitor)new SubProgressMonitor(monitor, 40));
                ProjectCreationSupport.createDefaultDir(project, "/", RES_DIR, (IProgressMonitor)new SubProgressMonitor(monitor, 40));
                ProjectCreationSupport.createDefaultDir(project, "/", ASSETS_DIR, (IProgressMonitor)new SubProgressMonitor(monitor, 40));
                ProjectCreationSupport.createDefaultDir(project, "/", GEN_DIR, (IProgressMonitor)new SubProgressMonitor(monitor, 40));
                switch (androidProject.getSourceType()) {
                    case NEW: {
                        List<String> sourceFolders = androidProject.getSourceFolders();
                        for (String sourceFolder : sourceFolders) {
                            ProjectCreationSupport.createDefaultDir(project, "/", sourceFolder, (IProgressMonitor)new SubProgressMonitor(monitor, 40));
                        }
                        int apiLevel = androidProject.getSdkTarget().getVersion().getApiLevel();
                        if (apiLevel < 4) {
                            ProjectCreationSupport.createDefaultDir(project, RES_DIR, DRAWABLE_DIR + File.separator, (IProgressMonitor)new SubProgressMonitor(monitor, 40));
                        } else {
                            String[] stringArray = DPIS;
                            int n = DPIS.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String dpi = stringArray[n2];
                                ProjectCreationSupport.createDefaultDir(project, RES_DIR, "drawable-" + dpi + File.separator, (IProgressMonitor)new SubProgressMonitor(monitor, 40));
                                ++n2;
                            }
                        }
                        ProjectCreationSupport.createDefaultDir(project, RES_DIR, LAYOUT_DIR, (IProgressMonitor)new SubProgressMonitor(monitor, 40));
                        ProjectCreationSupport.createDefaultDir(project, RES_DIR, VALUES_DIR, (IProgressMonitor)new SubProgressMonitor(monitor, 40));
                        ProjectCreationSupport.createManifest(project, parameters, stringDictionary, (IProgressMonitor)new SubProgressMonitor(monitor, 80));
                        ProjectCreationSupport.addIcon(project, apiLevel, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                        String primarySrcFolder = "src";
                        if (!sourceFolders.contains("src")) {
                            primarySrcFolder = sourceFolders.get(0);
                        }
                        ProjectCreationSupport.addInitialCode(project, primarySrcFolder, parameters, stringDictionary, (IProgressMonitor)new SubProgressMonitor(monitor, 200));
                        if (stringDictionary.size() <= 0) break;
                        DictionaryUtils.createOrUpdateDictionaryFile(project, stringDictionary, null, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                        break;
                    }
                    case EXISTING: {
                        ProjectCreationSupport.createDefaultDir(project, "/", GEN_DIR, (IProgressMonitor)new SubProgressMonitor(monitor, 650));
                        break;
                    }
                    case SAMPLE: {
                        monitor.setTaskName(AndroidNLS.UI_ProjectCreationSupport_CopyingSamplesMonitorMessage);
                        FileUtil.copyDir((File)androidProject.getSample().getFolder(), (File)project.getLocation().toFile());
                        project.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 650));
                        break;
                    }
                    case WIDGET: {
                        List<String> widgetSourceFolders = androidProject.getSourceFolders();
                        for (String sourceFolder : widgetSourceFolders) {
                            ProjectCreationSupport.createDefaultDir(project, "/", sourceFolder, (IProgressMonitor)new SubProgressMonitor(monitor, 40));
                        }
                        int widgetApiLevel = androidProject.getSdkTarget().getVersion().getApiLevel();
                        if (widgetApiLevel < 4) {
                            ProjectCreationSupport.createDefaultDir(project, RES_DIR, DRAWABLE_DIR + File.separator, (IProgressMonitor)new SubProgressMonitor(monitor, 40));
                        } else {
                            String[] stringArray = DPIS;
                            int n = DPIS.length;
                            int n3 = 0;
                            while (n3 < n) {
                                String dpi = stringArray[n3];
                                ProjectCreationSupport.createDefaultDir(project, RES_DIR, "drawable-" + dpi + File.separator, (IProgressMonitor)new SubProgressMonitor(monitor, 40));
                                ++n3;
                            }
                        }
                        ProjectCreationSupport.createDefaultDir(project, RES_DIR, LAYOUT_DIR, (IProgressMonitor)new SubProgressMonitor(monitor, 40));
                        ProjectCreationSupport.createDefaultDir(project, RES_DIR, VALUES_DIR, (IProgressMonitor)new SubProgressMonitor(monitor, 40));
                        ProjectCreationSupport.createDefaultDir(project, RES_DIR, XML_DIR, (IProgressMonitor)new SubProgressMonitor(monitor, 40));
                        ProjectCreationSupport.createWidgetManifest(project, parameters, stringDictionary, (IProgressMonitor)new SubProgressMonitor(monitor, 80));
                        ProjectCreationSupport.addIcon(project, widgetApiLevel, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                        String widgetPrimarySrcFolder = "src";
                        if (!widgetSourceFolders.contains("src")) {
                            String string = widgetSourceFolders.get(0);
                        }
                        ProjectCreationSupport.addInitialWidgetCode(project, widgetPrimarySrcFolder, parameters, stringDictionary, (IProgressMonitor)new SubProgressMonitor(monitor, 200));
                        if (stringDictionary.size() <= 0) break;
                        DictionaryUtils.createOrUpdateDictionaryFile(project, stringDictionary, null, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                    }
                }
                IJavaProject javaProject = JavaCore.create((IProject)project);
                ProjectCreationSupport.setupSourceFolders(javaProject, androidProject.getSourceFolders(), (IProgressMonitor)new SubProgressMonitor(monitor, 40));
                javaProject.setOutputLocation(project.getFolder(BIN_DIR).getFullPath(), (IProgressMonitor)new SubProgressMonitor(monitor, 40));
                SdkUtils.associate(project, androidProject.getSdkTarget());
                ProjectUtils.fixProject(project);
            }
            catch (CoreException e) {
                ProjectCreationSupport.undoProjectCreation(project);
                throw new InvocationTargetException(e);
            }
            catch (IOException e) {
                ProjectCreationSupport.undoProjectCreation(project);
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    private static void addInitialCode(IProject project, String sourceFolder, Map<String, Object> parameters, Map<String, String> stringDictionary, IProgressMonitor monitor) throws CoreException, IOException {
        monitor.beginTask(AndroidNLS.UI_ProjectCreationSupport_Configuring_Sample_Source_Task, 700);
        try {
            IFolder layoutfolder;
            IFile file;
            IFolder pkgFolder = project.getFolder(sourceFolder);
            Map<String, Object> processed_parameters = ProjectCreationSupport.processSampleActivity(parameters);
            String activityName = (String)processed_parameters.get(ACTIVITY_NAME);
            String packageName = (String)processed_parameters.get(PACKAGE_NAME);
            pkgFolder = ProjectCreationSupport.createPackageFolders((IProgressMonitor)new SubProgressMonitor(monitor, 300), pkgFolder, packageName);
            if (activityName != null) {
                ProjectCreationSupport.createSampleActivity((IProgressMonitor)new SubProgressMonitor(monitor, 200), pkgFolder, processed_parameters, activityName);
            }
            if (!(file = (layoutfolder = project.getFolder("res/layout/")).getFile(MAIN_LAYOUT_XML)).exists()) {
                ProjectCreationSupport.copyTemplateFile(LAYOUT_TEMPLATE, file, parameters, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                if (activityName != null) {
                    stringDictionary.put(STRING_HELLO_WORLD, NLS.bind((String)AndroidNLS.GEN_ProjectCreationSupport_HelloWorldWithName, (Object)activityName));
                } else {
                    stringDictionary.put(STRING_HELLO_WORLD, AndroidNLS.GEN_ProjectCreationSupport_HelloWorldSimple);
                }
                monitor.worked(100);
            }
        }
        finally {
            monitor.done();
        }
    }

    private static void addInitialWidgetCode(IProject project, String sourceFolder, Map<String, Object> parameters, Map<String, String> stringDictionary, IProgressMonitor monitor) throws CoreException, IOException {
        monitor.beginTask(AndroidNLS.UI_ProjectCreationSupport_Configuring_Sample_Source_Task, 800);
        try {
            IFolder xmlFolder;
            IFile widget_info_file;
            IFile initial_layout_file;
            IFolder pkgFolder = project.getFolder(sourceFolder);
            Map<String, Object> processed_parameters = ProjectCreationSupport.processSampleActivity(parameters);
            String activityName = (String)processed_parameters.get(ACTIVITY_NAME);
            String packageName = (String)processed_parameters.get(PACKAGE_NAME);
            pkgFolder = ProjectCreationSupport.createPackageFolders((IProgressMonitor)new SubProgressMonitor(monitor, 200), pkgFolder, packageName);
            if (activityName != null) {
                ProjectCreationSupport.createSampleActivity((IProgressMonitor)new SubProgressMonitor(monitor, 100), pkgFolder, processed_parameters, activityName);
            }
            ProjectCreationSupport.createSampleWidgetProvider((IProgressMonitor)new SubProgressMonitor(monitor, 100), pkgFolder, processed_parameters);
            IFolder layoutfolder = project.getFolder("res/layout/");
            IFile file = layoutfolder.getFile(MAIN_LAYOUT_XML);
            if (!file.exists()) {
                ProjectCreationSupport.copyTemplateFile(LAYOUT_TEMPLATE, file, parameters, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                if (activityName != null) {
                    stringDictionary.put(STRING_HELLO_WORLD, NLS.bind((String)AndroidNLS.GEN_ProjectCreationSupport_HelloWorldWithName, (Object)activityName));
                } else {
                    stringDictionary.put(STRING_HELLO_WORLD, AndroidNLS.GEN_ProjectCreationSupport_HelloWorldSimple);
                }
                monitor.worked(100);
            }
            if (!(initial_layout_file = layoutfolder.getFile(WIDGET_INITIAL_LAYOUT_XML)).exists()) {
                ProjectCreationSupport.copyWidgetTemplateFile(WIDGET_INITIAL_LAYOUT_XML, initial_layout_file, processed_parameters, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                monitor.worked(100);
            }
            if (!(widget_info_file = (xmlFolder = project.getFolder("res/xml/")).getFile(WIDGET_INFO_XML)).exists()) {
                ProjectCreationSupport.copyWidgetTemplateFile(WIDGET_INFO_XML, widget_info_file, processed_parameters, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                monitor.worked(100);
            }
        }
        finally {
            monitor.done();
        }
    }

    private static void createSampleActivity(IProgressMonitor monitor, IFolder pkgFolder, Map<String, Object> processed_parameters, String activityName) throws CoreException, IOException {
        monitor.beginTask(AndroidNLS.UI_ProjectCreationSupport_Configuring_Sample_Activity_Task, 100);
        try {
            IFile file = pkgFolder.getFile(String.valueOf(activityName) + ".java");
            if (!file.exists()) {
                monitor.worked(10);
                ProjectCreationSupport.copyTemplateFile(JAVA_ACTIVITY_TEMPLATE, file, processed_parameters, (IProgressMonitor)new SubProgressMonitor(monitor, 90));
            }
        }
        finally {
            monitor.done();
        }
    }

    private static void createSampleWidgetProvider(IProgressMonitor monitor, IFolder pkgFolder, Map<String, Object> processed_parameters) throws CoreException, IOException {
        monitor.beginTask(AndroidNLS.UI_ProjectCreationSupport_Configuring_Sample_Widget_Provider, 100);
        try {
            IFile file = pkgFolder.getFile("WidgetProvider.java");
            if (!file.exists()) {
                monitor.worked(10);
                ProjectCreationSupport.copyWidgetTemplateFile(WIDGET_PROVIDER_SAMPLE_TEMPLATE, file, processed_parameters, (IProgressMonitor)new SubProgressMonitor(monitor, 90));
            }
        }
        finally {
            monitor.done();
        }
    }

    private static IFolder createPackageFolders(IProgressMonitor monitor, IFolder pkgFolder, String packageName) throws CoreException {
        String[] components = packageName.split("\\.");
        monitor.beginTask(AndroidNLS.UI_ProjectCreationSupport_Preparing_Java_Packages_Task, components.length * 100);
        try {
            String[] stringArray = components;
            int n = components.length;
            int n2 = 0;
            while (n2 < n) {
                String component = stringArray[n2];
                if (!(pkgFolder = pkgFolder.getFolder(component)).exists()) {
                    pkgFolder.create(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                }
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
        return pkgFolder;
    }

    private static Map<String, Object> processSampleActivity(Map<String, Object> parameters) {
        String activityName = (String)parameters.get(ACTIVITY_NAME);
        HashMap<String, Object> processed_parameters = new HashMap<String, Object>(parameters);
        if (activityName != null && activityName.contains(".")) {
            String packageName = (String)parameters.get(PACKAGE_NAME);
            packageName = String.valueOf(packageName) + "." + activityName.substring(0, activityName.lastIndexOf(46));
            activityName = activityName.substring(activityName.lastIndexOf(46));
            processed_parameters.put(PACKAGE_NAME, packageName);
            processed_parameters.put(ACTIVITY_NAME, activityName);
        }
        return processed_parameters;
    }

    private static void copyTemplateFile(String resourceFilename, IFile destFile, Map<String, Object> parameters, IProgressMonitor monitor) throws CoreException, IOException {
        monitor.beginTask(AndroidNLS.UI_ProjectCreationSupport_Preparing_Template_File_Task, 150);
        InputStream stream = null;
        try {
            String template = ProjectCreationSupport.readEmbeddedTextFileADT(TEMPLATES_DIRECTORY + resourceFilename, parameters);
            monitor.worked(50);
            stream = new ByteArrayInputStream(template.getBytes("UTF-8"));
            destFile.create(stream, false, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
        }
        finally {
            if (stream != null) {
                stream.close();
            }
            monitor.done();
        }
    }

    private static void copyWidgetTemplateFile(String resourceFilename, IFile destFile, Map<String, Object> parameters, IProgressMonitor monitor) throws CoreException, IOException {
        monitor.beginTask(AndroidNLS.UI_ProjectCreationSupport_Preparing_Template_File_Task, 150);
        InputStream stream = null;
        try {
            String template = ProjectCreationSupport.readEmbeddedTextFileStudio(WIDGET_TEMPLATE_FOLDER + resourceFilename, parameters);
            monitor.worked(50);
            stream = new ByteArrayInputStream(template.getBytes("UTF-8"));
            destFile.create(stream, false, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
        }
        finally {
            if (stream != null) {
                stream.close();
            }
            monitor.done();
        }
    }

    private static void addIcon(IProject project, int apiLevel, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(AndroidNLS.UI_ProjectCreationSupport_Configuring_Project_Icon_Task, 1000);
        try {
            if (apiLevel < 4) {
                IFile imageFile = project.getFile("res//drawable/ic_launcher.png");
                if (!imageFile.exists()) {
                    String fileName = String.valueOf(ICON.substring(0, ICON.length() - 4)) + "_" + DPIS[2] + ICON.substring(ICON.length() - 4);
                    ProjectCreationSupport.createImageFromTemplate(monitor, imageFile, fileName);
                }
            } else {
                String[] stringArray = DPIS;
                int n = DPIS.length;
                int n2 = 0;
                while (n2 < n) {
                    String dpi = stringArray[n2];
                    IFile imageFile = project.getFile("res//drawable-" + dpi + '/' + ICON);
                    if (!imageFile.exists()) {
                        String fileName = String.valueOf(ICON.substring(0, ICON.length() - 4)) + "_" + dpi + ICON.substring(ICON.length() - 4);
                        ProjectCreationSupport.createImageFromTemplate(monitor, imageFile, fileName);
                    }
                    ++n2;
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    private static void createImageFromTemplate(IProgressMonitor monitor, IFile imageFile, String fileName) throws CoreException {
        byte[] buffer = AndmoreAndroidPlugin.readEmbeddedFile((String)(TEMPLATES_DIRECTORY + fileName));
        if (buffer != null) {
            ByteArrayInputStream stream = null;
            try {
                stream = new ByteArrayInputStream(buffer);
                imageFile.create((InputStream)stream, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            }
            finally {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException e) {
                    AndmoreLogger.info((String)("Create image from template could not close stream. " + e.getMessage()));
                }
            }
        }
    }

    private static void createManifest(IProject project, Map<String, Object> parameters, Map<String, String> stringDictionary, IProgressMonitor monitor) throws CoreException, IOException {
        block15: {
            monitor.beginTask(AndroidNLS.UI_ProjectCreationSupport_Creating_Manifest_File_Task, 300);
            try {
                IFile manifestFile = project.getFile("AndroidManifest.xml");
                if (manifestFile.exists()) break block15;
                monitor.setTaskName(AndroidNLS.UI_ProjectCreationSupport_Reading_Template_File_Task);
                String manifestTemplate = ProjectCreationSupport.readEmbeddedTextFileADT(MANIFEST_TEMPLATE, parameters);
                monitor.worked(10);
                if (parameters.containsKey(ACTIVITY_NAME)) {
                    String activities = ProjectCreationSupport.readEmbeddedTextFileADT(ACTIVITY_TEMPLATE, parameters);
                    String intent = AndmoreAndroidPlugin.readEmbeddedTextFile((String)LAUNCHER_INTENT_TEMPLATE);
                    activities = activities.replaceAll(INTENT_FILTERS, intent);
                    manifestTemplate = manifestTemplate.replaceAll(ACTIVITIES, activities);
                    monitor.worked(90);
                } else {
                    manifestTemplate = manifestTemplate.replaceAll(ACTIVITIES, "");
                    monitor.worked(90);
                }
                manifestTemplate = manifestTemplate.replaceAll(TEST_USES_LIBRARY, "");
                manifestTemplate = manifestTemplate.replaceAll(TEST_INSTRUMENTATION, "");
                String minSdkVersion = (String)parameters.get(MIN_SDK_VERSION);
                if (minSdkVersion != null && minSdkVersion.length() > 0) {
                    String usesSdk = ProjectCreationSupport.readEmbeddedTextFileADT(USES_SDK_TEMPLATE, parameters);
                    manifestTemplate = manifestTemplate.replaceAll(USES_SDK, usesSdk);
                    monitor.worked(50);
                } else {
                    manifestTemplate = manifestTemplate.replaceAll(USES_SDK, "");
                    monitor.worked(50);
                }
                ByteArrayInputStream stream = null;
                try {
                    stream = new ByteArrayInputStream(manifestTemplate.getBytes("UTF-8"));
                    manifestFile.create((InputStream)stream, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 150));
                }
                finally {
                    try {
                        if (stream != null) {
                            ((InputStream)stream).close();
                        }
                    }
                    catch (IOException e) {
                        AndmoreLogger.info((String)"Could not close stream while creating manifest", (String)e.getMessage());
                    }
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private static void createWidgetManifest(IProject project, Map<String, Object> parameters, Map<String, String> stringDictionary, IProgressMonitor monitor) throws CoreException, IOException {
        block15: {
            monitor.beginTask(AndroidNLS.UI_ProjectCreationSupport_Creating_Manifest_File_Task, 300);
            try {
                IFile manifestFile = project.getFile("AndroidManifest.xml");
                if (manifestFile.exists()) break block15;
                monitor.setTaskName(AndroidNLS.UI_ProjectCreationSupport_Reading_Template_File_Task);
                String manifestTemplate = ProjectCreationSupport.readEmbeddedTextFileStudio(WIDGET_MANIFEST_TEMPLATE_PATH, parameters);
                monitor.worked(10);
                if (parameters.containsKey(ACTIVITY_NAME)) {
                    String activities = ProjectCreationSupport.readEmbeddedTextFileStudio(WIDGET_ACTIVITY_TEMPLATE_PATH, parameters);
                    manifestTemplate = manifestTemplate.replaceAll(ACTIVITIES, activities);
                    monitor.worked(70);
                } else {
                    manifestTemplate = manifestTemplate.replaceAll(ACTIVITIES, "");
                    monitor.worked(70);
                }
                String receivers = ProjectCreationSupport.readEmbeddedTextFileStudio(WIDGET_RECEIVER_TEMPLATE_PATH, parameters);
                manifestTemplate = manifestTemplate.replaceAll(RECEIVERS, receivers);
                monitor.worked(70);
                String minSdkVersion = (String)parameters.get(MIN_SDK_VERSION);
                if (minSdkVersion != null && minSdkVersion.length() > 0) {
                    String usesSdk = ProjectCreationSupport.readEmbeddedTextFileStudio(WIDGET_USES_SDK_TEMPLATE_PATH, parameters);
                    manifestTemplate = manifestTemplate.replaceAll(USES_SDK, usesSdk);
                    monitor.worked(50);
                } else {
                    manifestTemplate = manifestTemplate.replaceAll(USES_SDK, "");
                    monitor.worked(50);
                }
                ByteArrayInputStream stream = null;
                try {
                    stream = new ByteArrayInputStream(manifestTemplate.getBytes("UTF-8"));
                    manifestFile.create((InputStream)stream, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                }
                finally {
                    try {
                        if (stream != null) {
                            ((InputStream)stream).close();
                        }
                    }
                    catch (IOException e) {
                        AndmoreLogger.info((String)"Could not close stream while creating manifest for widget", (String)e.getMessage());
                    }
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private static String readEmbeddedTextFileADT(String template, Map<String, Object> parameters) {
        String loadedTemplate = AndmoreAndroidPlugin.readEmbeddedTextFile((String)template);
        for (String key : parameters.keySet()) {
            if (!(parameters.get(key) instanceof String)) continue;
            loadedTemplate = loadedTemplate.replaceAll(key, (String)parameters.get(key));
        }
        return loadedTemplate;
    }

    private static String readEmbeddedTextFileStudio(String template, Map<String, Object> parameters) {
        String loadedTemplate = EclipseUtils.readEmbeddedResource((Bundle)AndroidPlugin.getDefault().getBundle(), (String)template);
        for (String key : parameters.keySet()) {
            if (!(parameters.get(key) instanceof String)) continue;
            loadedTemplate = loadedTemplate.replaceAll(key, (String)parameters.get(key));
        }
        return loadedTemplate;
    }

    private static void setupSourceFolders(IJavaProject javaProject, List<String> sourceFolders, IProgressMonitor monitor) throws JavaModelException {
        monitor.beginTask(AndroidNLS.UI_ProjectCreationSupport_Preparing_Source_Folders_Task, sourceFolders.size() * 100 + 100);
        try {
            IProject project = javaProject.getProject();
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            for (String sourceFolder : sourceFolders) {
                IFolder srcFolder = project.getFolder(sourceFolder);
                entries = ProjectCreationSupport.removeClasspathEntry(entries, (IContainer)srcFolder);
                entries = ProjectCreationSupport.removeClasspathEntry(entries, srcFolder.getParent());
                entries = ProjectUtils.addEntryToClasspath(entries, JavaCore.newSourceEntry((IPath)srcFolder.getFullPath()));
                monitor.worked(100);
            }
            javaProject.setRawClasspath(entries, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
        }
        finally {
            monitor.done();
        }
    }

    private static IClasspathEntry[] removeClasspathEntry(IClasspathEntry[] entries, IContainer folder) {
        IClasspathEntry[] newClassPath = null;
        if (folder != null) {
            IClasspathEntry removeEntry = JavaCore.newSourceEntry((IPath)folder.getFullPath());
            List<IClasspathEntry> entriesList = Arrays.asList(entries);
            if (entriesList.contains(removeEntry)) {
                newClassPath = new IClasspathEntry[entries.length - 1];
                int i = 0;
                for (IClasspathEntry entry : entriesList) {
                    if (entry.equals(removeEntry)) continue;
                    newClassPath[i] = entry;
                    ++i;
                }
            } else {
                newClassPath = entries;
            }
        } else {
            newClassPath = entries;
        }
        return newClassPath;
    }

    private static void createDefaultDir(IProject project, String parentFolder, String folderName, IProgressMonitor monitor) throws CoreException {
        block4: {
            monitor.beginTask(String.valueOf(AndroidNLS.UI_ProjectCreationSupport_Creating_Directory_Task) + folderName, 100);
            try {
                monitor.setTaskName(AndroidNLS.UI_ProjectCreationSupport_Verifying_Directory_Task);
                if (folderName.length() <= 0) break block4;
                monitor.worked(10);
                IFolder folder = project.getFolder(String.valueOf(parentFolder) + folderName);
                monitor.worked(10);
                if (folder.exists()) break block4;
                monitor.worked(10);
                if (FileUtil.canWrite((File)folder.getLocation().toFile())) {
                    monitor.worked(10);
                    monitor.setTaskName(AndroidNLS.UI_ProjectCreationSupport_Creating_Directory_Task);
                    folder.create(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 60));
                    break block4;
                }
                String errMsg = NLS.bind((String)AndroidNLS.EXC_ProjectCreationSupport_CannotCreateFolderReadOnlyWorkspace, (Object)folder.getLocation().toFile().toString());
                AndroidStatus status = new AndroidStatus(4, errMsg);
                throw new CoreException((IStatus)status);
            }
            finally {
                monitor.done();
            }
        }
    }

    public static boolean validateNewProjectLocationIsEmpty(IPath destination) {
        File f = new File(destination.toOSString());
        return !f.isDirectory() || f.list().length <= 0;
    }

    private static boolean runAsyncOperation(WorkspaceModifyOperation op, IWizardContainer container) {
        boolean created = false;
        try {
            container.run(true, true, (IRunnableWithProgress)op);
            created = true;
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t instanceof CoreException) {
                CoreException core = (CoreException)t;
                if (core.getStatus().getCode() == 275) {
                    MessageDialog.openError((Shell)container.getShell(), (String)AndroidNLS.UI_GenericErrorDialogTitle, (String)AndroidNLS.ERR_ProjectCreationSupport_CaseVariantExistsError);
                } else {
                    ErrorDialog.openError((Shell)container.getShell(), (String)AndroidNLS.UI_GenericErrorDialogTitle, null, (IStatus)core.getStatus());
                }
            } else {
                MessageDialog.openError((Shell)container.getShell(), (String)AndroidNLS.UI_GenericErrorDialogTitle, (String)t.getMessage());
            }
        }
        catch (InterruptedException e) {
            AndmoreLogger.error(ProjectCreationSupport.class, (String)"Error creating project.", (Throwable)e);
        }
        return created;
    }

    private static boolean canCreateProject(IWorkspaceRoot root, String projectName) {
        File rootFolder = root.getLocation().toFile();
        File projectFolder = new File(rootFolder, projectName);
        return FileUtil.canWrite((File)projectFolder);
    }

    private static void undoProjectCreation(IProject project) {
        File projectPath = new File(project.getWorkspace().getRoot().getLocation().toFile(), project.getName());
        Set<String> existingResources = ProjectCreationSupport.getExistingResources(projectPath);
        try {
            project.delete(false, true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e1) {
            AndmoreLogger.error(ProjectCreationSupport.class, (String)e1.getLocalizedMessage(), (Throwable)e1);
        }
        if (existingResources.isEmpty()) {
            try {
                FileUtil.deleteDirRecursively((File)project.getLocation().toFile());
            }
            catch (IOException e) {
                AndmoreLogger.error(ProjectCreationSupport.class, (String)e.getLocalizedMessage(), (Throwable)e);
            }
        } else {
            File root = new File(project.getWorkspace().getRoot().getLocation().toFile(), project.getName());
            ProjectCreationSupport.removeCreatedResources(root, existingResources);
        }
    }

    private static Set<String> getExistingResources(File folder) {
        HashSet<String> existing = new HashSet<String>();
        if (folder != null && folder.exists() && folder.isDirectory()) {
            existing.add(folder.toString());
            File[] children = folder.listFiles();
            if (children != null) {
                File[] fileArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    if (child.isDirectory()) {
                        existing.addAll(ProjectCreationSupport.getExistingResources(child));
                    } else {
                        existing.add(child.toString());
                    }
                    ++n2;
                }
            }
        }
        return existing;
    }

    private static void removeCreatedResources(File startingPoint, Set<String> existingResources) {
        File[] members = startingPoint.listFiles();
        if (members != null) {
            File[] fileArray = members;
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isFile()) {
                    if (!existingResources.contains(child.toString())) {
                        child.delete();
                    }
                } else {
                    ProjectCreationSupport.removeCreatedResources(child, existingResources);
                }
                ++n2;
            }
        }
        if (!existingResources.contains(startingPoint.toString())) {
            startingPoint.delete();
        }
    }
}

