/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.gltrace;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.andmore.gltrace.TraceOptions;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.BackingStoreException;

public class GLTraceOptionsDialog
extends TitleAreaDialog {
    private static final String TITLE = "OpenGL ES Trace Options";
    private static final String DEFAULT_MESSAGE = "Provide the application and activity to be traced.";
    private static final String PREF_APP_PACKAGE = "gl.trace.apppackage";
    private static final String PREF_ACTIVITY = "gl.trace.activity";
    private static final String PREF_TRACEFILE = "gl.trace.destfile";
    private static final String PREF_DEVICE = "gl.trace.device";
    private String mLastUsedDevice;
    private static String sSaveToFolder = System.getProperty("user.home");
    private Button mOkButton;
    private Combo mDeviceCombo;
    private Text mAppPackageToTraceText;
    private Text mActivityToTraceText;
    private Button mIsActivityFullyQualifiedButton;
    private Text mTraceFilePathText;
    private String mSelectedDevice = "";
    private String mAppPackageToTrace = "";
    private String mActivityToTrace = "";
    private String mTraceFilePath = "";
    private boolean mAllowAppSelection;
    private static boolean sCollectFbOnEglSwap = true;
    private static boolean sCollectFbOnGlDraw = false;
    private static boolean sCollectTextureData = false;
    private static boolean sIsActivityFullyQualified = false;
    private IDevice[] mDevices;

    public GLTraceOptionsDialog(Shell parentShell) {
        this(parentShell, true, null);
    }

    public GLTraceOptionsDialog(Shell parentShell, boolean allowAppSelection, String appToTrace) {
        super(parentShell);
        this.loadPreferences();
        this.mAllowAppSelection = allowAppSelection;
        if (appToTrace != null) {
            this.mAppPackageToTrace = appToTrace;
        }
    }

    protected Control createDialogArea(Composite shell) {
        this.setTitle(TITLE);
        this.setMessage(DEFAULT_MESSAGE);
        Composite parent = (Composite)super.createDialogArea(shell);
        Composite c = new Composite(parent, 2048);
        c.setLayout((Layout)new GridLayout(2, false));
        c.setLayoutData((Object)new GridData(1808));
        this.createLabel(c, "Device:");
        this.mDevices = AndroidDebugBridge.getBridge().getDevices();
        this.createDeviceDropdown(c, this.mDevices);
        this.createSeparator(c);
        this.createLabel(c, "Application Package:");
        this.createAppToTraceText(c, "e.g. com.example.package");
        this.createLabel(c, "Activity to launch:");
        this.createActivityToTraceText(c, "Leave blank to launch default activity");
        this.createLabel(c, "");
        this.createIsFullyQualifedActivityButton(c, "Activity name is fully qualified, do not prefix with package name");
        if (!this.mAllowAppSelection) {
            this.mAppPackageToTraceText.setEnabled(false);
            this.mActivityToTraceText.setEnabled(false);
            this.mIsActivityFullyQualifiedButton.setEnabled(false);
        }
        this.createSeparator(c);
        this.createLabel(c, "Data Collection Options:");
        this.createCaptureImageOptions(c);
        this.createSeparator(c);
        this.createLabel(c, "Destination File: ");
        this.createSaveToField(c);
        return c;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.mOkButton = this.getButton(0);
        this.mOkButton.setText("Trace");
        DialogStatus status = this.validateDialog();
        this.mOkButton.setEnabled(status.valid);
    }

    private void createSeparator(Composite c) {
        Label l = new Label(c, 258);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
    }

    private void createSaveToField(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(2, false));
        c.setLayoutData((Object)new GridData(1808));
        this.mTraceFilePathText = new Text(c, 2048);
        this.mTraceFilePathText.setLayoutData((Object)new GridData(768));
        this.mTraceFilePathText.setText(this.mTraceFilePath);
        this.mTraceFilePathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GLTraceOptionsDialog.this.validateAndSetMessage();
            }
        });
        Button browse = new Button(c, 8);
        browse.setText("Browse...");
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String fName = GLTraceOptionsDialog.this.openBrowseDialog();
                if (fName == null) {
                    return;
                }
                GLTraceOptionsDialog.this.mTraceFilePathText.setText(fName);
                GLTraceOptionsDialog.this.validateAndSetMessage();
            }
        });
    }

    private String openBrowseDialog() {
        FileDialog fd = new FileDialog(Display.getDefault().getActiveShell(), 8192);
        fd.setText("Save To");
        fd.setFileName("trace1.gltrace");
        fd.setFilterPath(sSaveToFolder);
        fd.setFilterExtensions(new String[]{"*.gltrace"});
        String fname = fd.open();
        if (fname == null || fname.trim().length() == 0) {
            return null;
        }
        sSaveToFolder = fd.getFilterPath();
        return fname;
    }

    private void createCaptureImageOptions(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(1, false));
        c.setLayoutData((Object)new GridData(1808));
        final Button readFbOnEglSwapCheckBox = new Button(c, 32);
        readFbOnEglSwapCheckBox.setText("Read back framebuffer 0 on eglSwapBuffers()");
        readFbOnEglSwapCheckBox.setSelection(sCollectFbOnEglSwap);
        final Button readFbOnGlDrawCheckBox = new Button(c, 32);
        readFbOnGlDrawCheckBox.setText("Read back currently bound framebuffer On glDraw*()");
        readFbOnGlDrawCheckBox.setSelection(sCollectFbOnGlDraw);
        final Button readTextureDataCheckBox = new Button(c, 32);
        readTextureDataCheckBox.setText("Collect texture data submitted using glTexImage*()");
        readTextureDataCheckBox.setSelection(sCollectTextureData);
        SelectionAdapter l = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                sCollectFbOnEglSwap = readFbOnEglSwapCheckBox.getSelection();
                sCollectFbOnGlDraw = readFbOnGlDrawCheckBox.getSelection();
                sCollectTextureData = readTextureDataCheckBox.getSelection();
            }
        };
        readFbOnEglSwapCheckBox.addSelectionListener((SelectionListener)l);
        readFbOnGlDrawCheckBox.addSelectionListener((SelectionListener)l);
        readTextureDataCheckBox.addSelectionListener((SelectionListener)l);
    }

    private Text createAppToTraceText(Composite parent, String defaultMessage) {
        this.mAppPackageToTraceText = new Text(parent, 2048);
        this.mAppPackageToTraceText.setMessage(defaultMessage);
        this.mAppPackageToTraceText.setText(this.mAppPackageToTrace);
        this.mAppPackageToTraceText.setLayoutData((Object)new GridData(768));
        this.mAppPackageToTraceText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GLTraceOptionsDialog.this.validateAndSetMessage();
            }
        });
        return this.mActivityToTraceText;
    }

    private Text createActivityToTraceText(Composite parent, String defaultMessage) {
        this.mActivityToTraceText = new Text(parent, 2048);
        this.mActivityToTraceText.setMessage(defaultMessage);
        this.mActivityToTraceText.setText(this.mActivityToTrace);
        this.mActivityToTraceText.setLayoutData((Object)new GridData(768));
        this.mActivityToTraceText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GLTraceOptionsDialog.this.validateAndSetMessage();
            }
        });
        return this.mActivityToTraceText;
    }

    private Button createIsFullyQualifedActivityButton(Composite parent, String message) {
        this.mIsActivityFullyQualifiedButton = new Button(parent, 32);
        this.mIsActivityFullyQualifiedButton.setText(message);
        this.mIsActivityFullyQualifiedButton.setLayoutData((Object)new GridData(768));
        this.mIsActivityFullyQualifiedButton.setSelection(sIsActivityFullyQualified);
        return this.mIsActivityFullyQualifiedButton;
    }

    private void validateAndSetMessage() {
        DialogStatus status = this.validateDialog();
        this.mOkButton.setEnabled(status.valid);
        this.setErrorMessage(status.message);
    }

    private Combo createDeviceDropdown(Composite parent, IDevice[] devices) {
        this.mDeviceCombo = new Combo(parent, 2056);
        ArrayList<String> items = new ArrayList<String>(devices.length);
        IDevice[] iDeviceArray = devices;
        int n = devices.length;
        int n2 = 0;
        while (n2 < n) {
            IDevice d = iDeviceArray[n2];
            items.add(d.getName());
            ++n2;
        }
        this.mDeviceCombo.setItems(items.toArray(new String[items.size()]));
        int index = 0;
        if (items.contains(this.mLastUsedDevice)) {
            index = items.indexOf(this.mLastUsedDevice);
        }
        if (index >= 0 && index < items.size()) {
            this.mDeviceCombo.select(index);
        }
        return this.mDeviceCombo;
    }

    private void createLabel(Composite parent, String text) {
        Label l = new Label(parent, 0);
        l.setText(text);
        GridData gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.verticalAlignment = 0x1000000;
        l.setLayoutData((Object)gd);
    }

    private DialogStatus validateDialog() {
        if (this.mDevices.length == 0) {
            return new DialogStatus(false, "No connected devices.");
        }
        if (this.mAppPackageToTraceText.getText().trim().isEmpty()) {
            return new DialogStatus(false, "Provide an application name");
        }
        String traceFile = this.mTraceFilePathText.getText().trim();
        if (traceFile.isEmpty()) {
            return new DialogStatus(false, "Specify the location where the trace will be saved.");
        }
        File f = new File(traceFile).getParentFile();
        if (f != null && !f.exists()) {
            return new DialogStatus(false, String.format("Folder %s does not exist", f.getAbsolutePath()));
        }
        return new DialogStatus(true, null);
    }

    protected void okPressed() {
        this.mAppPackageToTrace = this.mAppPackageToTraceText.getText().trim();
        this.mActivityToTrace = this.mActivityToTraceText.getText().trim();
        if (this.mActivityToTrace.startsWith(".")) {
            this.mActivityToTrace = this.mActivityToTrace.substring(1);
        }
        sIsActivityFullyQualified = this.mIsActivityFullyQualifiedButton.getSelection();
        this.mTraceFilePath = this.mTraceFilePathText.getText().trim();
        this.mSelectedDevice = this.mDeviceCombo.getText();
        this.savePreferences();
        super.okPressed();
    }

    private void savePreferences() {
        IEclipsePreferences prefs = new InstanceScope().getNode("org.eclipse.andmore.gldebugger");
        prefs.put(PREF_APP_PACKAGE, this.mAppPackageToTrace);
        prefs.put(PREF_ACTIVITY, this.mActivityToTrace);
        prefs.put(PREF_TRACEFILE, this.mTraceFilePath);
        prefs.put(PREF_DEVICE, this.mSelectedDevice);
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    private void loadPreferences() {
        IEclipsePreferences prefs = new InstanceScope().getNode("org.eclipse.andmore.gldebugger");
        this.mAppPackageToTrace = prefs.get(PREF_APP_PACKAGE, "");
        this.mActivityToTrace = prefs.get(PREF_ACTIVITY, "");
        this.mTraceFilePath = prefs.get(PREF_TRACEFILE, "");
        this.mLastUsedDevice = prefs.get(PREF_DEVICE, "");
    }

    public TraceOptions getTraceOptions() {
        return new TraceOptions(this.mSelectedDevice, this.mAppPackageToTrace, this.mActivityToTrace, sIsActivityFullyQualified, this.mTraceFilePath, sCollectFbOnEglSwap, sCollectFbOnGlDraw, sCollectTextureData);
    }

    private final class DialogStatus {
        final boolean valid;
        final String message;

        private DialogStatus(boolean isValid, String errMessage) {
            this.valid = isValid;
            this.message = errMessage;
        }
    }
}

