/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.gltrace.state;

import org.eclipse.andmore.gltrace.state.GLAbstractAtomicProperty;
import org.eclipse.andmore.gltrace.state.GLStateType;

public class GLFloatProperty
extends GLAbstractAtomicProperty {
    private final Float mDefaultValue;
    private Float mCurrentValue;

    public GLFloatProperty(GLStateType name, Float defaultValue) {
        super(name);
        this.mDefaultValue = this.mCurrentValue = defaultValue;
    }

    @Override
    public boolean isDefault() {
        return (double)Math.abs(this.mCurrentValue.floatValue() - this.mDefaultValue.floatValue()) < 1.0E-9;
    }

    public void setValue(Float newValue) {
        this.mCurrentValue = newValue;
    }

    @Override
    public void setValue(Object value) {
        if (!(value instanceof Float)) {
            throw new IllegalArgumentException("Attempt to set non float value for " + (Object)((Object)this.getType()));
        }
        this.mCurrentValue = (Float)value;
    }

    @Override
    public Object getValue() {
        return this.mCurrentValue;
    }

    @Override
    public String getStringValue() {
        return this.mCurrentValue.toString();
    }

    public String toString() {
        return (Object)((Object)this.getType()) + "=" + this.getStringValue();
    }
}

