/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.common.layout;

import com.android.ide.common.api.DrawingStyle;
import com.android.ide.common.api.DropFeedback;
import com.android.ide.common.api.IDragElement;
import com.android.ide.common.api.IFeedbackPainter;
import com.android.ide.common.api.IGraphics;
import com.android.ide.common.api.INode;
import com.android.ide.common.api.INodeHandler;
import com.android.ide.common.api.IViewMetadata;
import com.android.ide.common.api.InsertType;
import com.android.ide.common.api.Point;
import com.android.ide.common.api.Rect;
import com.android.ide.common.api.RuleAction;
import com.android.utils.Pair;
import java.util.List;
import java.util.Map;
import org.eclipse.andmore.common.layout.BaseLayoutRule;

public class FrameLayoutRule
extends BaseLayoutRule {
    public DropFeedback onDropEnter(INode targetNode, Object targetView, final IDragElement[] elements) {
        if (elements.length == 0) {
            return null;
        }
        return new DropFeedback(null, new IFeedbackPainter(){

            public void paint(IGraphics gc, INode node, DropFeedback feedback) {
                FrameLayoutRule.this.drawFeedback(gc, node, elements, feedback);
            }
        });
    }

    protected void drawFeedback(IGraphics gc, INode targetNode, IDragElement[] elements, DropFeedback feedback) {
        Rect b = targetNode.getBounds();
        if (!b.isValid()) {
            return;
        }
        gc.useStyle(DrawingStyle.DROP_RECIPIENT);
        gc.drawRect(b);
        Point p = (Point)feedback.userData;
        if (p == null) {
            return;
        }
        Rect be = elements[0].getBounds();
        gc.useStyle(DrawingStyle.DROP_PREVIEW);
        if (be.isValid()) {
            IDragElement[] iDragElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IDragElement it = iDragElementArray[n2];
                Rect currBounds = it.getBounds();
                if (currBounds.isValid()) {
                    int offsetX = b.x - currBounds.x;
                    int offsetY = b.y - currBounds.y;
                    this.drawElement(gc, it, offsetX, offsetY);
                }
                ++n2;
            }
        } else {
            gc.drawLine(b.x + 1, b.y, b.x + 1, b.y + b.h);
            gc.drawLine(b.x, b.y + 1, b.x + b.w, b.y + 1);
        }
    }

    public DropFeedback onDropMove(INode targetNode, IDragElement[] elements, DropFeedback feedback, Point p) {
        feedback.userData = p;
        feedback.requestPaint = true;
        return feedback;
    }

    public void onDropLeave(INode targetNode, IDragElement[] elements, DropFeedback feedback) {
    }

    public void onDropped(final INode targetNode, final IDragElement[] elements, DropFeedback feedback, Point p) {
        Rect b = targetNode.getBounds();
        if (!b.isValid()) {
            return;
        }
        final Map<String, Pair<String, String>> idMap = FrameLayoutRule.getDropIdMap(targetNode, elements, feedback.isCopy || !feedback.sameCanvas);
        targetNode.editXml("Add elements to FrameLayout", new INodeHandler(){

            public void handle(INode node) {
                IDragElement[] iDragElementArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IDragElement element = iDragElementArray[n2];
                    String fqcn = element.getFqcn();
                    INode newChild = targetNode.appendChild(fqcn);
                    FrameLayoutRule.addAttributes(newChild, element, idMap, DEFAULT_ATTR_FILTER);
                    FrameLayoutRule.addInnerElements(newChild, element, idMap);
                    ++n2;
                }
            }
        });
    }

    @Override
    public void addLayoutActions(List<RuleAction> actions, INode parentNode, List<? extends INode> children) {
        super.addLayoutActions(actions, parentNode, children);
        actions.add((RuleAction)RuleAction.createSeparator((int)25));
        actions.add(this.createMarginAction(parentNode, children));
        if (children != null && children.size() > 0) {
            actions.add(this.createGravityAction(children, "layout_gravity"));
        }
    }

    public void onChildInserted(INode node, INode parent, InsertType insertType) {
        String fqcn = node.getFqcn();
        IViewMetadata metadata = this.mRulesEngine.getMetadata(fqcn);
        if (metadata != null) {
            IViewMetadata.FillPreference fill = metadata.getFillPreference();
            String fillParent = this.getFillParentValueName();
            if (fill.fillHorizontally(true)) {
                node.setAttribute("http://schemas.android.com/apk/res/android", "layout_width", fillParent);
            }
            if (fill.fillVertically(false)) {
                node.setAttribute("http://schemas.android.com/apk/res/android", "layout_height", fillParent);
            }
        }
    }
}

