/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.common.resources.platform;

import com.android.ide.common.api.IAttributeInfo;
import com.android.utils.ILogger;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.andmore.AdtUtils;
import org.eclipse.andmore.common.resources.platform.AttributeInfo;
import org.eclipse.andmore.common.resources.platform.DeclareStyleableInfo;
import org.eclipse.andmore.common.resources.platform.ViewClassInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class AttrsXmlParser {
    public static final String ANDROID_MANIFEST_STYLEABLE = "AndroidManifest";
    private Document mDocument;
    private String mOsAttrsXmlPath;
    private Map<String, AttributeInfo> mAttributeMap;
    private final Map<String, DeclareStyleableInfo> mStyleMap = new HashMap<String, DeclareStyleableInfo>();
    private Map<String, IAttributeInfo.Format> mFormatNames = new HashMap<String, IAttributeInfo.Format>(10);
    private Map<String, Map<String, Integer>> mEnumFlagValues;
    private final ILogger mLog;

    public AttrsXmlParser(String osAttrsXmlPath, ILogger log, int expectedAttributeCount) {
        this(osAttrsXmlPath, null, log, expectedAttributeCount);
    }

    public Map<String, AttributeInfo> getAttributeMap() {
        return this.mAttributeMap;
    }

    public AttrsXmlParser(String osAttrsXmlPath, AttrsXmlParser inheritableAttributes, ILogger log, int expectedAttributeCount) {
        this.mOsAttrsXmlPath = osAttrsXmlPath;
        this.mLog = log;
        assert (osAttrsXmlPath != null);
        assert (log != null);
        this.mAttributeMap = Maps.newHashMapWithExpectedSize((int)expectedAttributeCount);
        if (inheritableAttributes == null) {
            this.mEnumFlagValues = new HashMap<String, Map<String, Integer>>();
        } else {
            this.mAttributeMap.putAll(inheritableAttributes.mAttributeMap);
            this.mEnumFlagValues = new HashMap<String, Map<String, Integer>>(inheritableAttributes.mEnumFlagValues);
        }
        IAttributeInfo.Format[] formatArray = IAttributeInfo.Format.values();
        int n = formatArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAttributeInfo.Format f = formatArray[n2];
            this.mFormatNames.put(f.name().toLowerCase(Locale.US), f);
            ++n2;
        }
    }

    public String getOsAttrsXmlPath() {
        return this.mOsAttrsXmlPath;
    }

    public AttrsXmlParser preload() {
        Document doc = this.getDocument();
        if (doc == null) {
            this.mLog.warning("Failed to find %1$s", new Object[]{this.mOsAttrsXmlPath});
            return this;
        }
        Node res = doc.getFirstChild();
        while (res != null && res.getNodeType() != 1 && !res.getNodeName().equals("resources")) {
            res = res.getNextSibling();
        }
        if (res == null) {
            this.mLog.warning("Failed to find a <resources> node in %1$s", new Object[]{this.mOsAttrsXmlPath});
            return this;
        }
        this.parseResources(res);
        return this;
    }

    public void loadViewAttributes(ViewClassInfo info) {
        String xmlName;
        DeclareStyleableInfo style;
        if (this.getDocument() != null && (style = this.mStyleMap.get(xmlName = info.getShortClassName())) != null) {
            AttributeInfo[] attributes;
            String definedBy = info.getFullClassName();
            AttributeInfo[] attributeInfoArray = attributes = style.getAttributes();
            int n = attributes.length;
            int n2 = 0;
            while (n2 < n) {
                AttributeInfo attribute = attributeInfoArray[n2];
                if (attribute.getDefinedBy() == null) {
                    attribute.setDefinedBy(definedBy);
                }
                ++n2;
            }
            info.setAttributes(attributes);
            info.setJavaDoc(style.getJavaDoc());
        }
    }

    public void loadLayoutParamsAttributes(ViewClassInfo.LayoutParamsInfo info) {
        if (this.getDocument() != null) {
            ViewClassInfo viewLayoutClass = info.getViewLayoutClass();
            String xmlName = String.format("%1$s_%2$s", viewLayoutClass.getShortClassName(), info.getShortClassName());
            DeclareStyleableInfo style = this.mStyleMap.get(xmlName = AdtUtils.stripSuffix(xmlName, "Params"));
            if (style != null) {
                AttributeInfo[] attributes;
                String definedBy = String.valueOf(viewLayoutClass.getFullClassName()) + ".LayoutParams";
                AttributeInfo[] attributeInfoArray = attributes = style.getAttributes();
                int n = attributes.length;
                int n2 = 0;
                while (n2 < n) {
                    AttributeInfo attribute = attributeInfoArray[n2];
                    if (attribute.getDefinedBy() == null) {
                        attribute.setDefinedBy(definedBy);
                    }
                    ++n2;
                }
                info.setAttributes(attributes);
            }
        }
    }

    public Map<String, DeclareStyleableInfo> getDeclareStyleableList() {
        return Collections.unmodifiableMap(this.mStyleMap);
    }

    public Map<String, Map<String, Integer>> getEnumFlagValues() {
        return this.mEnumFlagValues;
    }

    private Document getDocument() {
        if (this.mDocument == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(false);
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                this.mDocument = builder.parse(new File(this.mOsAttrsXmlPath));
            }
            catch (ParserConfigurationException e) {
                this.mLog.error((Throwable)e, "Failed to create XML document builder for %1$s", new Object[]{this.mOsAttrsXmlPath});
            }
            catch (SAXException e) {
                this.mLog.error((Throwable)e, "Failed to parse XML document %1$s", new Object[]{this.mOsAttrsXmlPath});
            }
            catch (IOException e) {
                this.mLog.error((Throwable)e, "Failed to read XML document %1$s", new Object[]{this.mOsAttrsXmlPath});
            }
        }
        return this.mDocument;
    }

    private void parseResources(Node res) {
        String name;
        HashMap<String, String> unknownParents = new HashMap<String, String>();
        Node lastComment = null;
        Node node = res.getFirstChild();
        while (node != null) {
            switch (node.getNodeType()) {
                case 8: {
                    lastComment = node;
                    break;
                }
                case 1: {
                    if (node.getNodeName().equals("declare-styleable")) {
                        Node nameNode = node.getAttributes().getNamedItem("name");
                        if (nameNode != null) {
                            String parents;
                            name = nameNode.getNodeValue();
                            Node parentNode = node.getAttributes().getNamedItem("parent");
                            String string = parents = parentNode == null ? null : parentNode.getNodeValue();
                            if (name != null && !this.mStyleMap.containsKey(name)) {
                                DeclareStyleableInfo style = this.parseDeclaredStyleable(name, node);
                                if (parents != null) {
                                    String[] parentsArray = this.parseStyleableParents(parents, this.mStyleMap, unknownParents);
                                    style.setParents(parentsArray);
                                }
                                this.mStyleMap.put(name, style);
                                unknownParents.remove(name);
                                if (lastComment != null) {
                                    String nodeValue = lastComment.getNodeValue();
                                    if (nodeValue.contains("@hide")) {
                                        this.mStyleMap.remove(name);
                                    } else {
                                        style.setJavaDoc(this.parseJavadoc(nodeValue));
                                    }
                                }
                            }
                        }
                    } else if (node.getNodeName().equals("attr")) {
                        this.parseAttr(node, lastComment);
                    }
                    lastComment = null;
                }
            }
            node = node.getNextSibling();
        }
        for (Map.Entry entry : unknownParents.entrySet()) {
            name = (String)entry.getKey();
            String parent = (String)entry.getValue();
            DeclareStyleableInfo style = new DeclareStyleableInfo(name, null);
            if (parent != null) {
                style.setParents(new String[]{parent});
            }
            this.mStyleMap.put(name, style);
            for (String key : new ArrayList<String>(this.mStyleMap.keySet())) {
                if (!key.startsWith(name) || key.equals(name)) continue;
                String newName = ANDROID_MANIFEST_STYLEABLE + key.substring(name.length());
                DeclareStyleableInfo newStyle = new DeclareStyleableInfo(newName, this.mStyleMap.get(key));
                this.mStyleMap.remove(key);
                this.mStyleMap.put(newName, newStyle);
            }
        }
    }

    private String[] parseStyleableParents(String parents, Map<String, DeclareStyleableInfo> knownParents, Map<String, String> unknownParents) {
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = parents.split("[ \t\n\r\f,|]");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String parent = stringArray[n2];
            if ((parent = parent.trim()).length() != 0) {
                if (parent.indexOf(46) >= 0) {
                    String last = null;
                    String[] stringArray2 = parent.split("\\.");
                    int n3 = stringArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String name = stringArray2[n4];
                        if (name.length() > 0) {
                            if (!knownParents.containsKey(name)) {
                                unknownParents.put(name, last);
                            }
                            last = name;
                        }
                        ++n4;
                    }
                    parent = last;
                }
                result.add(parent);
            }
            ++n2;
        }
        return result.toArray(new String[result.size()]);
    }

    private AttributeInfo parseAttr(Node attrNode, Node lastComment) {
        String name;
        AttributeInfo info = null;
        Node nameNode = attrNode.getAttributes().getNamedItem("name");
        if (nameNode != null && (name = nameNode.getNodeValue()) != null) {
            info = this.mAttributeMap.get(name);
            if (info == null || info.getFormats().size() == 0) {
                info = this.parseAttributeTypes(attrNode, name);
                if (info != null) {
                    this.mAttributeMap.put(name, info);
                }
            } else if (lastComment != null) {
                info = new AttributeInfo(info);
            }
            if (info != null && lastComment != null) {
                String nodeValue = lastComment.getNodeValue();
                if (nodeValue.contains("@hide")) {
                    return null;
                }
                info.setJavaDoc(this.parseJavadoc(nodeValue));
                info.setDeprecatedDoc(this.parseDeprecatedDoc(nodeValue));
            }
        }
        return info;
    }

    private DeclareStyleableInfo parseDeclaredStyleable(String styleName, Node declareStyleableNode) {
        ArrayList<AttributeInfo> attrs = new ArrayList<AttributeInfo>();
        Node lastComment = null;
        Node node = declareStyleableNode.getFirstChild();
        while (node != null) {
            switch (node.getNodeType()) {
                case 8: {
                    lastComment = node;
                    break;
                }
                case 1: {
                    AttributeInfo info;
                    if (node.getNodeName().equals("attr") && (info = this.parseAttr(node, lastComment)) != null) {
                        attrs.add(info);
                    }
                    lastComment = null;
                }
            }
            node = node.getNextSibling();
        }
        return new DeclareStyleableInfo(styleName, attrs.toArray(new AttributeInfo[attrs.size()]));
    }

    private AttributeInfo parseAttributeTypes(Node attrNode, String name) {
        EnumSet<IAttributeInfo.Format> formats = null;
        String[] enumValues = null;
        String[] flagValues = null;
        Node attrFormat = attrNode.getAttributes().getNamedItem("format");
        if (attrFormat != null) {
            String[] stringArray = attrFormat.getNodeValue().split("\\|");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String f = stringArray[n2];
                IAttributeInfo.Format format = this.mFormatNames.get(f);
                if (format == null) {
                    this.mLog.info("Unknown format name '%s' in <attr name=\"%s\">, file '%s'.", new Object[]{f, name, this.getOsAttrsXmlPath()});
                } else if (format != IAttributeInfo.Format.ENUM && format != IAttributeInfo.Format.FLAG) {
                    if (formats == null) {
                        formats = format.asSet();
                    } else {
                        if (formats.size() == 1) {
                            formats = EnumSet.copyOf(formats);
                        }
                        formats.add(format);
                    }
                }
                ++n2;
            }
        }
        if ((enumValues = this.parseEnumFlagValues(attrNode, "enum", name)) != null) {
            if (formats == null) {
                formats = IAttributeInfo.Format.ENUM_SET;
            } else {
                if (formats.size() == 1) {
                    formats = EnumSet.copyOf(formats);
                }
                formats.add(IAttributeInfo.Format.ENUM);
            }
        }
        if ((flagValues = this.parseEnumFlagValues(attrNode, "flag", name)) != null) {
            if (formats == null) {
                formats = IAttributeInfo.Format.FLAG_SET;
            } else {
                if (formats.size() == 1) {
                    formats = EnumSet.copyOf(formats);
                }
                formats.add(IAttributeInfo.Format.FLAG);
            }
        }
        if (formats == null) {
            formats = IAttributeInfo.Format.NONE;
        }
        AttributeInfo info = new AttributeInfo(name, formats);
        info.setEnumValues(enumValues);
        info.setFlagValues(flagValues);
        return info;
    }

    private String[] parseEnumFlagValues(Node attrNode, String filter, String attrName) {
        ArrayList<String> names = null;
        Node child = attrNode.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1 && child.getNodeName().equals(filter)) {
                Node nameNode = child.getAttributes().getNamedItem("name");
                if (nameNode == null) {
                    this.mLog.warning("Missing name attribute in <attr name=\"%s\"><%s></attr>", new Object[]{attrName, filter});
                } else {
                    if (names == null) {
                        names = new ArrayList<String>();
                    }
                    String name = nameNode.getNodeValue();
                    names.add(name);
                    Node valueNode = child.getAttributes().getNamedItem("value");
                    if (valueNode == null) {
                        this.mLog.warning("Missing value attribute in <attr name=\"%s\"><%s name=\"%s\"></attr>", new Object[]{attrName, filter, name});
                    } else {
                        String value = valueNode.getNodeValue();
                        try {
                            int i = (int)Long.decode(value).longValue();
                            Map<String, Integer> map = this.mEnumFlagValues.get(attrName);
                            if (map == null) {
                                map = new HashMap<String, Integer>();
                                this.mEnumFlagValues.put(attrName, map);
                            }
                            map.put(name, i);
                        }
                        catch (NumberFormatException e) {
                            this.mLog.error((Throwable)e, "Value in <attr name=\"%s\"><%s name=\"%s\" value=\"%s\"></attr> is not a valid decimal or hexadecimal", new Object[]{attrName, filter, name, value});
                        }
                    }
                }
            }
            child = child.getNextSibling();
        }
        return names == null ? null : names.toArray(new String[names.size()]);
    }

    private String parseJavadoc(String comment) {
        if (comment == null) {
            return null;
        }
        comment = comment.replaceAll("\\s+", " ");
        comment = comment.replaceAll("(?:\\{@deprecated[^}]*\\}|@deprecated[^@}]*)", "");
        comment = comment.replaceFirst("^\\s*(.*?(?:$|(?<![a-zA-Z]\\.[a-zA-Z])\\.(?=\\s))).*", "$1");
        return comment;
    }

    private String parseDeprecatedDoc(String comment) {
        if (comment == null) {
            return null;
        }
        int pos = (comment = comment.replaceAll("\\s+", " ")).indexOf("{@deprecated");
        if (pos >= 0) {
            comment = comment.substring(pos + 12);
            comment = comment.replaceFirst("^([^}]*).*", "$1");
        } else {
            pos = comment.indexOf("@deprecated");
            if (pos >= 0) {
                comment = comment.substring(pos + 11);
                comment = comment.replaceFirst("^(.*?)(?:@.*|$)", "$1");
            } else {
                return null;
            }
        }
        return comment.trim();
    }
}

