/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.build.builders;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.andmore.internal.build.builders.ChangedFileSet;
import org.eclipse.andmore.internal.build.builders.JavaResChangedSet;
import org.eclipse.andmore.internal.project.BaseProjectHelper;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

class ChangedFileSetHelper {
    static final ChangedFileSet MANIFEST = new ChangedFileSet("manifest", "AndroidManifest.xml");
    static final ChangedFileSet NATIVE_LIBS = new ChangedFileSet("nativeLibs", "libs/*/*.so", "libs/*/gdbserver");

    ChangedFileSetHelper() {
    }

    static ChangedFileSet getJavaResCfs(IProject project) {
        IPath projectPath = project.getFullPath();
        List<IPath> srcPaths = BaseProjectHelper.getSourceClasspaths(project);
        ArrayList<String> paths = new ArrayList<String>(srcPaths.size());
        for (IPath path : srcPaths) {
            paths.add(String.valueOf(path.makeRelativeTo(projectPath).toString()) + "/**");
        }
        return new JavaResChangedSet("javaRes", paths.toArray(new String[paths.size()]));
    }

    static ChangedFileSet getResCfs(IProject project) {
        String path = ChangedFileSetHelper.getRelativeAndroidOut(project);
        ChangedFileSet set = new ChangedFileSet("resources", "res/**", "assets/**", String.valueOf(path) + '/' + "res/bc" + "/**");
        set.setOutput(String.valueOf(path) + '/' + "resources.ap_");
        return set;
    }

    static ChangedFileSet getMergedManifestCfs(IProject project) {
        String path = ChangedFileSetHelper.getRelativeAndroidOut(project);
        ChangedFileSet set = new ChangedFileSet("mergedManifest", String.valueOf(path) + '/' + "AndroidManifest.xml");
        return set;
    }

    static ChangedFileSet getTextSymbols(IProject project) {
        String path = ChangedFileSetHelper.getRelativeAndroidOut(project);
        ChangedFileSet set = new ChangedFileSet("textSymbols", String.valueOf(path) + '/' + "R.txt");
        return set;
    }

    static ChangedFileSet getByteCodeCfs(IProject project) {
        String path = ChangedFileSetHelper.getRelativeJavaCOut(project);
        ChangedFileSet set = new ChangedFileSet("compiledCode", String.valueOf(path) + "/**/*" + ".class");
        return set;
    }

    static ChangedFileSet getFullResCfs(IProject project) {
        String path = ChangedFileSetHelper.getRelativeAndroidOut(project);
        ChangedFileSet set = new ChangedFileSet("libResources", "res/**", String.valueOf(path) + '/' + "res" + "/**");
        return set;
    }

    static ChangedFileSet getCodeCfs(IProject project) {
        String path = ChangedFileSetHelper.getRelativeJavaCOut(project);
        ChangedFileSet set = new ChangedFileSet("classAndJars", String.valueOf(path) + "/**/*" + ".class", "libs/*.jar");
        path = ChangedFileSetHelper.getRelativeAndroidOut(project);
        set.setOutput(String.valueOf(path) + '/' + "classes.dex");
        return set;
    }

    private static String getRelativePath(IProject project, IResource resource) {
        return resource.getFullPath().makeRelativeTo(project.getFullPath()).toString();
    }

    private static String getRelativeAndroidOut(IProject project) {
        IFolder folder = BaseProjectHelper.getAndroidOutputFolder(project);
        return ChangedFileSetHelper.getRelativePath(project, (IResource)folder);
    }

    private static String getRelativeJavaCOut(IProject project) {
        IFolder folder = BaseProjectHelper.getJavaOutputFolder(project);
        return ChangedFileSetHelper.getRelativePath(project, (IResource)folder);
    }
}

