/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.build.builders;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.build.BuildHelper;
import org.eclipse.andmore.internal.build.builders.ChangedFileSet;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

class PatternBasedDeltaVisitor
implements IResourceDeltaVisitor {
    private static final boolean DEBUG_LOG = "1".equals(System.getenv("ANDROID_VISITOR_DEBUG"));
    private final IProject mMainProject;
    private final IProject mDeltaProject;
    private final List<ChangedFileSet> mSets = new ArrayList<ChangedFileSet>();
    private final Map<ChangedFileSet, Boolean> mResults = new IdentityHashMap<ChangedFileSet, Boolean>();
    private final String mLogName;

    PatternBasedDeltaVisitor(IProject mainProject, IProject deltaProject, String logName) {
        this.mMainProject = mainProject;
        this.mDeltaProject = deltaProject;
        this.mLogName = logName;
        if (DEBUG_LOG) {
            AndmoreAndroidPlugin.log(1, "%s (%s): Delta for %s", this.mMainProject.getName(), this.mLogName, this.mDeltaProject.getName());
        }
    }

    void addSet(ChangedFileSet bundle) {
        this.mSets.add(bundle);
    }

    boolean checkSet(ChangedFileSet bundle) {
        Boolean r = this.mResults.get(bundle);
        if (r != null) {
            return r;
        }
        return false;
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if (resource.getType() == 2) {
            return BuildHelper.checkFolderForPackaging((IFolder)resource);
        }
        if (resource.getType() == 1) {
            IPath path = resource.getFullPath().makeRelativeTo(this.mDeltaProject.getFullPath());
            String pathStr = path.toString();
            for (ChangedFileSet set : this.mSets) {
                String cfs_logName;
                if (set.isInput(pathStr, path)) {
                    this.mResults.put(set, Boolean.TRUE);
                    if (!DEBUG_LOG) continue;
                    cfs_logName = set.getLogName();
                    if (cfs_logName != null) {
                        AndmoreAndroidPlugin.log(1, "%s (%s:%s): %s", this.mMainProject.getName(), this.mLogName, cfs_logName, resource.getFullPath().toString());
                        continue;
                    }
                    AndmoreAndroidPlugin.log(1, "%s (%s): %s", this.mMainProject.getName(), this.mLogName, resource.getFullPath().toString());
                    continue;
                }
                if (delta.getKind() != 2 || !set.isOutput(pathStr, path)) continue;
                this.mResults.put(set, Boolean.TRUE);
                if (!DEBUG_LOG) continue;
                cfs_logName = set.getLogName();
                if (cfs_logName != null) {
                    AndmoreAndroidPlugin.log(1, "%s (%s:%s): %s", this.mMainProject.getName(), this.mLogName, cfs_logName, resource.getFullPath().toString());
                    continue;
                }
                AndmoreAndroidPlugin.log(1, "%s (%s): %s", this.mMainProject.getName(), this.mLogName, resource.getFullPath().toString());
            }
        }
        return true;
    }
}

