/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.draw9patch;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.draw9patch.graphics.NinePatchedImage;
import org.eclipse.andmore.internal.editors.draw9patch.ui.ImageViewer;
import org.eclipse.andmore.internal.editors.draw9patch.ui.MainFrame;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class Draw9PatchEditor
extends EditorPart
implements ImageViewer.UpdateListener {
    private IProject mProject = null;
    private FileEditorInput mFileEditorInput = null;
    private String mFileName = null;
    private NinePatchedImage mNinePatchedImage = null;
    private MainFrame mMainFrame = null;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(input.getName());
        if (!(input instanceof FileEditorInput)) {
            throw new PartInitException("Input is not of type FileEditorInput nor FileStoreEditorInput: " + input == null ? "null" : input.toString());
        }
        this.mFileEditorInput = (FileEditorInput)input;
        this.mFileName = this.mFileEditorInput.getName();
        this.mProject = this.mFileEditorInput.getFile().getProject();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        IPath relativePath = null;
        relativePath = this.showSaveAsDialog();
        if (relativePath != null) {
            this.mFileEditorInput = new FileEditorInput(ResourcesPlugin.getWorkspace().getRoot().getFile(relativePath));
            this.mFileName = this.mFileEditorInput.getName();
            this.setInput((IEditorInput)this.mFileEditorInput);
            this.doSave((IProgressMonitor)new NullProgressMonitor());
        }
    }

    public void doSave(IProgressMonitor monitor) {
        boolean hasNinePatchExtension = this.mFileName.endsWith(".9.png");
        boolean doConvert = false;
        if (!hasNinePatchExtension) {
            String patchedName = NinePatchedImage.getNinePatchedFileName(this.mFileName);
            doConvert = MessageDialog.openQuestion((Shell)AndmoreAndroidPlugin.getDisplay().getActiveShell(), (String)"Warning", (String)String.format("The file \"%s\" doesn't seem to be a 9-patch file. \nDo you want to convert and save as \"%s\" ?", this.mFileName, patchedName));
            if (doConvert) {
                IFile destFile = this.mProject.getFile(NinePatchedImage.getNinePatchedFileName(this.mFileEditorInput.getFile().getProjectRelativePath().toOSString()));
                if (!destFile.exists()) {
                    this.mFileEditorInput = new FileEditorInput(destFile);
                    this.mFileName = this.mFileEditorInput.getName();
                } else {
                    IPath relativePath = null;
                    relativePath = this.showSaveAsDialog();
                    if (relativePath != null) {
                        this.mFileEditorInput = new FileEditorInput(ResourcesPlugin.getWorkspace().getRoot().getFile(relativePath));
                        this.mFileName = this.mFileEditorInput.getName();
                    } else {
                        doConvert = false;
                    }
                }
            }
        }
        if (hasNinePatchExtension || doConvert) {
            ImageLoader loader = new ImageLoader();
            loader.data = new ImageData[]{this.mNinePatchedImage.getRawImageData()};
            IFile file = this.mFileEditorInput.getFile();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            loader.save((OutputStream)outputStream, 5);
            byte[] byteArray = outputStream.toByteArray();
            try {
                if (file.exists()) {
                    file.setContents((InputStream)new ByteArrayInputStream(byteArray), true, false, monitor);
                } else {
                    file.create((InputStream)new ByteArrayInputStream(byteArray), true, monitor);
                }
                this.mNinePatchedImage.clearDirtyFlag();
                AndmoreAndroidPlugin.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Draw9PatchEditor.this.setPartName(Draw9PatchEditor.this.mFileName);
                        Draw9PatchEditor.this.firePropertyChange(257);
                    }
                });
            }
            catch (CoreException e) {
                AndmoreAndroidPlugin.log(e, null, new Object[0]);
            }
        }
    }

    public void createPartControl(Composite parent) {
        this.mMainFrame = new MainFrame(parent, 0);
        ImageViewer imageViewer = this.mMainFrame.getImageEditorPanel().getImageViewer();
        imageViewer.addUpdateListener(this);
        this.mNinePatchedImage = imageViewer.loadFile(this.mFileEditorInput.getPath().toOSString());
        if (this.mNinePatchedImage.hasNinePatchExtension()) {
            if (!this.mNinePatchedImage.ensure9Patch() && Draw9PatchEditor.showConvertMessageBox(this.mFileName)) {
                this.mNinePatchedImage = imageViewer.loadFile(this.mFileEditorInput.getPath().toOSString());
                this.mNinePatchedImage.convertToNinePatch();
            }
        } else {
            this.mNinePatchedImage.convertToNinePatch();
        }
        imageViewer.startDisplay();
        parent.layout();
    }

    public void setFocus() {
        this.mMainFrame.forceFocus();
    }

    public boolean isDirty() {
        return this.mNinePatchedImage.isDirty();
    }

    @Override
    public void update(NinePatchedImage image) {
        if (image.isDirty()) {
            this.firePropertyChange(257);
        }
    }

    private IPath showSaveAsDialog() {
        SaveAsDialog dialog = new SaveAsDialog(AndmoreAndroidPlugin.getDisplay().getActiveShell());
        IFile dest = this.mProject.getFile(NinePatchedImage.getNinePatchedFileName(this.mFileEditorInput.getFile().getProjectRelativePath().toOSString()));
        dialog.setOriginalFile(dest);
        dialog.create();
        if (dialog.open() == 1) {
            return null;
        }
        return dialog.getResult();
    }

    private static boolean showConvertMessageBox(String fileName) {
        return MessageDialog.openQuestion((Shell)AndmoreAndroidPlugin.getDisplay().getActiveShell(), (String)"Warning", (String)String.format("The file \"%s\" doesn't seem to be a 9-patch file. \nDo you want to convert?", fileName));
    }
}

