/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.draw9patch.ui;

import org.eclipse.andmore.internal.editors.draw9patch.graphics.NinePatchedImage;
import org.eclipse.andmore.internal.editors.draw9patch.ui.ImageViewer;
import org.eclipse.andmore.internal.editors.draw9patch.ui.StatusPanel;
import org.eclipse.andmore.internal.editors.draw9patch.ui.StretchesViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ImageEditorPanel
extends Composite
implements ImageViewer.UpdateListener,
StatusPanel.StatusChangedListener {
    private static final int WEIGHT_VIEWER = 3;
    private static final int WEIGHT_PREVIEW = 1;
    private final ImageViewer mImageViewer;
    private final StretchesViewer mStretchesViewer;

    public ImageViewer getImageViewer() {
        return this.mImageViewer;
    }

    public ImageEditorPanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm((Composite)this, 256);
        this.mImageViewer = new ImageViewer((Composite)sashForm, 2816);
        this.mImageViewer.addUpdateListener(this);
        this.mStretchesViewer = new StretchesViewer((Composite)sashForm, 2048);
        sashForm.setWeights(new int[]{3, 1});
    }

    @Override
    public void zoomChanged(int zoom) {
        this.mImageViewer.setZoom(zoom);
    }

    @Override
    public void scaleChanged(int scale) {
        this.mStretchesViewer.setScale(scale);
    }

    @Override
    public void lockVisibilityChanged(boolean visible) {
        this.mImageViewer.setShowLock(visible);
    }

    @Override
    public void patchesVisibilityChanged(boolean visible) {
        this.mImageViewer.setShowPatchesArea(visible);
    }

    @Override
    public void badPatchesVisibilityChanged(boolean visible) {
        this.mImageViewer.setShowBadPatchesArea(visible);
    }

    @Override
    public void contentAreaVisibilityChanged(boolean visible) {
        this.mStretchesViewer.setShowContentArea(visible);
    }

    @Override
    public void update(NinePatchedImage image) {
        this.mStretchesViewer.updatePreview(image);
    }
}

