/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.gre;

import com.android.ide.common.api.IClientRulesEngine;
import com.android.ide.common.api.INode;
import com.android.ide.common.api.IValidator;
import com.android.ide.common.api.IViewMetadata;
import com.android.ide.common.api.IViewRule;
import com.android.ide.common.api.Margins;
import com.android.ide.common.api.Rect;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.common.layout.BaseViewRule;
import org.eclipse.andmore.internal.actions.AddSupportJarAction;
import org.eclipse.andmore.internal.editors.common.CommonXmlEditor;
import org.eclipse.andmore.internal.editors.descriptors.DescriptorsUtils;
import org.eclipse.andmore.internal.editors.layout.LayoutEditorDelegate;
import org.eclipse.andmore.internal.editors.layout.configuration.ConfigurationChooser;
import org.eclipse.andmore.internal.editors.layout.gle2.CanvasViewInfo;
import org.eclipse.andmore.internal.editors.layout.gle2.GraphicalEditorPart;
import org.eclipse.andmore.internal.editors.layout.gle2.LayoutCanvas;
import org.eclipse.andmore.internal.editors.layout.gle2.RenderService;
import org.eclipse.andmore.internal.editors.layout.gle2.SelectionManager;
import org.eclipse.andmore.internal.editors.layout.gle2.ViewHierarchy;
import org.eclipse.andmore.internal.editors.layout.gre.RulesEngine;
import org.eclipse.andmore.internal.editors.layout.gre.ViewMetadataRepository;
import org.eclipse.andmore.internal.editors.manifest.ManifestInfo;
import org.eclipse.andmore.internal.editors.uimodel.UiDocumentNode;
import org.eclipse.andmore.internal.editors.uimodel.UiElementNode;
import org.eclipse.andmore.internal.project.BaseProjectHelper;
import org.eclipse.andmore.internal.refactorings.core.RenameResult;
import org.eclipse.andmore.internal.resources.CyclicDependencyValidator;
import org.eclipse.andmore.internal.resources.ResourceNameValidator;
import org.eclipse.andmore.internal.resources.manager.ProjectResources;
import org.eclipse.andmore.internal.resources.manager.ResourceManager;
import org.eclipse.andmore.internal.sdk.AndroidTargetData;
import org.eclipse.andmore.internal.sdk.ProjectState;
import org.eclipse.andmore.internal.sdk.Sdk;
import org.eclipse.andmore.internal.ui.MarginChooser;
import org.eclipse.andmore.internal.ui.ReferenceChooserDialog;
import org.eclipse.andmore.internal.ui.ResourceChooser;
import org.eclipse.andmore.internal.ui.ResourcePreviewHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.OpenNewClassWizardAction;
import org.eclipse.jdt.ui.dialogs.ITypeInfoFilterExtension;
import org.eclipse.jdt.ui.dialogs.ITypeInfoRequestor;
import org.eclipse.jdt.ui.dialogs.TypeSelectionExtension;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ClientRulesEngine
implements IClientRulesEngine {
    public static final int CLEAR_RETURN_CODE = -5;
    private static final int CLEAR_BUTTON_ID = -5;
    private final RulesEngine mRulesEngine;
    private final String mFqcn;

    public ClientRulesEngine(RulesEngine rulesEngine, String fqcn) {
        this.mRulesEngine = rulesEngine;
        this.mFqcn = fqcn;
    }

    public String getFqcn() {
        return this.mFqcn;
    }

    public void debugPrintf(String msg, Object ... params) {
        AndmoreAndroidPlugin.printToConsole(this.mFqcn == null ? "<unknown>" : this.mFqcn, String.format(msg, params));
    }

    public IViewRule loadRule(String fqcn) {
        return this.mRulesEngine.loadRule(fqcn, fqcn);
    }

    public void displayAlert(String message) {
        MessageDialog.openInformation((Shell)AndmoreAndroidPlugin.getShell(), (String)this.mFqcn, (String)message);
    }

    public boolean rename(INode node) {
        GraphicalEditorPart editor = this.mRulesEngine.getEditor();
        SelectionManager manager = editor.getCanvasControl().getSelectionManager();
        RenameResult result = manager.performRename(node, null);
        return !result.isCanceled() && !result.isUnavailable();
    }

    public String displayInput(String message, String value, final IValidator filter) {
        InputDialog d;
        int result;
        IInputValidator validator = null;
        if (filter != null) {
            validator = new IInputValidator(){

                public String isValid(String newText) {
                    try {
                        return filter.validate(newText);
                    }
                    catch (Exception e) {
                        AndmoreAndroidPlugin.log(e, "Custom validator failed: %s", e.toString());
                        return "";
                    }
                }
            };
        }
        if ((result = (d = new InputDialog(AndmoreAndroidPlugin.getShell(), this.mFqcn, message, value == null ? "" : value, validator){

            protected void createButtonsForButtonBar(Composite parent) {
                this.createButton(parent, -5, "Clear", false);
                super.createButtonsForButtonBar(parent);
            }

            protected void buttonPressed(int buttonId) {
                super.buttonPressed(buttonId);
                if (buttonId == -5) {
                    this.setReturnCode(-5);
                    this.close();
                }
            }
        }).open()) == -5) {
            return "";
        }
        if (result == 0) {
            return d.getValue();
        }
        return null;
    }

    public Object getViewObject(INode node) {
        ViewHierarchy views = this.mRulesEngine.getEditor().getCanvasControl().getViewHierarchy();
        CanvasViewInfo vi = views.findViewInfoFor(node);
        if (vi != null) {
            return vi.getViewObject();
        }
        return null;
    }

    public IViewMetadata getMetadata(final String fqcn) {
        return new IViewMetadata(){

            public String getDisplayName() {
                return fqcn.substring(fqcn.lastIndexOf(46) + 1);
            }

            public IViewMetadata.FillPreference getFillPreference() {
                return ViewMetadataRepository.get().getFillPreference(fqcn);
            }

            public Margins getInsets() {
                return ClientRulesEngine.this.mRulesEngine.getEditor().getCanvasControl().getInsets(fqcn);
            }

            public List<String> getTopAttributes() {
                return ViewMetadataRepository.get().getTopAttributes(fqcn);
            }
        };
    }

    public int getMinApiLevel() {
        IAndroidTarget target;
        Sdk currentSdk = Sdk.getCurrent();
        if (currentSdk != null && (target = currentSdk.getTarget(this.mRulesEngine.getEditor().getProject())) != null) {
            return target.getVersion().getApiLevel();
        }
        return -1;
    }

    public IValidator getResourceValidator(final String resourceTypeName, final boolean uniqueInProject, final boolean uniqueInLayout, final boolean exists, final String ... allowed) {
        return new IValidator(){
            private ResourceNameValidator mValidator;

            public String validate(String text) {
                if (this.mValidator == null) {
                    ResourceType type = ResourceType.getEnum((String)resourceTypeName);
                    if (uniqueInLayout) {
                        if (!$assertionsDisabled && uniqueInProject) {
                            throw new AssertionError();
                        }
                        if (!$assertionsDisabled && exists) {
                            throw new AssertionError();
                        }
                        HashSet<String> existing = new HashSet<String>();
                        Document doc = ClientRulesEngine.this.mRulesEngine.getEditor().getModel().getXmlDocument();
                        if (doc != null) {
                            ClientRulesEngine.addIds(doc, existing);
                        }
                        String[] stringArray = allowed;
                        int n = allowed.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String s = stringArray[n2];
                            existing.remove(s);
                            ++n2;
                        }
                        this.mValidator = ResourceNameValidator.create(false, existing, type);
                    } else {
                        if (!$assertionsDisabled && allowed.length != 0) {
                            throw new AssertionError();
                        }
                        IProject project = ClientRulesEngine.this.mRulesEngine.getEditor().getProject();
                        this.mValidator = ResourceNameValidator.create(false, project, type);
                        if (uniqueInProject) {
                            this.mValidator.unique();
                        }
                    }
                    if (exists) {
                        this.mValidator.exist();
                    }
                }
                return this.mValidator.isValid(text);
            }
        };
    }

    private static void addIds(Node node, Set<String> ids) {
        Element element;
        String id;
        if (node.getNodeType() == 1 && (id = (element = (Element)node).getAttributeNS("http://schemas.android.com/apk/res/android", "id")) != null && id.startsWith("@+id/")) {
            ids.add(BaseViewRule.stripIdPrefix(id));
        }
        NodeList children = node.getChildNodes();
        int i = 0;
        int n = children.getLength();
        while (i < n) {
            Node child = children.item(i);
            ClientRulesEngine.addIds(child, ids);
            ++i;
        }
    }

    public String displayReferenceInput(String currentValue) {
        GraphicalEditorPart graphicalEditor = this.mRulesEngine.getEditor();
        LayoutEditorDelegate delegate = graphicalEditor.getEditorDelegate();
        IProject project = delegate.getEditor().getProject();
        if (project != null) {
            ProjectResources projectRepository = ResourceManager.getInstance().getProjectResources(project);
            Shell shell = AndmoreAndroidPlugin.getShell();
            if (shell == null) {
                return null;
            }
            ReferenceChooserDialog dlg = new ReferenceChooserDialog(project, projectRepository, shell);
            dlg.setPreviewHelper(new ResourcePreviewHelper((TrayDialog)dlg, graphicalEditor));
            dlg.setCurrentResource(currentValue);
            if (dlg.open() == 0) {
                return dlg.getCurrentResource();
            }
        }
        return null;
    }

    public String displayResourceInput(String resourceTypeName, String currentValue) {
        return this.displayResourceInput(resourceTypeName, currentValue, null);
    }

    private String displayResourceInput(String resourceTypeName, String currentValue, IInputValidator validator) {
        ResourceType type = ResourceType.getEnum((String)resourceTypeName);
        GraphicalEditorPart graphicalEditor = this.mRulesEngine.getEditor();
        return ResourceChooser.chooseResource(graphicalEditor, type, currentValue, validator);
    }

    public String[] displayMarginInput(String all, String left, String right, String top, String bottom) {
        GraphicalEditorPart editor = this.mRulesEngine.getEditor();
        IProject project = editor.getProject();
        if (project != null) {
            Shell shell = AndmoreAndroidPlugin.getShell();
            if (shell == null) {
                return null;
            }
            AndroidTargetData data = editor.getEditorDelegate().getEditor().getTargetData();
            MarginChooser dialog = new MarginChooser(shell, editor, data, all, left, right, top, bottom);
            if (dialog.open() == 0) {
                return dialog.getMargins();
            }
        }
        return null;
    }

    public String displayIncludeSourceInput() {
        CommonXmlEditor editor = this.mRulesEngine.getEditor().getEditorDelegate().getEditor();
        IInputValidator validator = CyclicDependencyValidator.create(editor.getInputFile());
        return this.displayResourceInput(ResourceType.LAYOUT.getName(), null, validator);
    }

    public void select(final Collection<INode> nodes) {
        LayoutCanvas layoutCanvas = this.mRulesEngine.getEditor().getCanvasControl();
        final SelectionManager selectionManager = layoutCanvas.getSelectionManager();
        selectionManager.select(nodes);
        layoutCanvas.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                selectionManager.select(nodes);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String displayFragmentSourceInput() {
        try {
            IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
            IProject project = this.mRulesEngine.getProject();
            final IJavaProject javaProject = BaseProjectHelper.getJavaProject(project);
            if (javaProject != null) {
                IType fragmentType;
                IType oldFragmentType = javaProject.findType("android.support.v4.app.Fragment");
                IAndroidTarget target = Sdk.getCurrent().getTarget(project);
                if (target.getVersion().getApiLevel() < 11 && oldFragmentType == null) {
                    MessageDialog dialog = new MessageDialog(Display.getCurrent().getActiveShell(), "Fragment Warning", null, "Fragments require API level 11 or higher, or a compatibility library for older versions.\n\n Do you want to install the compatibility library?", 3, new String[]{"Install", "Cancel"}, 1);
                    int answer = dialog.open();
                    if (answer != 0) return null;
                    if (!AddSupportJarAction.install(project)) {
                        return null;
                    }
                }
                IType[] fragmentTypes = new IType[]{};
                IType[] oldFragmentTypes = new IType[]{};
                if (oldFragmentType != null) {
                    ITypeHierarchy hierarchy = oldFragmentType.newTypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                    oldFragmentTypes = hierarchy.getAllSubtypes(oldFragmentType);
                }
                if ((fragmentType = javaProject.findType("android.app.Fragment")) != null) {
                    ITypeHierarchy hierarchy = fragmentType.newTypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                    fragmentTypes = hierarchy.getAllSubtypes(fragmentType);
                }
                IType[] subTypes = new IType[fragmentTypes.length + oldFragmentTypes.length];
                System.arraycopy(fragmentTypes, 0, subTypes, 0, fragmentTypes.length);
                System.arraycopy(oldFragmentTypes, 0, subTypes, fragmentTypes.length, oldFragmentTypes.length);
                scope = SearchEngine.createJavaSearchScope((IJavaElement[])subTypes, (int)1);
            }
            Shell parent = AndmoreAndroidPlugin.getShell();
            final AtomicReference returnValue = new AtomicReference();
            final AtomicReference<SelectionDialog> dialogHolder = new AtomicReference<SelectionDialog>();
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)parent, (IRunnableContext)new ProgressMonitorDialog(parent), (IJavaSearchScope)scope, (int)2, (boolean)false, (String)"?", (TypeSelectionExtension)new TypeSelectionExtension(){

                public Control createContentArea(Composite parentComposite) {
                    Composite composite = new Composite(parentComposite, 0);
                    composite.setLayout((Layout)new GridLayout(1, false));
                    Button button = new Button(composite, 8);
                    button.setText("Create New...");
                    button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            String fqcn = ClientRulesEngine.this.createNewFragmentClass(javaProject);
                            if (fqcn != null) {
                                returnValue.set(fqcn);
                                ((SelectionDialog)dialogHolder.get()).close();
                            }
                        }
                    });
                    return composite;
                }

                public ITypeInfoFilterExtension getFilterExtension() {
                    return new ITypeInfoFilterExtension(){

                        public boolean select(ITypeInfoRequestor typeInfoRequestor) {
                            int modifiers = typeInfoRequestor.getModifiers();
                            return Flags.isPublic((int)modifiers) && !Flags.isInterface((int)modifiers) && !Flags.isEnum((int)modifiers) && !Flags.isAbstract((int)modifiers);
                        }
                    };
                }
            });
            dialogHolder.set(dialog);
            dialog.setTitle("Choose Fragment Class");
            dialog.setMessage("Select a Fragment class (? = any character, * = any string):");
            if (dialog.open() == 1) {
                return null;
            }
            if (returnValue.get() != null) {
                return (String)returnValue.get();
            }
            Object[] types = dialog.getResult();
            if (types == null) return null;
            if (types.length <= 0) return null;
            return ((IType)types[0]).getFullyQualifiedName();
        }
        catch (JavaModelException e) {
            AndmoreAndroidPlugin.log(e, null, new Object[0]);
            return null;
        }
        catch (CoreException e) {
            AndmoreAndroidPlugin.log(e, null, new Object[0]);
        }
        return null;
    }

    public String displayCustomViewClassInput() {
        SelectionDialog dialog;
        AtomicReference returnValue;
        block8: {
            IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
            IProject project = this.mRulesEngine.getProject();
            final IJavaProject javaProject = BaseProjectHelper.getJavaProject(project);
            if (javaProject != null) {
                IType[] viewTypes = new IType[]{};
                IType fragmentType = javaProject.findType("android.view.View");
                if (fragmentType != null) {
                    ITypeHierarchy hierarchy = fragmentType.newTypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                    viewTypes = hierarchy.getAllSubtypes(fragmentType);
                }
                scope = SearchEngine.createJavaSearchScope((IJavaElement[])viewTypes, (int)1);
            }
            Shell parent = AndmoreAndroidPlugin.getShell();
            returnValue = new AtomicReference();
            final AtomicReference<SelectionDialog> dialogHolder = new AtomicReference<SelectionDialog>();
            dialog = JavaUI.createTypeDialog((Shell)parent, (IRunnableContext)new ProgressMonitorDialog(parent), (IJavaSearchScope)scope, (int)2, (boolean)false, (String)"?", (TypeSelectionExtension)new TypeSelectionExtension(){

                public Control createContentArea(Composite parentComposite) {
                    Composite composite = new Composite(parentComposite, 0);
                    composite.setLayout((Layout)new GridLayout(1, false));
                    Button button = new Button(composite, 8);
                    button.setText("Create New...");
                    button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            String fqcn = ClientRulesEngine.this.createNewCustomViewClass(javaProject);
                            if (fqcn != null) {
                                returnValue.set(fqcn);
                                ((SelectionDialog)dialogHolder.get()).close();
                            }
                        }
                    });
                    return composite;
                }

                public ITypeInfoFilterExtension getFilterExtension() {
                    return new ITypeInfoFilterExtension(){

                        public boolean select(ITypeInfoRequestor typeInfoRequestor) {
                            int modifiers = typeInfoRequestor.getModifiers();
                            return Flags.isPublic((int)modifiers) && !Flags.isInterface((int)modifiers) && !Flags.isEnum((int)modifiers) && !Flags.isAbstract((int)modifiers);
                        }
                    };
                }
            });
            dialogHolder.set(dialog);
            dialog.setTitle("Choose Custom View Class");
            dialog.setMessage("Select a Custom View class (? = any character, * = any string):");
            if (dialog.open() != 1) break block8;
            return null;
        }
        try {
            if (returnValue.get() != null) {
                return (String)returnValue.get();
            }
            Object[] types = dialog.getResult();
            if (types != null && types.length > 0) {
                return ((IType)types[0]).getFullyQualifiedName();
            }
        }
        catch (JavaModelException e) {
            AndmoreAndroidPlugin.log(e, null, new Object[0]);
        }
        catch (CoreException e) {
            AndmoreAndroidPlugin.log(e, null, new Object[0]);
        }
        return null;
    }

    public void redraw() {
        this.mRulesEngine.getEditor().getCanvasControl().redraw();
    }

    public void layout() {
        this.mRulesEngine.getEditor().recomputeLayout();
    }

    public Map<INode, Rect> measureChildren(INode parent, IClientRulesEngine.AttributeFilter filter) {
        RenderService renderService = RenderService.create(this.mRulesEngine.getEditor());
        Map<Object, Object> map = renderService.measureChildren(parent, filter);
        if (map == null) {
            map = Collections.emptyMap();
        }
        return map;
    }

    public int pxToDp(int px) {
        ConfigurationChooser chooser = this.mRulesEngine.getEditor().getConfigurationChooser();
        float dpi = chooser.getConfiguration().getDensity().getDpiValue();
        return (int)((float)(px * 160) / dpi);
    }

    public int dpToPx(int dp) {
        ConfigurationChooser chooser = this.mRulesEngine.getEditor().getConfigurationChooser();
        float dpi = chooser.getConfiguration().getDensity().getDpiValue();
        return (int)((float)dp * dpi / 160.0f);
    }

    public int screenToLayout(int pixels) {
        return (int)((double)pixels / this.mRulesEngine.getEditor().getCanvasControl().getScale());
    }

    private String createNewFragmentClass(IJavaProject javaProject) {
        ManifestInfo manifestInfo;
        IPackageFragment pkg;
        NewClassWizardPage page = new NewClassWizardPage();
        IProject project = this.mRulesEngine.getProject();
        Sdk sdk = Sdk.getCurrent();
        if (sdk == null) {
            return null;
        }
        IAndroidTarget target = sdk.getTarget(project);
        String superClass = target == null || target.getVersion().getApiLevel() < 11 ? "android.support.v4.app.Fragment" : "android.app.Fragment";
        page.setSuperClass(superClass, true);
        IPackageFragmentRoot root = ManifestInfo.getSourcePackageRoot(javaProject);
        if (root != null) {
            page.setPackageFragmentRoot(root, true);
        }
        if ((pkg = (manifestInfo = ManifestInfo.get(project)).getPackageFragment()) != null) {
            page.setPackageFragment(pkg, true);
        }
        OpenNewClassWizardAction action = new OpenNewClassWizardAction();
        action.setConfiguredWizardPage(page);
        action.run();
        IType createdType = page.getCreatedType();
        if (createdType != null) {
            return createdType.getFullyQualifiedName();
        }
        return null;
    }

    private String createNewCustomViewClass(IJavaProject javaProject) {
        ManifestInfo manifestInfo;
        IPackageFragment pkg;
        NewClassWizardPage page = new NewClassWizardPage();
        IProject project = this.mRulesEngine.getProject();
        String superClass = "android.view.View";
        page.setSuperClass(superClass, true);
        IPackageFragmentRoot root = ManifestInfo.getSourcePackageRoot(javaProject);
        if (root != null) {
            page.setPackageFragmentRoot(root, true);
        }
        if ((pkg = (manifestInfo = ManifestInfo.get(project)).getPackageFragment()) != null) {
            page.setPackageFragment(pkg, true);
        }
        OpenNewClassWizardAction action = new OpenNewClassWizardAction();
        action.setConfiguredWizardPage(page);
        action.run();
        IType createdType = page.getCreatedType();
        if (createdType != null) {
            return createdType.getFullyQualifiedName();
        }
        return null;
    }

    public String getUniqueId(String fqcn) {
        UiDocumentNode root = this.mRulesEngine.getEditor().getModel();
        String prefix = fqcn.substring(fqcn.lastIndexOf(46) + 1);
        prefix = String.valueOf(Character.toLowerCase(prefix.charAt(0))) + prefix.substring(1);
        return DescriptorsUtils.getFreeWidgetId((UiElementNode)root, prefix);
    }

    public String getAppNameSpace() {
        IProject project = this.mRulesEngine.getEditor().getProject();
        ProjectState projectState = Sdk.getProjectState(project);
        if (projectState != null && projectState.isLibrary()) {
            return "http://schemas.android.com/apk/res-auto";
        }
        ManifestInfo info = ManifestInfo.get(project);
        return "http://schemas.android.com/apk/res/" + info.getPackage();
    }
}

