/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.properties;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.layout.properties.PropertyFactory;
import org.eclipse.andmore.internal.editors.layout.properties.XmlProperty;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.ui.dialogs.ResizableDialog;

class FlagXmlPropertyDialog
extends ResizableDialog
implements IStructuredContentProvider,
ICheckStateListener,
SelectionListener,
KeyListener {
    private final String mTitle;
    private final XmlProperty mProperty;
    private final String[] mFlags;
    private final boolean mIsRadio;
    private Table mTable;
    private CheckboxTableViewer mViewer;

    FlagXmlPropertyDialog(Shell parentShell, String title, boolean isRadio, String[] flags, XmlProperty property) {
        super(parentShell, (AbstractUIPlugin)AndmoreAndroidPlugin.getDefault());
        this.mTitle = title;
        this.mIsRadio = isRadio;
        this.mFlags = flags;
        this.mProperty = property;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.mTitle);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.mViewer = CheckboxTableViewer.newCheckList((Composite)container, (int)100352);
        this.mTable = this.mViewer.getTable();
        this.mTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite workaround = PropertyFactory.addWorkaround(container);
        if (workaround != null) {
            workaround.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        }
        this.mViewer.setContentProvider((IContentProvider)this);
        this.mViewer.setInput((Object)this.mFlags);
        String current = this.mProperty.getStringValue();
        if (current != null) {
            Object[] checked = null;
            if (this.mIsRadio) {
                checked = new String[]{current};
            } else {
                ArrayList<String> flags = new ArrayList<String>();
                for (String s : Splitter.on((char)'|').omitEmptyStrings().trimResults().split((CharSequence)current)) {
                    flags.add(s);
                }
                checked = flags.toArray(new String[flags.size()]);
            }
            this.mViewer.setCheckedElements(checked);
        }
        if (this.mFlags.length > 0) {
            this.mTable.setSelection(0);
        }
        if (this.mIsRadio) {
            this.mViewer.addCheckStateListener((ICheckStateListener)this);
        }
        this.mTable.addSelectionListener((SelectionListener)this);
        this.mTable.addKeyListener((KeyListener)this);
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getDefaultSize() {
        return new Point(450, 400);
    }

    protected void okPressed() {
        ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                StringBuilder sb = new StringBuilder(30);
                Object[] objectArray = FlagXmlPropertyDialog.this.mViewer.getCheckedElements();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (sb.length() > 0) {
                        sb.append('|');
                    }
                    sb.append((String)o);
                    ++n2;
                }
                String value = sb.length() > 0 ? sb.toString() : null;
                FlagXmlPropertyDialog.this.mProperty.setValue(value);
            }
        });
        super.okPressed();
    }

    public Object[] getElements(Object inputElement) {
        return (Object[])inputElement;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        boolean isChecked = event.getChecked();
        if (isChecked) {
            Object selected = event.getElement();
            Object[] objectArray = this.mViewer.getCheckedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object other = objectArray[n2];
                if (other != selected) {
                    this.mViewer.setChecked(other, false);
                }
                ++n2;
            }
        }
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (e.item instanceof TableItem) {
            TableItem item;
            item.setChecked(!(item = (TableItem)e.item).getChecked());
        }
    }

    public void keyPressed(KeyEvent e) {
        if (e.keyCode == 32 && this.mTable.getSelectionCount() == 1) {
            TableItem item;
            item.setChecked(!(item = this.mTable.getSelection()[0]).getChecked());
        }
    }

    public void keyReleased(KeyEvent e) {
    }
}

