/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.launch;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.launch.AMReceiver;
import org.eclipse.andmore.internal.launch.DelayedLaunchInfo;
import org.eclipse.andmore.internal.launch.IAndroidLaunchAction;
import org.eclipse.andmore.internal.launch.ILaunchController;

public class ActivityLaunchAction
implements IAndroidLaunchAction {
    private final String mActivity;
    private final ILaunchController mLaunchController;

    public ActivityLaunchAction(String activity, ILaunchController controller) {
        this.mActivity = activity;
        this.mLaunchController = controller;
    }

    public boolean doLaunchAction(DelayedLaunchInfo info, IDevice device) {
        String command = "am start" + (info.isDebugMode() ? " -D" : "") + " -n " + info.getPackageName() + "/" + this.mActivity.replaceAll("\\$", "\\\\\\$") + " -a android.intent.action.MAIN" + " -c android.intent.category.LAUNCHER";
        try {
            String msg = String.format("Starting activity %1$s on device %2$s", this.mActivity, device);
            AndmoreAndroidPlugin.printToConsole(info.getProject(), msg);
            info.incrementAttemptCount();
            device.executeShellCommand(command, (IShellOutputReceiver)new AMReceiver(info, device, this.mLaunchController));
            if (!info.isDebugMode()) {
                return false;
            }
        }
        catch (TimeoutException timeoutException) {
            AndmoreAndroidPlugin.printErrorToConsole(info.getProject(), new Object[]{"Launch error: timeout"});
            return false;
        }
        catch (AdbCommandRejectedException e) {
            AndmoreAndroidPlugin.printErrorToConsole(info.getProject(), new Object[]{String.format("Launch error: adb rejected command: %1$s", e.getMessage())});
            return false;
        }
        catch (ShellCommandUnresponsiveException e) {
            AndmoreAndroidPlugin.log(e, "No command output when running: '%1$s' on device %2$s", command, device);
        }
        catch (IOException e) {
            AndmoreAndroidPlugin.printErrorToConsole(info.getProject(), new Object[]{String.format("Launch error: %s", e.getMessage())});
            return false;
        }
        return true;
    }

    @Override
    public boolean doLaunchAction(DelayedLaunchInfo info, Collection<IDevice> devices) {
        boolean result = true;
        for (IDevice d : devices) {
            boolean bl = result = this.doLaunchAction(info, d) && result;
        }
        return result;
    }

    @Override
    public String getLaunchDescription() {
        return String.format("%1$s activity launch", this.mActivity);
    }
}

