/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.lint;

import org.eclipse.andmore.internal.lint.LintColumn;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

class ColumnDialog
extends SelectionStatusDialog
implements Listener,
IStructuredContentProvider {
    private LintColumn[] mColumns;
    private LintColumn[] mSelectedColumns;
    private CheckboxTableViewer mViewer;

    public ColumnDialog(Shell parent, LintColumn[] fields, LintColumn[] selected) {
        super(parent);
        this.mColumns = fields;
        this.mSelectedColumns = selected;
        this.setTitle("Select Visible Columns");
        this.setHelpAvailable(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(4, 4, true, true, 1, 1);
        gridData.widthHint = 500;
        container.setLayoutData((Object)gridData);
        Label lblSelectVisibleColumns = new Label(container, 0);
        lblSelectVisibleColumns.setText("Select visible columns:");
        this.mViewer = CheckboxTableViewer.newCheckList((Composite)container, (int)100352);
        Table table = this.mViewer.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.mViewer.setContentProvider((IContentProvider)this);
        this.mViewer.setInput((Object)this.mColumns);
        this.mViewer.setCheckedElements((Object[])this.mSelectedColumns);
        this.validate();
        return container;
    }

    protected void computeResult() {
        Object[] checked = this.mViewer.getCheckedElements();
        this.mSelectedColumns = new LintColumn[checked.length];
        int i = 0;
        int n = checked.length;
        while (i < n) {
            this.mSelectedColumns[i] = (LintColumn)checked[i];
            ++i;
        }
    }

    public LintColumn[] getSelectedColumns() {
        return this.mSelectedColumns;
    }

    public void handleEvent(Event event) {
        this.validate();
    }

    private void validate() {
        this.computeResult();
        Status status = this.mViewer.getCheckedElements().length <= 1 ? new Status(4, "org.eclipse.andmore", "Must selected at least one column") : new Status(0, "org.eclipse.andmore", null);
        this.updateStatus((IStatus)status);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        return this.mColumns;
    }
}

