/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.lint;

import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Severity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.lint.EclipseLintClient;
import org.eclipse.jface.preference.IPreferenceStore;

class GlobalLintConfiguration
extends Configuration {
    private static final GlobalLintConfiguration sInstance = new GlobalLintConfiguration();
    private Map<Issue, Severity> mSeverities;
    private boolean mBulkEditing;

    private GlobalLintConfiguration() {
    }

    public static GlobalLintConfiguration get() {
        return sInstance;
    }

    public Severity getSeverity(Issue issue) {
        Severity severity;
        if (this.mSeverities == null) {
            IssueRegistry registry = EclipseLintClient.getRegistry();
            this.mSeverities = new HashMap<Issue, Severity>();
            IPreferenceStore store = this.getStore();
            String assignments = store.getString("org.eclipse.andmore.lintSeverities");
            if (assignments != null && assignments.length() > 0) {
                String[] stringArray = assignments.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Severity severity2;
                    Issue d;
                    String assignment = stringArray[n2];
                    String[] s = assignment.split("=");
                    if (s.length == 2 && (d = registry.getIssue(s[0])) != null && (severity2 = Severity.valueOf((String)s[1])) != null) {
                        this.mSeverities.put(d, severity2);
                    }
                    ++n2;
                }
            }
        }
        if ((severity = this.mSeverities.get(issue)) != null) {
            return severity;
        }
        if (!issue.isEnabledByDefault()) {
            return Severity.IGNORE;
        }
        return issue.getDefaultSeverity();
    }

    private IPreferenceStore getStore() {
        IPreferenceStore store = AndmoreAndroidPlugin.getDefault().getPreferenceStore();
        return store;
    }

    public void ignore(Context context, Issue issue, Location location, String message) {
        throw new UnsupportedOperationException("Can't ignore() in global configurations");
    }

    public void setSeverity(Issue issue, Severity severity) {
        if (this.mSeverities == null) {
            this.getSeverity(issue);
        }
        if (severity == null) {
            this.mSeverities.remove(issue);
        } else {
            this.mSeverities.put(issue, severity);
        }
        if (!this.mBulkEditing) {
            this.setSeverities(this.mSeverities);
        }
    }

    private boolean setSeverities(Map<Issue, Severity> severities) {
        IPreferenceStore store;
        String previous;
        boolean changed;
        this.mSeverities = severities;
        String value = "";
        if (severities.size() > 0) {
            ArrayList<Issue> sortedKeys = new ArrayList<Issue>(severities.keySet());
            Collections.sort(sortedKeys);
            StringBuilder sb = new StringBuilder(severities.size() * 20);
            for (Issue issue : sortedKeys) {
                Severity severity = severities.get(issue);
                if (severity == issue.getDefaultSeverity()) continue;
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(issue.getId());
                sb.append('=');
                sb.append(severity.name());
            }
            value = sb.toString();
        }
        boolean bl = changed = !value.equals(previous = (store = this.getStore()).getString("org.eclipse.andmore.lintSeverities"));
        if (changed) {
            if (value.length() == 0) {
                store.setToDefault("org.eclipse.andmore.lintSeverities");
            } else {
                store.setValue("org.eclipse.andmore.lintSeverities", value);
            }
        }
        return changed;
    }

    public void startBulkEditing() {
        this.mBulkEditing = true;
    }

    public void finishBulkEditing() {
        this.mBulkEditing = false;
        this.setSeverities(this.mSeverities);
    }
}

