/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.project;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class AndroidNature
implements IProjectNature {
    private IProject mProject;

    public void configure() throws CoreException {
        AndroidNature.configureResourceManagerBuilder(this.mProject);
        AndroidNature.configurePreBuilder(this.mProject);
        AndroidNature.configureApkBuilder(this.mProject);
    }

    public void deconfigure() throws CoreException {
        AndroidNature.removeBuilder(this.mProject, "org.eclipse.andmore.ResourceManagerBuilder");
        AndroidNature.removeBuilder(this.mProject, "org.eclipse.andmore.PreCompilerBuilder");
        AndroidNature.removeBuilder(this.mProject, "org.eclipse.andmore.ApkBuilder");
    }

    public IProject getProject() {
        return this.mProject;
    }

    public void setProject(IProject project) {
        this.mProject = project;
    }

    public static synchronized void setupProjectNatures(IProject project, IProgressMonitor monitor, boolean addAndroidNature) throws CoreException {
        System.out.println("Adding Android natures, setupProjectNatures");
        if (project == null || !project.isOpen()) {
            return;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        AndroidNature.addNatureToProjectDescription(project, "org.eclipse.jdt.core.javanature", monitor);
        if (addAndroidNature) {
            AndroidNature.addNatureToProjectDescription(project, "org.eclipse.andmore.AndroidNature", monitor);
        }
    }

    private static void addNatureToProjectDescription(IProject project, String natureId, IProgressMonitor monitor) throws CoreException {
        if (!project.hasNature(natureId)) {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            String[] newNatures = new String[natures.length + 1];
            if (natureId.equals("org.eclipse.andmore.AndroidNature")) {
                System.arraycopy(natures, 0, newNatures, 1, natures.length);
                newNatures[0] = natureId;
            } else {
                System.arraycopy(natures, 0, newNatures, 0, natures.length);
                newNatures[natures.length] = natureId;
            }
            description.setNatureIds(newNatures);
            project.setDescription(description, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        }
    }

    public static void configureResourceManagerBuilder(IProject project) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if ("org.eclipse.andmore.ResourceManagerBuilder".equals(commands[i].getBuilderName())) {
                return;
            }
            ++i;
        }
        ICommand[] newCommands = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, newCommands, 1, commands.length);
        ICommand command = desc.newCommand();
        command.setBuilderName("org.eclipse.andmore.ResourceManagerBuilder");
        newCommands[0] = command;
        desc.setBuildSpec(newCommands);
        project.setDescription(desc, null);
    }

    public static void configurePreBuilder(IProject project) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if ("org.eclipse.andmore.PreCompilerBuilder".equals(commands[i].getBuilderName())) {
                return;
            }
            ++i;
        }
        int index = -1;
        int i2 = 0;
        while (i2 < commands.length) {
            if ("org.eclipse.andmore.ResourceManagerBuilder".equals(commands[i2].getBuilderName())) {
                index = i2;
                break;
            }
            ++i2;
        }
        ICommand[] newCommands = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, newCommands, 0, ++index);
        ICommand command = desc.newCommand();
        command.setBuilderName("org.eclipse.andmore.PreCompilerBuilder");
        newCommands[index] = command;
        System.arraycopy(commands, index, newCommands, index + 1, commands.length - index);
        desc.setBuildSpec(newCommands);
        project.setDescription(desc, null);
    }

    public static void configureApkBuilder(IProject project) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if ("org.eclipse.andmore.ApkBuilder".equals(commands[i].getBuilderName())) {
                return;
            }
            ++i;
        }
        ICommand[] newCommands = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, newCommands, 0, commands.length);
        ICommand command = desc.newCommand();
        command.setBuilderName("org.eclipse.andmore.ApkBuilder");
        newCommands[commands.length] = command;
        desc.setBuildSpec(newCommands);
        project.setDescription(desc, null);
    }

    public static boolean removeBuilder(IProject project, String id) throws CoreException {
        IProjectDescription description = project.getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (id.equals(commands[i].getBuilderName())) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
                project.setDescription(description, null);
                return true;
            }
            ++i;
        }
        return false;
    }
}

