/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.refactorings.extractstring;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class XmlStringFileHelper {
    private HashMap<String, Map<String, String>> mResIdCache = new HashMap();

    public String valueOfStringId(IProject project, String xmlFileWsPath, String stringId) {
        Map<String, String> cache = this.getResIdsForFile(project, xmlFileWsPath);
        return cache.get(stringId);
    }

    public Map<String, String> getResIdsForFile(IProject project, String xmlFileWsPath) {
        Map<String, String> cache = this.mResIdCache.get(xmlFileWsPath);
        if (cache == null) {
            cache = this.internalGetResIdsForFile(project, xmlFileWsPath);
            this.mResIdCache.put(xmlFileWsPath, cache);
        }
        return cache;
    }

    private Map<String, String> internalGetResIdsForFile(IProject project, String xmlFileWsPath) {
        TreeMap<String, String> ids = new TreeMap<String, String>();
        IFile resource = project.getFile(xmlFileWsPath);
        if (resource != null && resource.exists() && resource.getType() == 1) {
            IStructuredModel smodel = null;
            try {
                try {
                    IDOMDocument doc;
                    Node root;
                    IFile file = resource;
                    IModelManager modelMan = StructuredModelManager.getModelManager();
                    smodel = modelMan.getExistingModelForRead(file);
                    if (smodel == null) {
                        smodel = modelMan.getModelForRead(file);
                    }
                    if (smodel instanceof IDOMModel && (root = this.findChild((Node)(doc = ((IDOMModel)smodel).getDocument()), null, "resources")) != null) {
                        Node strNode = this.findChild(root, null, "string");
                        while (strNode != null) {
                            NamedNodeMap attrs = strNode.getAttributes();
                            Node nameAttr = attrs.getNamedItem("name");
                            if (nameAttr != null) {
                                String id = nameAttr.getNodeValue();
                                String text = "";
                                Node txtNode = strNode.getFirstChild();
                                while (txtNode != null && txtNode.getNodeType() == 3) {
                                    text = String.valueOf(text) + txtNode.getNodeValue();
                                    txtNode = txtNode.getNextSibling();
                                }
                                ids.put(id, text);
                            }
                            strNode = this.findChild(null, strNode, "string");
                        }
                    }
                }
                catch (Throwable e) {
                    AndmoreAndroidPlugin.log(e, "GetResIds failed in %1$s", xmlFileWsPath);
                    if (smodel != null) {
                        smodel.releaseFromRead();
                    }
                }
            }
            finally {
                if (smodel != null) {
                    smodel.releaseFromRead();
                }
            }
        }
        return ids;
    }

    private Node findChild(Node parent, Node lastChild, String elementName) {
        if (lastChild == null && parent != null) {
            lastChild = parent.getFirstChild();
        } else if (lastChild != null) {
            lastChild = lastChild.getNextSibling();
        }
        while (lastChild != null) {
            if (lastChild.getNodeType() == 1 && lastChild.getNamespaceURI() == null && elementName.equals(lastChild.getLocalName())) {
                return lastChild;
            }
            lastChild = lastChild.getNextSibling();
        }
        return null;
    }
}

