/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.resources;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceDeltaKind;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ResourceUrl;
import com.android.ide.common.resources.configuration.CountryCodeQualifier;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.KeyboardStateQualifier;
import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.resources.configuration.NavigationMethodQualifier;
import com.android.ide.common.resources.configuration.NavigationStateQualifier;
import com.android.ide.common.resources.configuration.NetworkCodeQualifier;
import com.android.ide.common.resources.configuration.NightModeQualifier;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.ide.common.resources.configuration.ScreenDimensionQualifier;
import com.android.ide.common.resources.configuration.ScreenHeightQualifier;
import com.android.ide.common.resources.configuration.ScreenOrientationQualifier;
import com.android.ide.common.resources.configuration.ScreenRatioQualifier;
import com.android.ide.common.resources.configuration.ScreenSizeQualifier;
import com.android.ide.common.resources.configuration.ScreenWidthQualifier;
import com.android.ide.common.resources.configuration.SmallestScreenWidthQualifier;
import com.android.ide.common.resources.configuration.TextInputMethodQualifier;
import com.android.ide.common.resources.configuration.TouchScreenQualifier;
import com.android.ide.common.resources.configuration.UiModeQualifier;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.utils.Pair;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.AndroidXmlEditor;
import org.eclipse.andmore.internal.editors.Hyperlinks;
import org.eclipse.andmore.internal.editors.IconFactory;
import org.eclipse.andmore.internal.editors.layout.gle2.ImageUtils;
import org.eclipse.andmore.internal.editors.layout.refactoring.VisualRefactoring;
import org.eclipse.andmore.internal.resources.ResourceNameValidator;
import org.eclipse.andmore.internal.wizards.newxmlfile.NewXmlFileWizard;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class ResourceHelper {
    private static final Map<Class<?>, Image> sIconMap = new HashMap(FolderConfiguration.getQualifierCount());

    static {
        try {
            IconFactory factory = IconFactory.getInstance();
            sIconMap.put(CountryCodeQualifier.class, factory.getIcon("mcc"));
            sIconMap.put(NetworkCodeQualifier.class, factory.getIcon("mnc"));
            sIconMap.put(LocaleQualifier.class, factory.getIcon("language"));
            sIconMap.put(LayoutDirectionQualifier.class, factory.getIcon("bidi"));
            sIconMap.put(ScreenSizeQualifier.class, factory.getIcon("size"));
            sIconMap.put(ScreenRatioQualifier.class, factory.getIcon("ratio"));
            sIconMap.put(ScreenOrientationQualifier.class, factory.getIcon("orientation"));
            sIconMap.put(UiModeQualifier.class, factory.getIcon("dockmode"));
            sIconMap.put(NightModeQualifier.class, factory.getIcon("nightmode"));
            sIconMap.put(DensityQualifier.class, factory.getIcon("dpi"));
            sIconMap.put(TouchScreenQualifier.class, factory.getIcon("touch"));
            sIconMap.put(KeyboardStateQualifier.class, factory.getIcon("keyboard"));
            sIconMap.put(TextInputMethodQualifier.class, factory.getIcon("text_input"));
            sIconMap.put(NavigationStateQualifier.class, factory.getIcon("navpad"));
            sIconMap.put(NavigationMethodQualifier.class, factory.getIcon("navpad"));
            sIconMap.put(ScreenDimensionQualifier.class, factory.getIcon("dimension"));
            sIconMap.put(VersionQualifier.class, factory.getIcon("version"));
            sIconMap.put(ScreenWidthQualifier.class, factory.getIcon("width"));
            sIconMap.put(ScreenHeightQualifier.class, factory.getIcon("height"));
            sIconMap.put(SmallestScreenWidthQualifier.class, factory.getIcon("swidth"));
        }
        catch (Throwable t) {
            AndmoreAndroidPlugin.log(t, null, new Object[0]);
        }
    }

    public static Image getIcon(Class<? extends ResourceQualifier> theClass) {
        return sIconMap.get(theClass);
    }

    public static ResourceDeltaKind getResourceDeltaKind(int kind) {
        switch (kind) {
            case 1: {
                return ResourceDeltaKind.ADDED;
            }
            case 2: {
                return ResourceDeltaKind.REMOVED;
            }
            case 4: {
                return ResourceDeltaKind.CHANGED;
            }
        }
        return null;
    }

    public static boolean isValueBasedResourceType(ResourceType type) {
        List folderTypes = FolderTypeRelationship.getRelatedFolders((ResourceType)type);
        for (ResourceFolderType folderType : folderTypes) {
            if (folderType != ResourceFolderType.VALUES) continue;
            return true;
        }
        return false;
    }

    public static boolean isFileBasedResourceType(ResourceType type) {
        List folderTypes = FolderTypeRelationship.getRelatedFolders((ResourceType)type);
        for (ResourceFolderType folderType : folderTypes) {
            if (folderType == ResourceFolderType.VALUES) continue;
            return type != ResourceType.ID;
        }
        return false;
    }

    public static boolean canCreateResource(String resource) {
        if (resource.startsWith("@android:")) {
            return false;
        }
        ResourceUrl parsed = ResourceUrl.parse((String)resource);
        if (parsed != null) {
            if (parsed.framework) {
                return false;
            }
            ResourceType type = parsed.type;
            String name = parsed.name;
            ResourceNameValidator validator = ResourceNameValidator.create(false, null, type);
            if (validator.isValid(name) != null) {
                return false;
            }
            return ResourceHelper.canCreateResourceType(type);
        }
        return false;
    }

    public static boolean canCreateResourceType(ResourceType type) {
        if (ResourceHelper.isValueBasedResourceType(type)) {
            return true;
        }
        for (ResourceFolderType folderType : FolderTypeRelationship.getRelatedFolders((ResourceType)type)) {
            if (!NewXmlFileWizard.canCreateXmlFile(folderType)) continue;
            return true;
        }
        return false;
    }

    private static Pair<IFile, IRegion> createFileResource(IProject project, ResourceType type, String name) {
        ResourceFolderType folderType = null;
        for (ResourceFolderType f : FolderTypeRelationship.getRelatedFolders((ResourceType)type)) {
            if (!NewXmlFileWizard.canCreateXmlFile(f)) continue;
            folderType = f;
            break;
        }
        if (folderType == null) {
            return null;
        }
        Path projectPath = new Path("res/" + folderType.getName() + "/" + name + '.' + "xml");
        IFile file = project.getFile((IPath)projectPath);
        return NewXmlFileWizard.createXmlFile(project, file, folderType);
    }

    public static Pair<IFile, IRegion> createResource(IProject project, ResourceType type, String name, String value) {
        int end;
        int start;
        boolean createEmptyTag;
        if (!ResourceHelper.isValueBasedResourceType(type)) {
            return ResourceHelper.createFileResource(project, type, name);
        }
        String typeName = type.getName();
        String fileName = String.valueOf(typeName) + 's';
        String projectPath = "res/values/" + fileName + '.' + "xml";
        IProject editRequester = project;
        IResource member = project.findMember(projectPath);
        String tagName = Hyperlinks.getTagName(type);
        boolean bl = createEmptyTag = type == ResourceType.ID;
        if (member != null) {
            if (member instanceof IFile) {
                IFile file = (IFile)member;
                IModelManager manager = StructuredModelManager.getModelManager();
                IStructuredModel model = null;
                try {
                    model = manager.getExistingModelForEdit(file);
                    if (model == null) {
                        model = manager.getModelForEdit(file);
                    }
                    if (model instanceof IDOMModel) {
                        model.beginRecording((Object)editRequester, String.format("Add %1$s", type.getDisplayName()));
                        IDOMModel domModel = (IDOMModel)model;
                        IDOMDocument document = domModel.getDocument();
                        Element root = document.getDocumentElement();
                        IStructuredDocument structuredDocument = model.getStructuredDocument();
                        Node lastElement = null;
                        NodeList childNodes = root.getChildNodes();
                        String indent = null;
                        int i = childNodes.getLength() - 1;
                        while (i >= 0) {
                            Node node = childNodes.item(i);
                            if (node.getNodeType() == 1) {
                                lastElement = node;
                                indent = AndroidXmlEditor.getIndent((IDocument)structuredDocument, node);
                                break;
                            }
                            --i;
                        }
                        if (indent == null || indent.length() == 0) {
                            indent = "    ";
                        }
                        Node nextChild = lastElement != null ? lastElement.getNextSibling() : null;
                        Text indentNode = document.createTextNode(String.valueOf('\n') + indent);
                        root.insertBefore(indentNode, nextChild);
                        Element element = document.createElement(tagName);
                        if (createEmptyTag && element instanceof ElementImpl) {
                            ElementImpl elementImpl = (ElementImpl)element;
                            elementImpl.setEmptyTag(true);
                        }
                        element.setAttribute("name", name);
                        if (!tagName.equals(typeName)) {
                            element.setAttribute("type", typeName);
                        }
                        root.insertBefore(element, nextChild);
                        Region region = null;
                        if (createEmptyTag) {
                            IndexedRegion domRegion = VisualRefactoring.getRegion(element);
                            int endOffset = domRegion.getEndOffset();
                            region = new Region(endOffset, 0);
                        } else {
                            Text valueNode = document.createTextNode(value);
                            element.appendChild(valueNode);
                            IndexedRegion domRegion = VisualRefactoring.getRegion(valueNode);
                            int startOffset = domRegion.getStartOffset();
                            int length = domRegion.getLength();
                            region = new Region(startOffset, length);
                        }
                        model.save();
                        Pair pair = Pair.of((Object)file, (Object)region);
                        return pair;
                    }
                }
                catch (Exception e) {
                    AndmoreAndroidPlugin.log(e, "Cannot access XML value model", new Object[0]);
                }
                finally {
                    if (model != null) {
                        model.endRecording((Object)editRequester);
                        model.releaseFromEdit();
                    }
                }
            }
            return null;
        }
        String prolog = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
        StringBuilder sb = new StringBuilder(prolog);
        String root = "resources";
        sb.append('<').append(root).append('>').append('\n');
        sb.append("    ");
        sb.append('<');
        sb.append(tagName);
        sb.append(" name=\"");
        sb.append(name);
        sb.append('\"');
        if (!tagName.equals(typeName)) {
            sb.append(" type=\"");
            sb.append(typeName);
            sb.append('\"');
        }
        if (createEmptyTag) {
            sb.append("/>");
            start = sb.length();
            end = sb.length();
        } else {
            sb.append('>');
            start = sb.length();
            sb.append(value);
            end = sb.length();
            sb.append('<').append('/');
            sb.append(tagName);
            sb.append('>');
        }
        sb.append('\n').append('<').append('/').append(root).append('>').append('\n');
        String result = sb.toString();
        String error = null;
        try {
            byte[] buf = result.getBytes("UTF8");
            ByteArrayInputStream stream = new ByteArrayInputStream(buf);
            IFile file = project.getFile((IPath)new Path(projectPath));
            file.create((InputStream)stream, true, null);
            Region region = new Region(start, end - start);
            return Pair.of((Object)file, (Object)region);
        }
        catch (UnsupportedEncodingException e) {
            error = e.getMessage();
        }
        catch (CoreException e) {
            error = e.getMessage();
        }
        error = String.format("Failed to generate %1$s: %2$s", name, error);
        AndmoreAndroidPlugin.displayError("New Android XML File", error);
        return null;
    }

    public static String styleToTheme(String style) {
        int index;
        if (style.startsWith("@style/")) {
            style = style.substring("@style/".length());
        } else if (style.startsWith("@android:style/")) {
            style = style.substring("@android:style/".length());
        } else if (style.startsWith("@") && (index = style.indexOf(47)) != -1) {
            style = style.substring(index + 1);
        }
        return style;
    }

    public static boolean isProjectStyle(String style) {
        assert (style.startsWith("@style/") || style.startsWith("@android:style/")) : style;
        return style.startsWith("@style/");
    }

    public static String getLayoutName(IFile layoutFile) {
        String layoutName = layoutFile.getName();
        int dotIndex = layoutName.indexOf(46);
        if (dotIndex != -1) {
            layoutName = layoutName.substring(0, dotIndex);
        }
        return layoutName;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RGB resolveColor(ResourceResolver resources, ResourceValue color) {
        if ((color = resources.resolveResValue(color)) == null) {
            return null;
        }
        String value = color.getValue();
        while (value != null) {
            if (value.startsWith("#")) {
                try {
                    int rgba = ImageUtils.getColor(value);
                    return ImageUtils.intToRgb(rgba);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            if (value.startsWith("@")) {
                boolean isFramework = color.isFramework();
                if ((color = resources.findResValue(value, isFramework)) == null) return null;
                value = color.getValue();
                continue;
            }
            File file = new File(value);
            if (!file.exists() || !file.getName().endsWith(".xml")) return null;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            BufferedInputStream bis = null;
            bis = new BufferedInputStream(new FileInputStream(file));
            InputSource is = new InputSource(bis);
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(is);
            NodeList items = document.getElementsByTagName("item");
            value = ResourceHelper.findColorValue(items);
            if (bis == null) continue;
            try {
                bis.close();
            }
            catch (IOException iOException) {}
            continue;
            catch (Exception e) {
                try {
                    AndmoreAndroidPlugin.log(e, "Failed parsing color file %1$s", file.getName());
                    if (bis == null) return null;
                }
                catch (Throwable throwable) {
                    if (bis == null) throw throwable;
                    try {
                        bis.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    bis.close();
                    return null;
                }
                catch (IOException iOException) {}
                return null;
            }
        }
        return null;
    }

    private static String findColorValue(NodeList items) {
        int i = 0;
        int n = items.getLength();
        while (i < n) {
            Element element;
            Node item = items.item(i);
            boolean hasState = false;
            if (item.getNodeType() == 1 && (element = (Element)item).hasAttributeNS("http://schemas.android.com/apk/res/android", "color")) {
                NamedNodeMap attributes = element.getAttributes();
                int j = 0;
                int m = attributes.getLength();
                while (j < m) {
                    Attr attribute = (Attr)attributes.item(j);
                    if (attribute.getLocalName().startsWith("state_")) {
                        hasState = true;
                        break;
                    }
                    ++j;
                }
                if (!hasState) {
                    return element.getAttributeNS("http://schemas.android.com/apk/res/android", "color");
                }
            }
            ++i;
        }
        return null;
    }
}

