/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.resources.manager;

import java.util.ArrayList;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.project.BaseProjectHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public final class GlobalProjectMonitor {
    private static final GlobalProjectMonitor sThis = new GlobalProjectMonitor();
    private final ArrayList<FileListenerBundle> mFileListeners = new ArrayList();
    private final ArrayList<FolderListenerBundle> mFolderListeners = new ArrayList();
    private final ArrayList<IProjectListener> mProjectListeners = new ArrayList();
    private final ArrayList<IResourceEventListener> mEventListeners = new ArrayList();
    private final ArrayList<IRawDeltaListener> mRawDeltaListeners = new ArrayList();
    private IWorkspace mWorkspace;
    private boolean mIsAndroidProject;
    private IResourceChangeListener mResourceChangeListener = new IResourceChangeListener(){

        public synchronized void resourceChanged(IResourceChangeEvent event) {
            GlobalProjectMonitor.this.notifyResourceEventStart();
            if (event.getType() == 4) {
                IResource r = event.getResource();
                IProject project = r.getProject();
                for (IProjectListener pl : GlobalProjectMonitor.this.mProjectListeners) {
                    try {
                        if (!project.hasNature("org.eclipse.andmore.AndroidNature")) continue;
                        try {
                            pl.projectDeleted(project);
                        }
                        catch (Throwable t) {
                            AndmoreAndroidPlugin.log(t, "Failed to call IProjectListener.projectDeleted", new Object[0]);
                        }
                    }
                    catch (CoreException coreException) {}
                }
            } else {
                IResourceDelta delta = event.getDelta();
                for (IRawDeltaListener listener : GlobalProjectMonitor.this.mRawDeltaListeners) {
                    listener.visitDelta(delta);
                }
                DeltaVisitor visitor = new DeltaVisitor();
                try {
                    delta.accept((IResourceDeltaVisitor)visitor);
                }
                catch (CoreException coreException) {}
            }
            GlobalProjectMonitor.this.notifyResourceEventEnd();
        }
    };

    public static GlobalProjectMonitor getMonitor() {
        return sThis;
    }

    public static GlobalProjectMonitor startMonitoring(IWorkspace ws) {
        if (sThis != null) {
            ws.addResourceChangeListener(GlobalProjectMonitor.sThis.mResourceChangeListener, 5);
            GlobalProjectMonitor.sThis.mWorkspace = ws;
        }
        return sThis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopMonitoring(IWorkspace ws) {
        if (sThis != null) {
            ws.removeResourceChangeListener(GlobalProjectMonitor.sThis.mResourceChangeListener);
            GlobalProjectMonitor globalProjectMonitor = sThis;
            synchronized (globalProjectMonitor) {
                GlobalProjectMonitor.sThis.mFileListeners.clear();
                GlobalProjectMonitor.sThis.mProjectListeners.clear();
            }
        }
    }

    public synchronized void addFileListener(IFileListener listener, int kindMask) {
        FileListenerBundle bundle = new FileListenerBundle();
        bundle.listener = listener;
        bundle.kindMask = kindMask;
        this.mFileListeners.add(bundle);
    }

    public synchronized void removeFileListener(IFileListener listener) {
        int i = 0;
        while (i < this.mFileListeners.size()) {
            FileListenerBundle bundle = this.mFileListeners.get(i);
            if (bundle.listener == listener) {
                this.mFileListeners.remove(i);
                return;
            }
            ++i;
        }
    }

    public synchronized void addFolderListener(IFolderListener listener, int kindMask) {
        FolderListenerBundle bundle = new FolderListenerBundle();
        bundle.listener = listener;
        bundle.kindMask = kindMask;
        this.mFolderListeners.add(bundle);
    }

    public synchronized void removeFolderListener(IFolderListener listener) {
        int i = 0;
        while (i < this.mFolderListeners.size()) {
            FolderListenerBundle bundle = this.mFolderListeners.get(i);
            if (bundle.listener == listener) {
                this.mFolderListeners.remove(i);
                return;
            }
            ++i;
        }
    }

    public synchronized void addProjectListener(IProjectListener listener) {
        this.mProjectListeners.add(listener);
        IWorkspaceRoot workspaceRoot = this.mWorkspace.getRoot();
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)workspaceRoot);
        IJavaProject[] androidProjects = BaseProjectHelper.getAndroidProjects(javaModel, null);
        this.notifyResourceEventStart();
        IJavaProject[] iJavaProjectArray = androidProjects;
        int n = androidProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject androidProject = iJavaProjectArray[n2];
            listener.projectOpenedWithWorkspace(androidProject.getProject());
            ++n2;
        }
        listener.allProjectsOpenedWithWorkspace();
        this.notifyResourceEventEnd();
    }

    public synchronized void removeProjectListener(IProjectListener listener) {
        this.mProjectListeners.remove(listener);
    }

    public synchronized void addResourceEventListener(IResourceEventListener listener) {
        this.mEventListeners.add(listener);
    }

    public synchronized void removeResourceEventListener(IResourceEventListener listener) {
        this.mEventListeners.remove(listener);
    }

    public synchronized void addRawDeltaListener(IRawDeltaListener listener) {
        this.mRawDeltaListeners.add(listener);
    }

    public synchronized void removeRawDeltaListener(IRawDeltaListener listener) {
        this.mRawDeltaListeners.remove(listener);
    }

    private void notifyResourceEventStart() {
        for (IResourceEventListener listener : this.mEventListeners) {
            try {
                listener.resourceChangeEventStart();
            }
            catch (Throwable t) {
                AndmoreAndroidPlugin.log(t, "Failed to call IResourceEventListener.resourceChangeEventStart", new Object[0]);
            }
        }
    }

    private void notifyResourceEventEnd() {
        for (IResourceEventListener listener : this.mEventListeners) {
            try {
                listener.resourceChangeEventEnd();
            }
            catch (Throwable t) {
                AndmoreAndroidPlugin.log(t, "Failed to call IResourceEventListener.resourceChangeEventEnd", new Object[0]);
            }
        }
    }

    private final class DeltaVisitor
    implements IResourceDeltaVisitor {
        private DeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) {
            IResource r = delta.getResource();
            int type = r.getType();
            if (type == 1) {
                int kind = delta.getKind();
                for (FileListenerBundle bundle : GlobalProjectMonitor.this.mFileListeners) {
                    if (bundle.kindMask != -1 && (bundle.kindMask & kind) == 0) continue;
                    try {
                        bundle.listener.fileChanged((IFile)r, delta.getMarkerDeltas(), kind, r.getFileExtension(), delta.getFlags(), GlobalProjectMonitor.this.mIsAndroidProject);
                    }
                    catch (Throwable t) {
                        AndmoreAndroidPlugin.log(t, "Failed to call IFileListener.fileChanged", new Object[0]);
                    }
                }
                return false;
            }
            if (type == 2) {
                int kind = delta.getKind();
                for (FolderListenerBundle bundle : GlobalProjectMonitor.this.mFolderListeners) {
                    if (bundle.kindMask != -1 && (bundle.kindMask & kind) == 0) continue;
                    try {
                        bundle.listener.folderChanged((IFolder)r, kind, GlobalProjectMonitor.this.mIsAndroidProject);
                    }
                    catch (Throwable t) {
                        AndmoreAndroidPlugin.log(t, "Failed to call IFileListener.folderChanged", new Object[0]);
                    }
                }
                return true;
            }
            if (type == 4) {
                IProject project = (IProject)r;
                try {
                    GlobalProjectMonitor.this.mIsAndroidProject = project.hasNature("org.eclipse.andmore.AndroidNature");
                }
                catch (CoreException coreException) {
                    return false;
                }
                if (!GlobalProjectMonitor.this.mIsAndroidProject) {
                    return true;
                }
                int flags = delta.getFlags();
                if ((flags & 0x4000) != 0) {
                    if (project.isOpen()) {
                        for (IProjectListener pl : GlobalProjectMonitor.this.mProjectListeners) {
                            try {
                                pl.projectOpened(project);
                            }
                            catch (Throwable t) {
                                AndmoreAndroidPlugin.log(t, "Failed to call IProjectListener.projectOpened", new Object[0]);
                            }
                        }
                    } else {
                        for (IProjectListener pl : GlobalProjectMonitor.this.mProjectListeners) {
                            try {
                                pl.projectClosed(project);
                            }
                            catch (Throwable t) {
                                AndmoreAndroidPlugin.log(t, "Failed to call IProjectListener.projectClosed", new Object[0]);
                            }
                        }
                    }
                    if ((flags & 0x1000) != 0) {
                        IPath from = delta.getMovedFromPath();
                        for (IProjectListener pl : GlobalProjectMonitor.this.mProjectListeners) {
                            try {
                                pl.projectRenamed(project, from);
                            }
                            catch (Throwable t) {
                                AndmoreAndroidPlugin.log(t, "Failed to call IProjectListener.projectRenamed", new Object[0]);
                            }
                        }
                    }
                }
            }
            return true;
        }
    }

    private static class FileListenerBundle
    extends ListenerBundle {
        IFileListener listener;

        private FileListenerBundle() {
        }
    }

    private static class FolderListenerBundle
    extends ListenerBundle {
        IFolderListener listener;

        private FolderListenerBundle() {
        }
    }

    public static interface IFileListener {
        public void fileChanged(IFile var1, IMarkerDelta[] var2, int var3, String var4, int var5, boolean var6);
    }

    public static interface IFolderListener {
        public void folderChanged(IFolder var1, int var2, boolean var3);
    }

    public static interface IProjectListener {
        public void projectOpenedWithWorkspace(IProject var1);

        public void allProjectsOpenedWithWorkspace();

        public void projectOpened(IProject var1);

        public void projectClosed(IProject var1);

        public void projectDeleted(IProject var1);

        public void projectRenamed(IProject var1, IPath var2);
    }

    public static interface IRawDeltaListener {
        public void visitDelta(IResourceDelta var1);
    }

    public static interface IResourceEventListener {
        public void resourceChangeEventStart();

        public void resourceChangeEventEnd();
    }

    private static class ListenerBundle {
        public static final int MASK_NONE = -1;
        int kindMask;

        private ListenerBundle() {
        }
    }
}

