/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.ui;

import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ResourceContentProvider
implements ITreeContentProvider {
    private ResourceRepository mResources;
    private boolean mFullLevels;

    public ResourceContentProvider(boolean fullLevels) {
        this.mFullLevels = fullLevels;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ResourceType) {
            Object[] array = this.mResources.getResourceItemsOfType((ResourceType)parentElement).toArray();
            Arrays.sort(array);
            return array;
        }
        if (this.mFullLevels && parentElement instanceof ResourceItem) {
            return ((ResourceItem)parentElement).getSourceFileArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ResourceType) {
            return this.mResources.hasResourcesOfType((ResourceType)element);
        }
        if (this.mFullLevels && element instanceof ResourceItem) {
            return ((ResourceItem)element).hasAlternates();
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof ResourceRepository && (ResourceRepository)inputElement == this.mResources) {
            List types = this.mResources.getAvailableResourceTypes();
            Collections.sort(types);
            return types.toArray();
        }
        return new Object[0];
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof ResourceRepository) {
            this.mResources = (ResourceRepository)newInput;
        }
    }
}

