/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.wizards.templates;

import com.android.utils.Pair;
import java.io.File;
import java.net.URL;
import java.util.List;
import org.eclipse.andmore.internal.actions.AddSupportJarAction;
import org.eclipse.andmore.internal.wizards.templates.TemplateMetadata;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;

class InstallDependencyPage
extends WizardPage
implements SelectionListener {
    static final String SUPPORT_LIBRARY_NAME = "android-support-v4";
    private static final String URL = "http://developer.android.com/tools/extras/support-library.html";
    private Button mCheckButton;
    private Button mInstallButton;
    private Link mLink;
    private TemplateMetadata mTemplate;
    static String sCachedName;
    static int sCachedVersion;
    private Label requiredLabel;
    private Label installedLabel;
    private Label mRequiredVersion;
    private Label mInstalledVersion;

    InstallDependencyPage() {
        super("dependency");
        this.setTitle("Install Dependencies");
    }

    void setTemplate(TemplateMetadata template) {
        if (template != this.mTemplate) {
            this.mTemplate = template;
            if (this.getControl() != null) {
                this.validatePage();
            }
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.updateVersionLabels();
            this.validatePage();
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(2, false));
        Label dependLabel = new Label(container, 64);
        GridData gd_dependLabel = new GridData(16384, 128, true, false, 2, 1);
        gd_dependLabel.widthHint = 550;
        dependLabel.setLayoutData((Object)gd_dependLabel);
        dependLabel.setText("This template depends on the Android Support library, which is either not installed, or the template depends on a more recent version than the one you have installed.");
        this.mLink = new Link(container, 0);
        this.mLink.setLayoutData((Object)new GridData(16384, 128, false, false, 2, 1));
        this.mLink.setText("<a href=\"http://developer.android.com/tools/extras/support-library.html\">http://developer.android.com/tools/extras/support-library.html</a>");
        this.mLink.addSelectionListener((SelectionListener)this);
        Label lblNewLabel_1 = new Label(container, 0);
        lblNewLabel_1.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.requiredLabel = new Label(container, 0);
        this.requiredLabel.setText("Required version:");
        this.mRequiredVersion = new Label(container, 0);
        this.mRequiredVersion.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.installedLabel = new Label(container, 0);
        this.installedLabel.setText("Installed version:");
        this.mInstalledVersion = new Label(container, 0);
        this.mInstalledVersion.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Label lblNewLabel = new Label(container, 0);
        lblNewLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        Label descLabel = new Label(container, 64);
        GridData gd_descLabel = new GridData(16384, 128, true, false, 2, 1);
        gd_descLabel.widthHint = 550;
        descLabel.setLayoutData((Object)gd_descLabel);
        descLabel.setText("You can install or upgrade it by clicking the Install button below, or alternatively, you can install it outside of Eclipse with the SDK Manager, then click on \"Check Again\" to proceed.");
        this.mInstallButton = new Button(container, 0);
        this.mInstallButton.setText("Install/Upgrade");
        this.mInstallButton.addSelectionListener((SelectionListener)this);
        this.mCheckButton = new Button(container, 0);
        this.mCheckButton.setText("Check Again");
        this.mCheckButton.addSelectionListener((SelectionListener)this);
        this.mInstallButton.setFocus();
    }

    private void showNextPage() {
        this.validatePage();
        if (this.isPageComplete()) {
            this.mInstallButton.setEnabled(false);
            this.mCheckButton.setEnabled(false);
            IWizard wizard = this.getWizard();
            IWizardPage next = wizard.getNextPage((IWizardPage)this);
            if (next != null) {
                wizard.getContainer().showPage(next);
            }
        }
    }

    public boolean isPageComplete() {
        if (this.mTemplate == null) {
            return true;
        }
        return super.isPageComplete() && this.isInstalled();
    }

    private boolean isInstalled() {
        return InstallDependencyPage.isInstalled(this.mTemplate.getDependencies());
    }

    public static boolean isInstalled(List<Pair<String, Integer>> dependencies) {
        for (Pair<String, Integer> dependency : dependencies) {
            String name = (String)dependency.getFirst();
            int required = (Integer)dependency.getSecond();
            int installed = -1;
            if (SUPPORT_LIBRARY_NAME.equals(name)) {
                installed = InstallDependencyPage.getInstalledSupportLibVersion();
            }
            if (installed == -1) {
                return false;
            }
            if (required <= installed) continue;
            return false;
        }
        return true;
    }

    private static int getInstalledSupportLibVersion() {
        if (SUPPORT_LIBRARY_NAME.equals(sCachedName)) {
            return sCachedVersion;
        }
        int version = AddSupportJarAction.getInstalledRevision();
        sCachedName = SUPPORT_LIBRARY_NAME;
        sCachedVersion = version;
        return version;
    }

    private void updateVersionLabels() {
        int version = InstallDependencyPage.getInstalledSupportLibVersion();
        if (version == -1) {
            this.mInstalledVersion.setText("Not installed");
        } else {
            this.mInstalledVersion.setText(Integer.toString(version));
        }
        if (this.mTemplate != null) {
            for (Pair<String, Integer> dependency : this.mTemplate.getDependencies()) {
                String name = (String)dependency.getFirst();
                if (!name.equals(SUPPORT_LIBRARY_NAME)) continue;
                int required = (Integer)dependency.getSecond();
                this.mRequiredVersion.setText(Integer.toString(required));
                break;
            }
        }
    }

    private void validatePage() {
        if (this.mTemplate == null) {
            return;
        }
        Status status = null;
        List<Pair<String, Integer>> dependencies = this.mTemplate.getDependencies();
        if (dependencies.size() > 1 || dependencies.size() == 1 && !((String)dependencies.get(0).getFirst()).equals(SUPPORT_LIBRARY_NAME)) {
            status = new Status(2, "org.eclipse.andmore", "Unsupported template dependency: Upgrade your Android Eclipse plugin");
        }
        this.setPageComplete(status == null || status.getSeverity() != 4);
        if (status != null) {
            this.setMessage(status.getMessage(), status.getSeverity() == 4 ? 3 : 2);
        } else {
            this.setErrorMessage(null);
            this.setMessage(null);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        block6: {
            Object source;
            block7: {
                block5: {
                    source = e.getSource();
                    if (source != this.mCheckButton) break block5;
                    sCachedName = null;
                    if (this.isInstalled()) {
                        this.showNextPage();
                    }
                    this.updateVersionLabels();
                    break block6;
                }
                if (source != this.mInstallButton) break block7;
                sCachedName = null;
                for (Pair<String, Integer> dependency : this.mTemplate.getDependencies()) {
                    String name = (String)dependency.getFirst();
                    if (!SUPPORT_LIBRARY_NAME.equals(name)) continue;
                    int version = (Integer)dependency.getSecond();
                    File installed = AddSupportJarAction.installSupport(version);
                    if (installed != null) {
                        this.showNextPage();
                    }
                    this.updateVersionLabels();
                }
                break block6;
            }
            if (source != this.mLink) break block6;
            try {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWebBrowser browser = workbench.getBrowserSupport().getExternalBrowser();
                browser.openURL(new URL(URL));
            }
            catch (Exception exception) {
                String message = String.format("Could not open browser. Vist\n%1$s\ninstead.", URL);
                MessageDialog.openError((Shell)this.getShell(), (String)"Browser Error", (String)message);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

