/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.wizards.templates;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.andmore.AdtUtils;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.layout.gle2.DomUtilities;
import org.eclipse.andmore.internal.preferences.AdtPrefs;
import org.eclipse.andmore.internal.wizards.templates.TemplateMetadata;
import org.w3c.dom.Document;

public class TemplateManager {
    private static final Set<String> EXCLUDED_CATEGORIES = Sets.newHashSet((Object[])new String[]{"Folder", "Google"});
    private static final Set<String> EXCLUDED_FORMFACTORS = Sets.newHashSet((Object[])new String[]{"Wear", "TV"});
    private Map<File, TemplateMetadata> mTemplateMap;

    TemplateManager() {
    }

    public static File getTemplateRootFolder() {
        File folder;
        String location = AdtPrefs.getPrefs().getOsSdkFolder();
        if (location != null && (folder = new File(location, "tools" + File.separator + "templates")).isDirectory()) {
            return folder;
        }
        return null;
    }

    public static List<File> getExtraTemplateRootFolders() {
        File extras;
        ArrayList<File> folders = new ArrayList<File>();
        String location = AdtPrefs.getPrefs().getOsSdkFolder();
        if (location != null && (extras = new File(location, "extras")).isDirectory()) {
            File[] fileArray = AdtUtils.listFiles(extras);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File vendor = fileArray[n2];
                if (vendor.isDirectory()) {
                    File[] fileArray2 = AdtUtils.listFiles(vendor);
                    int n3 = fileArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File folder;
                        File pkg = fileArray2[n4];
                        if (pkg.isDirectory() && (folder = new File(pkg, "templates")).isDirectory()) {
                            folders.add(folder);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            File folder = new File(extras, "templates");
            if (folder.isDirectory()) {
                folders.add(folder);
            }
        }
        return folders;
    }

    public static File getTemplateLocation(File root, String relativePath) {
        String rootPath;
        File templateFile;
        File templateRoot = TemplateManager.getTemplateRootFolder();
        if (templateRoot != null && (templateFile = new File(templateRoot, String.valueOf((rootPath = root.getPath()).replace('/', File.separatorChar)) + File.separator + relativePath.replace('/', File.separatorChar))).exists()) {
            return templateFile;
        }
        return null;
    }

    public static File getTemplateLocation(String relativePath) {
        File templateFile;
        File templateRoot = TemplateManager.getTemplateRootFolder();
        if (templateRoot != null && (templateFile = new File(templateRoot, relativePath.replace('/', File.separatorChar))).exists()) {
            return templateFile;
        }
        return null;
    }

    List<File> getTemplates(String folder) {
        File[] files;
        ArrayList<File> templates = new ArrayList<File>();
        HashMap templateNames = Maps.newHashMap();
        File root = TemplateManager.getTemplateRootFolder();
        if (root != null && (files = new File(root, folder).listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    templates.add(file);
                    templateNames.put(file.getName(), file);
                }
                ++n2;
            }
        }
        for (File extra : TemplateManager.getExtraTemplateRootFolders()) {
            File[] files2 = new File(extra, folder).listFiles();
            if (files2 == null) continue;
            File[] fileArray = files2;
            int n = files2.length;
            int n3 = 0;
            while (n3 < n) {
                File file = fileArray[n3];
                if (file.isDirectory()) {
                    File replaces = (File)templateNames.get(file.getName());
                    if (replaces != null) {
                        int compare = this.compareTemplates(replaces, file);
                        if (compare > 0) {
                            int index = templates.indexOf(replaces);
                            if (index != -1) {
                                templates.set(index, file);
                            } else {
                                templates.add(file);
                            }
                        }
                    } else {
                        templates.add(file);
                    }
                }
                ++n3;
            }
        }
        if (templates.size() > 1) {
            Collections.sort(templates, new Comparator<File>(){

                @Override
                public int compare(File file1, File file2) {
                    return file1.getName().compareTo(file2.getName());
                }
            });
        }
        return templates;
    }

    private int compareTemplates(File file1, File file2) {
        TemplateMetadata template1 = this.getTemplate(file1);
        TemplateMetadata template2 = this.getTemplate(file2);
        if (template1 == null) {
            return 1;
        }
        if (template2 == null) {
            return -1;
        }
        int delta = template2.getRevision() - template1.getRevision();
        if (delta == 0) {
            delta = (int)(file2.lastModified() - file1.lastModified());
        }
        return delta;
    }

    TemplateMetadata getTemplate(File templateDir) {
        block6: {
            TemplateMetadata metadata;
            block7: {
                String xml;
                Document doc;
                if (this.mTemplateMap != null) {
                    TemplateMetadata metadata2 = this.mTemplateMap.get(templateDir);
                    if (metadata2 != null) {
                        return metadata2;
                    }
                } else {
                    this.mTemplateMap = Maps.newHashMap();
                }
                File templateFile = new File(templateDir, "template.xml");
                if (!templateFile.isFile() || (doc = DomUtilities.parseDocument(xml = Files.toString((File)templateFile, (Charset)Charsets.UTF_8), true)) == null || doc.getDocumentElement() == null) break block6;
                metadata = new TemplateMetadata(doc);
                if (!EXCLUDED_CATEGORIES.contains(metadata.getCategory()) && !EXCLUDED_FORMFACTORS.contains(metadata.getFormFactor())) break block7;
                return null;
            }
            try {
                this.mTemplateMap.put(templateDir, metadata);
                return metadata;
            }
            catch (IOException e) {
                AndmoreAndroidPlugin.log(e, null, new Object[0]);
            }
        }
        return null;
    }
}

