/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui;

import org.eclipse.birt.chart.reportitem.ui.ChartReportItemUIActivator;
import org.eclipse.birt.chart.reportitem.ui.i18n.Messages;
import org.eclipse.birt.report.designer.ui.preferences.IStatusChangeListener;
import org.eclipse.birt.report.designer.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.birt.report.designer.ui.preferences.StatusInfo;
import org.eclipse.birt.report.designer.ui.util.PixelConverter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ChartConfigurationBlock
extends OptionsConfigurationBlock {
    protected final OptionsConfigurationBlock.Key PREF_ENALBE_LIVE = this.getKey("org.eclipse.birt.chart.reportitem.ui", "enable_live");
    protected final OptionsConfigurationBlock.Key PREF_MAX_ROW = this.getKey("org.eclipse.birt.chart.reportitem.ui", "max_row");
    private static final String ENABLE_BUTTON = Messages.getString("ChartPreferencePage.Label.EnableLivePreview");
    protected static final String ENABLED = "true";
    protected static final String DISABLED = "false";
    private static final int MAX_ROW_LIMIT = 10000;
    private PixelConverter fPixelConverter;

    public ChartConfigurationBlock(IStatusChangeListener context, IProject project) {
        super(context, (AbstractUIPlugin)ChartReportItemUIActivator.getDefault(), project);
        this.setKeys(this.getKeys());
    }

    protected OptionsConfigurationBlock.Key[] getKeys() {
        OptionsConfigurationBlock.Key[] keys = new OptionsConfigurationBlock.Key[]{this.PREF_ENALBE_LIVE, this.PREF_MAX_ROW};
        return keys;
    }

    protected Control createContents(Composite parent) {
        this.fPixelConverter = new PixelConverter((Control)parent);
        this.setShell(parent.getShell());
        Composite mainComp = new Composite(parent, 0);
        mainComp.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        mainComp.setLayout((Layout)layout);
        Composite othersComposite = this.createBuildPathTabContent(mainComp);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.fPixelConverter.convertHeightInCharsToPixels(20);
        othersComposite.setLayoutData((Object)gridData);
        this.validateSettings(null, null, null);
        return mainComp;
    }

    protected Composite createBuildPathTabContent(Composite parent) {
        Composite pageContent = new Composite(parent, 0);
        GridData data = new GridData(1810);
        data.grabExcessHorizontalSpace = true;
        pageContent.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        pageContent.setLayout((Layout)layout);
        String[] enableDisableValues = new String[]{ENABLED, DISABLED};
        this.addCheckBox(pageContent, ENABLE_BUTTON, this.PREF_ENALBE_LIVE, enableDisableValues, 0);
        this.addTextField(pageContent, Messages.getString("ChartPreferencePage.Label.MaxRowNumber"), this.PREF_MAX_ROW, 0, 0);
        return pageContent;
    }

    protected void validateSettings(OptionsConfigurationBlock.Key changedKey, String oldValue, String newValue) {
        this.fContext.statusChanged(this.validatePositiveNumber(this.getValue(this.PREF_MAX_ROW)));
    }

    protected IStatus validatePositiveNumber(String number) {
        StatusInfo status = new StatusInfo();
        String errorMessage = Messages.getString("ChartPreferencePage.Error.MaxRowInvalid", new Object[]{10000});
        if (number.length() == 0) {
            status.setError(errorMessage);
        } else {
            try {
                int value = Integer.parseInt(number);
                if (value < 1 || value > 10000) {
                    status.setError(errorMessage);
                }
            }
            catch (NumberFormatException numberFormatException) {
                status.setError(errorMessage);
            }
        }
        return status;
    }
}

