/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.excel.ui.wizards;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import org.eclipse.birt.report.data.oda.excel.impl.util.ResourceLocatorUtil;
import org.eclipse.birt.report.data.oda.excel.ui.i18n.Messages;
import org.eclipse.birt.report.data.oda.excel.ui.util.Utility;
import org.eclipse.birt.report.data.oda.excel.ui.wizards.ExcelDataSourcePropertyPage;
import org.eclipse.birt.report.data.oda.excel.ui.wizards.ExcelDataSourceWizardPage;
import org.eclipse.birt.report.data.oda.excel.ui.wizards.MenuButton;
import org.eclipse.birt.report.data.oda.excel.ui.wizards.RelativeFileSelectionDialog;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.ResourceIdentifiers;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.nls.TextProcessorWrapper;
import org.eclipse.datatools.connectivity.ui.PingJob;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExcelDataSourcePageHelper {
    static final String DEFAULT_MESSAGE = Messages.getString("wizard.defaultMessage.selectExcelFile");
    private WizardPage wizardPage;
    private PreferencePage propertyPage;
    private String errorMsg = Messages.getString("connection_CANNOT_OPEN_EXCEL_FILE_DB_DIR");
    private transient Text folderLocation = null;
    private transient Button typeLineCheckBox = null;
    private transient MenuButton browseFolderButton = null;
    private transient Button columnNameLineCheckBox = null;
    private transient Composite parent = null;
    private static final int CORRECT_FOLDER = 0;
    private static final int ERROR_FOLDER = 1;
    private static final int ERROR_EMPTY_PATH = 2;
    private static final String EMPTY_STRING = "";
    private static final String CURRENT_DIRECTORY = ".";
    private static final Integer SELECT_RELATIVE_PATH = 1;
    private static final Integer SELECT_ABSOLUTE_PATH = 2;
    private static final String ALL_XLS_EXTENSION = "*.xls;*.xlsx";
    private static final String ALL_EXTENSION = "*.*";
    private org.eclipse.datatools.connectivity.oda.util.ResourceIdentifiers ri;
    private static final String[] fileExtensions = new String[]{"*.xls;*.xlsx", "*.*"};

    public ExcelDataSourcePageHelper(ExcelDataSourceWizardPage page) {
        this.wizardPage = page;
    }

    public ExcelDataSourcePageHelper(ExcelDataSourcePropertyPage excelDataSourcePropertyPage) {
        this.propertyPage = excelDataSourcePropertyPage;
    }

    void createCustomControl(Composite parent) {
        this.parent = parent;
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        content.setLayout((Layout)layout);
        this.setupFolderLocation(content);
        this.setupColumnNameLineCheckBox(content);
        this.setupTypeLineCheckBox(content);
        Utility.setSystemHelp(this.getControl(), "org.eclipse.datatools.oda.cshelp.Wizard_ExcelDatasource_ID");
    }

    private void setupFolderLocation(Composite composite) {
        MenuItem item;
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("label.selectFile"));
        GridData data = new GridData(768);
        this.folderLocation = new Text(composite, 2048);
        this.folderLocation.setLayoutData((Object)data);
        this.setPageComplete(false);
        this.folderLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExcelDataSourcePageHelper.this.verifyFileLocation();
            }
        });
        this.browseFolderButton = new MenuButton(composite, 0);
        this.browseFolderButton.setText(Messages.getString("button.selectFolder.browse"));
        Menu menu = new Menu((Decorations)composite.getShell(), 8);
        SelectionAdapter action = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget instanceof MenuItem) {
                    MenuItem item = (MenuItem)e.widget;
                    Integer type = (Integer)item.getData();
                    ExcelDataSourcePageHelper.this.handleFileSelection(type);
                } else if (e.widget instanceof MenuButton) {
                    if (ExcelDataSourcePageHelper.this.ri == null) {
                        ExcelDataSourcePageHelper.this.handleFileSelection(SELECT_ABSOLUTE_PATH);
                    } else {
                        ExcelDataSourcePageHelper.this.handleFileSelection(SELECT_RELATIVE_PATH);
                    }
                }
            }
        };
        if (this.ri != null) {
            item = new MenuItem(menu, 8);
            item.setText(Messages.getString("button.selectFileURI.menuItem.relativePath"));
            item.setData((Object)SELECT_RELATIVE_PATH);
            item.addSelectionListener((SelectionListener)action);
        }
        item = new MenuItem(menu, 8);
        item.setText(Messages.getString("button.selectFileURI.menuItem.absolutePath"));
        item.setData((Object)SELECT_ABSOLUTE_PATH);
        item.addSelectionListener((SelectionListener)action);
        this.browseFolderButton.setDropDownMenu(menu);
        this.browseFolderButton.addSelectionListener((SelectionListener)action);
    }

    public void setResourceIdentifiers(ResourceIdentifiers resourceIdentifiers) {
        if (resourceIdentifiers != null) {
            this.ri = DesignSessionUtil.createRuntimeResourceIdentifiers((ResourceIdentifiers)resourceIdentifiers);
        }
    }

    private String getResourceFolder() {
        if (this.ri != null && this.ri.getApplResourceBaseURI() != null) {
            return new File(this.ri.getApplResourceBaseURI()).getAbsolutePath();
        }
        return null;
    }

    private void handleFileSelection(int selectionType) {
        block9: {
            if (selectionType == SELECT_RELATIVE_PATH) {
                RelativeFileSelectionDialog dialog = new RelativeFileSelectionDialog(this.folderLocation.getShell(), new File(this.getResourceFolder()), fileExtensions);
                dialog.setTitle(Messages.getString("SelectFile.Title"));
                if (dialog.open() == 0) {
                    try {
                        URI uri = dialog.getSelectedURI();
                        if (uri == null) break block9;
                        if (uri.getPath().trim().isEmpty()) {
                            this.setFolderLocationString(CURRENT_DIRECTORY);
                            break block9;
                        }
                        this.setFolderLocationString(uri.getPath());
                    }
                    catch (URISyntaxException uRISyntaxException) {}
                }
            } else if (selectionType == SELECT_ABSOLUTE_PATH) {
                String selectedLocation;
                FileDialog dialog = new FileDialog(this.folderLocation.getShell());
                dialog.setFilterExtensions(fileExtensions);
                String folderLocationValue = this.getFolderLocationString();
                File file = new File(folderLocationValue);
                String folderValue = file.getParent();
                if (folderValue != null && folderValue.trim().length() > 0) {
                    dialog.setFilterPath(folderValue);
                }
                if ((selectedLocation = dialog.open()) != null) {
                    this.setFolderLocationString(selectedLocation);
                }
            }
        }
    }

    private void setupColumnNameLineCheckBox(Composite composite) {
        Label labelFill = new Label(composite, 0);
        labelFill.setText(EMPTY_STRING);
        this.columnNameLineCheckBox = new Button(composite, 32);
        this.columnNameLineCheckBox.setToolTipText(Messages.getString("tooltip.columnnameline"));
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        this.columnNameLineCheckBox.setLayoutData((Object)gd);
        this.columnNameLineCheckBox.setText(Messages.getString("label.includeColumnNameLine"));
        this.columnNameLineCheckBox.setSelection(true);
        this.columnNameLineCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExcelDataSourcePageHelper.this.columnNameLineCheckBox.getSelection()) {
                    ExcelDataSourcePageHelper.this.typeLineCheckBox.setEnabled(true);
                } else {
                    ExcelDataSourcePageHelper.this.typeLineCheckBox.setSelection(false);
                    ExcelDataSourcePageHelper.this.typeLineCheckBox.setEnabled(false);
                }
            }
        });
    }

    private void setupTypeLineCheckBox(Composite composite) {
        this.typeLineCheckBox = new Button(composite, 32);
        this.typeLineCheckBox.setToolTipText(Messages.getString("tooltip.typeline"));
        GridData data = new GridData();
        data.horizontalSpan = 3;
        this.typeLineCheckBox.setLayoutData((Object)data);
        this.typeLineCheckBox.setText(Messages.getString("label.includeTypeLine"));
        if (this.columnNameLineCheckBox.getSelection()) {
            this.typeLineCheckBox.setEnabled(true);
        } else {
            this.typeLineCheckBox.setSelection(false);
            this.typeLineCheckBox.setEnabled(false);
        }
    }

    Properties collectCustomProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        props.setProperty("URI", this.getFolderLocation().trim());
        props.setProperty("INCLCOLUMNNAME", this.getWhetherUseFirstLineAsColumnNameLine());
        props.setProperty("INCLTYPELINE", this.getWhetherUseSecondLineAsTypeLine());
        return props;
    }

    String getFolderLocation() {
        if (this.folderLocation == null) {
            return EMPTY_STRING;
        }
        return this.getFolderLocationString();
    }

    String getWhetherUseFirstLineAsColumnNameLine() {
        if (this.columnNameLineCheckBox == null || !this.columnNameLineCheckBox.getEnabled()) {
            return EMPTY_STRING;
        }
        return this.columnNameLineCheckBox.getSelection() ? "YES" : "NO";
    }

    String getWhetherUseSecondLineAsTypeLine() {
        if (this.typeLineCheckBox == null) {
            return EMPTY_STRING;
        }
        return this.typeLineCheckBox.getSelection() ? "YES" : "NO";
    }

    void initCustomControl(Properties profileProps) {
        if (profileProps == null || profileProps.isEmpty() || this.folderLocation == null) {
            return;
        }
        String folderPath = profileProps.getProperty("URI");
        if (folderPath == null) {
            folderPath = EMPTY_STRING;
        }
        this.setFolderLocationString(folderPath);
        String hasColumnNameLine = profileProps.getProperty("INCLCOLUMNNAME");
        if (hasColumnNameLine == null) {
            hasColumnNameLine = "YES";
        }
        if (hasColumnNameLine.equalsIgnoreCase("YES")) {
            this.columnNameLineCheckBox.setSelection(true);
            String useSecondLine = profileProps.getProperty("INCLTYPELINE");
            if (useSecondLine == null) {
                useSecondLine = EMPTY_STRING;
            }
            this.typeLineCheckBox.setEnabled(true);
            this.typeLineCheckBox.setSelection(useSecondLine.equalsIgnoreCase("YES"));
        } else {
            this.columnNameLineCheckBox.setSelection(false);
            this.typeLineCheckBox.setSelection(false);
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!ExcelDataSourcePageHelper.this.typeLineCheckBox.isDisposed()) {
                        ExcelDataSourcePageHelper.this.typeLineCheckBox.setEnabled(false);
                    }
                }
            });
        }
        this.verifyFileLocation();
    }

    private void setPageComplete(boolean complete) {
        if (this.wizardPage != null) {
            this.wizardPage.setPageComplete(complete);
        } else if (this.propertyPage != null) {
            this.propertyPage.setValid(complete);
        }
    }

    public Runnable createTestConnectionRunnable(final IConnectionProfile profile) {
        return new Runnable(){

            @Override
            public void run() {
                IConnection conn = PingJob.createTestConnection((IConnectionProfile)profile);
                Throwable exception = PingJob.getTestConnectionException((IConnection)conn);
                if (exception == null) {
                    exception = this.testConnection();
                }
                PingJob.PingUIJob.showTestConnectionMessage((Shell)ExcelDataSourcePageHelper.this.parent.getShell(), (Throwable)exception);
                if (conn != null) {
                    conn.close();
                }
            }

            private Throwable testConnection() {
                Exception exception = null;
                try {
                    int verify = ExcelDataSourcePageHelper.this.verifyFileLocation();
                    if (verify == 1) {
                        throw new OdaException(ExcelDataSourcePageHelper.this.errorMsg);
                    }
                }
                catch (Exception ex) {
                    exception = ex;
                }
                return exception;
            }
        };
    }

    private int verifyFileLocation() {
        int result = 0;
        String folderLocationValue = this.getFolderLocationString().trim();
        if (folderLocationValue.length() > 0) {
            URI uri = null;
            try {
                uri = ResourceLocatorUtil.resolvePath((Object)this.ri, (String)folderLocationValue);
            }
            catch (OdaException e) {
                this.setMessage(e.getMessage(), 3);
                this.setPageComplete(false);
                return 1;
            }
            if (uri == null) {
                this.setMessage(Messages.getString("ui.ExcelFileNotFound"), 3);
                this.setPageComplete(false);
                return 1;
            }
            try {
                ResourceLocatorUtil.validateFileURI((Object)uri);
                this.setMessage(DEFAULT_MESSAGE, 0);
                this.setPageComplete(true);
            }
            catch (Exception exception) {
                this.setMessage(Messages.getString("ui.ExcelFileNotFound"), 3);
                this.setPageComplete(false);
                return 1;
            }
        }
        this.setMessage(Messages.getString("error.emptyPath"), 3);
        this.setPageComplete(false);
        result = 2;
        if (result == 0) {
            return result;
        }
        if (this.wizardPage == null) {
            this.setPageComplete(true);
        }
        return result;
    }

    private String getFolderLocationString() {
        return TextProcessorWrapper.deprocess((String)this.folderLocation.getText());
    }

    private void setFolderLocationString(String folderPath) {
        this.folderLocation.setText(TextProcessorWrapper.process((String)folderPath));
    }

    private void setMessage(String newMessage, int newType) {
        if (this.wizardPage != null) {
            this.wizardPage.setMessage(newMessage, newType);
        } else if (this.propertyPage != null) {
            this.propertyPage.setMessage(newMessage, newType);
        }
        this.errorMsg = newMessage;
    }

    private Control getControl() {
        if (this.wizardPage != null) {
            return this.wizardPage.getControl();
        }
        if (this.propertyPage != null) {
            return this.propertyPage.getControl();
        }
        return null;
    }
}

