/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.page;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.event.IFastConsumerProcessor;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.event.IModelEventProcessor;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.util.SortMap;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.Section;
import org.eclipse.birt.report.designer.ui.views.attributes.TabPage;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public abstract class AttributePage
extends TabPage
implements IFastConsumerProcessor {
    public static final int QUICK_BUTTON_HEIGHT = Platform.getOS().equals("win32") ? 20 : 22;
    protected HashMap propertiesMap = new HashMap(7);
    protected Object input;
    protected SortMap sections = new SortMap();
    protected Composite container;
    private boolean load = false;
    protected List<IPropertyChangeListener> listeners = new ArrayList<IPropertyChangeListener>();

    @Override
    public void refresh() {
        Object element = DEUtil.getInputFirstElement((Object)this.input);
        if (element == null) {
            return;
        }
        if (element instanceof DesignElementHandle && this.getTopContainer((DesignElementHandle)element) == null) {
            return;
        }
        Section[] sectionArray = this.getSections();
        int i = 0;
        while (i < sectionArray.length) {
            Section section = sectionArray[i];
            section.setInput(this.input);
            section.load();
            ++i;
        }
        FormWidgetFactory.getInstance().paintFormStyle(this.container);
        FormWidgetFactory.getInstance().adapt(this.container);
    }

    public void setInput(Object handle) {
        this.deRegisterEventManager();
        this.input = handle;
        this.registerEventManager();
    }

    protected void deRegisterEventManager() {
        if (UIUtil.getModelEventManager() != null) {
            UIUtil.getModelEventManager().removeModelEventProcessor((IModelEventProcessor)this);
        }
    }

    protected void registerEventManager() {
        if (UIUtil.getModelEventManager() != null) {
            UIUtil.getModelEventManager().addModelEventProcessor((IModelEventProcessor)this);
        }
    }

    public boolean isOverdued() {
        return this.container == null || this.container.isDisposed();
    }

    public void dispose() {
        if (this.container != null && !this.container.isDisposed()) {
            this.container.dispose();
        }
        this.listeners.clear();
        this.deRegisterEventManager();
    }

    public void addSection(String sectionKey, Section section) {
        if (this.sections == null) {
            this.sections = new SortMap();
        }
        this.sections.put((Object)sectionKey, (Object)section);
    }

    public void addSectionAfter(String sectionKey, Section section, String key) {
        int index;
        if (this.sections == null) {
            this.sections = new SortMap();
        }
        if ((index = this.sections.getIndexOf((Object)key)) != -1) {
            this.sections.putAt((Object)sectionKey, (Object)section, index + 1);
        } else {
            this.sections.put((Object)sectionKey, (Object)section);
        }
    }

    public void addSectionBefore(String sectionKey, Section section, String key) {
        int index;
        if (this.sections == null) {
            this.sections = new SortMap();
        }
        if ((index = this.sections.getIndexOf((Object)key)) != -1) {
            this.sections.putAt((Object)sectionKey, (Object)section, index);
        } else {
            this.sections.put((Object)sectionKey, (Object)section);
        }
    }

    public void removeSection(String sectionKey) {
        if (this.sections == null) {
            this.sections = new SortMap();
        }
        this.sections.remove((Object)sectionKey);
    }

    public void createSections() {
        this.applyCustomSections();
        Section[] sectionArray = this.getSections();
        int i = 0;
        while (i < sectionArray.length) {
            Section section = sectionArray[i];
            section.createSection();
            ++i;
        }
    }

    protected void applyCustomSections() {
    }

    public void layoutSections() {
        Section[] sectionArray = this.getSections();
        int i = 0;
        while (i < sectionArray.length) {
            Section section = sectionArray[i];
            section.layout();
            ++i;
        }
        this.container.layout(true);
        this.container.redraw();
    }

    public Section[] getSections() {
        if (this.sections == null) {
            return new Section[0];
        }
        Section[] sectionArray = new Section[this.sections.size()];
        int i = 0;
        while (i < this.sections.size()) {
            sectionArray[i] = (Section)this.sections.get(i);
            ++i;
        }
        return sectionArray;
    }

    public Section getSection(String key) {
        if (this.sections == null) {
            return null;
        }
        return (Section)this.sections.get((Object)key);
    }

    @Override
    public String getTabDisplayName() {
        return null;
    }

    public void buildUI(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AttributePage.this.deRegisterEventManager();
            }
        });
        if (this.sections == null) {
            this.sections = new SortMap();
        }
    }

    public Control getControl() {
        return this.container;
    }

    public void addElementEvent(DesignElementHandle focus, NotificationEvent ev) {
    }

    public void clear() {
    }

    public void postElementEvent() {
        Object element = DEUtil.getInputFirstElement((Object)this.input);
        if (element == null) {
            return;
        }
        if (element instanceof DesignElementHandle && this.getTopContainer((DesignElementHandle)element) == null) {
            return;
        }
        Section[] sectionArray = this.getSections();
        int i = 0;
        while (i < sectionArray.length) {
            if (!this.load) {
                this.load = true;
                Display.getDefault().timerExec(100, new Runnable(){

                    @Override
                    public void run() {
                        Section[] sectionArray = AttributePage.this.getSections();
                        int i = 0;
                        while (i < sectionArray.length) {
                            Section section = sectionArray[i];
                            section.load();
                            ++i;
                        }
                        AttributePage.this.load = false;
                    }
                });
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected ModuleHandle getTopContainer(DesignElementHandle element) {
        if (!(element instanceof ModuleHandle)) ** GOTO lbl5
        return (ModuleHandle)element;
lbl-1000:
        // 1 sources

        {
            if ((element = element.getContainer()) != null) continue;
            return null;
lbl5:
            // 2 sources

            ** while (!(element.getContainer() instanceof ModuleHandle))
        }
lbl6:
        // 1 sources

        return (ModuleHandle)element.getContainer();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }
}

