/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.hyphen;

import org.eclipse.birt.report.engine.layout.pdf.hyphen.IWordRecognizer;
import org.eclipse.birt.report.engine.layout.pdf.hyphen.Word;

public class DefaultWordRecognizer
implements IWordRecognizer {
    static final char SPACE = ' ';
    protected int start;
    protected String text;
    protected char splitChar;
    protected Word lastWord = null;
    protected Word currentWord = null;

    public DefaultWordRecognizer(String text) {
        this.text = text;
    }

    public int getLastWordEnd() {
        return this.lastWord == null ? 0 : this.lastWord.getEnd();
    }

    @Override
    public boolean hasWord() {
        return this.getLastWordEnd() != this.text.length();
    }

    @Override
    public Word getNextWord() {
        this.lastWord = this.currentWord;
        if (this.start > this.text.length() - 1) {
            return null;
        }
        int i = this.start;
        while (i < this.text.length()) {
            char c = this.text.charAt(i);
            if (c == ' ') {
                this.currentWord = new Word(this.text, this.start, i + 1);
                this.start = i + 1;
                return this.currentWord;
            }
            int lineBreakLength = this.getLineBreakLength(this.text, i);
            if (lineBreakLength != 0) {
                if (i == this.start) {
                    this.currentWord = new Word(this.text, this.start, i + lineBreakLength);
                    this.start = i + lineBreakLength;
                    return this.currentWord;
                }
                this.currentWord = new Word(this.text, this.start, i);
                this.start = i;
                return this.currentWord;
            }
            ++i;
        }
        this.currentWord = new Word(this.text, this.start, this.text.length());
        this.start = this.text.length();
        return this.currentWord;
    }

    private int getLineBreakLength(String text, int index) {
        char c = text.charAt(index);
        if (c == '\n') {
            return 1;
        }
        if (c == '\r') {
            if (index + 1 < text.length() && text.charAt(index + 1) == '\n') {
                return 2;
            }
            return 1;
        }
        return 0;
    }
}

