/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.css;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.api.css.StyleSheetParserException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.css.CssErrorHandler;
import org.eclipse.birt.report.model.css.CssStyle;

public final class CssStyleSheet
implements Cloneable {
    protected LinkedHashMap<String, CssStyle> styles = new LinkedHashMap();
    private ArrayList<StyleSheetParserException> warnings = new ArrayList();
    private HashMap<String, StyleSheetParserException> unsupportedStyles = new HashMap();
    private HashMap<String, List<StyleSheetParserException>> warningsForStyles = new HashMap();
    private CssErrorHandler errorHandler = null;
    private String fileName = null;
    private String externalCssURI = null;
    private boolean useExternalCss = false;
    private DesignElement container = null;

    public String getExternalCssURI() {
        return this.externalCssURI;
    }

    public void setExternalCssURI(String externalCssURI) {
        this.externalCssURI = externalCssURI;
    }

    public boolean isUseExternalCss() {
        return this.useExternalCss;
    }

    public void setUseExternalCss(boolean useExternalCss) {
        this.useExternalCss = useExternalCss;
    }

    public CssStyleSheetHandle handle(Module module) {
        return new CssStyleSheetHandle((ModuleHandle)module.getHandle(module), this);
    }

    public StyleElement findStyle(String name) {
        return this.styles.get(name);
    }

    public void addStyle(DesignElement style) {
        assert (this.styles.get(style.getName()) == null);
        assert (style instanceof CssStyle);
        this.styles.put(style.getName(), (CssStyle)style);
    }

    public void removeStyle(String name) {
        assert (this.styles.get(name) != null);
        this.styles.remove(name);
    }

    public List<CssStyle> getStyles() {
        return new ArrayList<CssStyle>(this.styles.values());
    }

    public void addWarning(List<StyleSheetParserException> warnings) {
        this.warnings.addAll(warnings);
    }

    public List<StyleSheetParserException> getWarnings() {
        return this.warnings;
    }

    public void addUnsupportedStyle(String styleName, StyleSheetParserException e) {
        this.unsupportedStyles.put(styleName, e);
    }

    public List<String> getUnsupportedStyle() {
        ArrayList<String> styles = new ArrayList<String>();
        styles.addAll(this.unsupportedStyles.keySet());
        return styles;
    }

    public void addWarnings(String styleName, List<StyleSheetParserException> errors) {
        this.warningsForStyles.put(styleName, errors);
    }

    public List<StyleSheetParserException> getWarnings(String styleName) {
        return this.warningsForStyles.get(styleName);
    }

    public CssErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(CssErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public DesignElement getContainer() {
        return this.container;
    }

    public void setContainer(DesignElement container) {
        this.container = container;
        List<CssStyle> tmpStyles = this.getStyles();
        int i = 0;
        while (i < tmpStyles.size()) {
            CssStyle tmpStyle = tmpStyles.get(i);
            tmpStyle.setContainer(container);
            ++i;
        }
    }

    public CssStyleSheet clone() throws CloneNotSupportedException {
        CssStyleSheet cssStyleSheet = (CssStyleSheet)super.clone();
        LinkedHashMap<String, CssStyle> newStyles = new LinkedHashMap<String, CssStyle>();
        if (this.styles.size() > 0) {
            Set<String> keySet = this.styles.keySet();
            for (String key : keySet) {
                CssStyle cloneCssStyle = (CssStyle)this.styles.get(key).clone();
                newStyles.put(key, cloneCssStyle);
            }
        }
        cssStyleSheet.styles = newStyles;
        return cssStyleSheet;
    }
}

