/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.validators.ImageDataValidator;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ImageItem;
import org.eclipse.birt.report.model.metadata.StructRefValue;
import org.eclipse.birt.report.model.parser.DesignParserException;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.ReportItemState;
import org.eclipse.birt.report.model.util.SecurityUtil;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ImageState
extends ReportItemState {
    protected ImageItem image;

    public ImageState(ModuleParserHandler handler, DesignElement theContainer, int slot) {
        super(handler, theContainer, slot);
    }

    public ImageState(ModuleParserHandler handler, DesignElement theContainer, String prop) {
        super(handler, theContainer, prop);
    }

    @Override
    public DesignElement getElement() {
        return this.image;
    }

    @Override
    public void parseAttrs(Attributes attrs) throws XMLParserException {
        this.image = new ImageItem();
        this.initElement(attrs);
    }

    private void checkImageType() {
        StructRefValue imageName;
        int type = 0;
        Module module = this.handler.getModule();
        String uri = ImageState.getLocalStringExpression(this.image, "uri", module);
        if (!StringUtil.isEmpty(uri)) {
            uri = StringUtil.trimQuotes(uri);
            try {
                new URL(uri);
                this.setProperty("source", "url");
            }
            catch (MalformedURLException malformedURLException) {
                if (ImageState.isFileProtocol(uri)) {
                    this.setProperty("source", "file");
                }
                this.setProperty("source", "expr");
            }
            ++type;
        }
        if ((imageName = (StructRefValue)this.image.getLocalProperty(module, "imageName")) != null) {
            this.setProperty("source", "embed");
            ++type;
        }
        String typeExpr = ImageState.getLocalStringExpression(this.image, "typeExpr", module);
        String valueExpr = ImageState.getLocalStringExpression(this.image, "valueExpr", module);
        if (!StringUtil.isEmpty(typeExpr) || !StringUtil.isEmpty(valueExpr)) {
            this.setProperty("source", "expr");
            ++type;
        }
        if (type > 1) {
            this.handler.getErrorHandler().semanticError((Exception)((Object)new DesignParserException("Error.DesignParserException.IMAGE_REF_CONFLICT")));
        }
    }

    @Override
    public void end() throws SAXException {
        Module module = this.handler.getModule();
        if (this.image.getLocalProperty(module, "source") == null && this.handler.versionNumber <= 3020300) {
            this.checkImageType();
        }
        List<SemanticException> tmpList = ImageDataValidator.getInstance().validate(this.handler.module, this.image);
        int i = 0;
        while (i < tmpList.size()) {
            this.handler.getErrorHandler().semanticWarning((Exception)((Object)tmpList.get(i)));
            ++i;
        }
        super.end();
    }

    private static boolean isFileProtocol(String filePath) {
        try {
            URL fileUrl = new URL(filePath);
            return "file".equalsIgnoreCase(fileUrl.getProtocol());
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(filePath);
            String scheme = SecurityUtil.getFiletoURISchemaPart(file);
            if (scheme == null) {
                return false;
            }
            return scheme.equalsIgnoreCase("file");
        }
    }

    private static String getLocalStringExpression(DesignElement element, String propName, Module root) {
        Object value = element.getLocalProperty(root, propName);
        if (!(value instanceof Expression)) {
            return null;
        }
        return ((Expression)value).getStringExpression();
    }
}

