/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.validation.validators;

import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.CompensateEventDefinition;
import org.eclipse.bpmn2.ConditionalEventDefinition;
import org.eclipse.bpmn2.DataAssociation;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.Error;
import org.eclipse.bpmn2.ErrorEventDefinition;
import org.eclipse.bpmn2.Escalation;
import org.eclipse.bpmn2.EscalationEventDefinition;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.Expression;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.Message;
import org.eclipse.bpmn2.MessageEventDefinition;
import org.eclipse.bpmn2.Signal;
import org.eclipse.bpmn2.SignalEventDefinition;
import org.eclipse.bpmn2.TimerEventDefinition;
import org.eclipse.bpmn2.modeler.core.utils.EventDefinitionsUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.utils.Tuple;
import org.eclipse.bpmn2.modeler.core.validation.validators.AbstractBpmn2ElementValidator;
import org.eclipse.bpmn2.modeler.core.validation.validators.ActivityValidator;
import org.eclipse.bpmn2.modeler.core.validation.validators.ErrorValidator;
import org.eclipse.bpmn2.modeler.core.validation.validators.EscalationValidator;
import org.eclipse.bpmn2.modeler.core.validation.validators.ExpressionValidator;
import org.eclipse.bpmn2.modeler.core.validation.validators.MessageValidator;
import org.eclipse.bpmn2.modeler.core.validation.validators.Messages;
import org.eclipse.bpmn2.modeler.core.validation.validators.ProcessValidator;
import org.eclipse.bpmn2.modeler.core.validation.validators.SignalValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;

public class EventDefinitionValidator
extends AbstractBpmn2ElementValidator<EventDefinition> {
    public EventDefinitionValidator(IValidationContext ctx) {
        super(ctx);
    }

    public EventDefinitionValidator(AbstractBpmn2ElementValidator parent) {
        super(parent);
    }

    @Override
    public IStatus validate(EventDefinition ed) {
        BaseElement edContainer = (BaseElement)ed.eContainer();
        if (ProcessValidator.isContainingProcessExecutable((EObject)edContainer)) {
            if (ed instanceof TimerEventDefinition) {
                TimerEventDefinition ted = (TimerEventDefinition)ed;
                if (ted.getTimeDate() == null && ted.getTimeDuration() == null && ted.getTimeCycle() == null) {
                    this.addMissingFeatureStatus((EObject)edContainer, Messages.EventDefinitionValidator_Timer, 4);
                }
            } else if (ed instanceof SignalEventDefinition) {
                Signal signal = ((SignalEventDefinition)ed).getSignalRef();
                if (signal == null) {
                    this.addMissingFeatureStatus((EObject)edContainer, Messages.EventDefinitionValidator_Signal, 4);
                } else {
                    new SignalValidator((AbstractBpmn2ElementValidator)this).validate(signal);
                }
            } else if (ed instanceof ErrorEventDefinition) {
                Error error = ((ErrorEventDefinition)ed).getErrorRef();
                if (error == null) {
                    this.addMissingFeatureStatus((EObject)edContainer, Messages.EventDefinitionValidator_Error, 4);
                } else {
                    new ErrorValidator((AbstractBpmn2ElementValidator)this).validate(error);
                }
            } else if (ed instanceof ConditionalEventDefinition) {
                FormalExpression expression = (FormalExpression)((ConditionalEventDefinition)ed).getCondition();
                if (expression == null || EventDefinitionValidator.isEmpty(expression.getBody())) {
                    this.addMissingFeatureStatus((EObject)edContainer, Messages.EventDefinitionValidator_Condition, 4);
                } else {
                    new ExpressionValidator((AbstractBpmn2ElementValidator)this).validate((Expression)expression);
                }
            } else if (ed instanceof EscalationEventDefinition) {
                Escalation escalation = ((EscalationEventDefinition)ed).getEscalationRef();
                if (escalation == null) {
                    this.addMissingFeatureStatus((EObject)edContainer, Messages.EventDefinitionValidator_Escalation, 4);
                } else {
                    new EscalationValidator((AbstractBpmn2ElementValidator)this).validate(escalation);
                }
            } else if (ed instanceof MessageEventDefinition) {
                Message message = ((MessageEventDefinition)ed).getMessageRef();
                if (message == null) {
                    this.addMissingFeatureStatus((EObject)edContainer, Messages.EventDefinitionValidator_Message, 4);
                } else {
                    new MessageValidator((AbstractBpmn2ElementValidator)this).validate(message);
                }
            } else if (ed instanceof CompensateEventDefinition) {
                Activity activity = ((CompensateEventDefinition)ed).getActivityRef();
                if (activity == null) {
                    this.addMissingFeatureStatus((EObject)edContainer, Messages.EventDefinitionValidator_CalledActivity, 4);
                } else {
                    new ActivityValidator((AbstractBpmn2ElementValidator)this).validate(activity);
                }
            }
            if (edContainer instanceof Event && EventDefinitionsUtil.hasItemDefinition(ed)) {
                int severity;
                Tuple<ItemAwareElement, DataAssociation> param = EventDefinitionsUtil.getIOParameter((Event)edContainer, ed);
                DataAssociation da = param.getSecond();
                int n = severity = ProcessValidator.isContainingProcessExecutable((EObject)edContainer) ? 4 : 2;
                if (da instanceof DataInputAssociation) {
                    if (((DataInputAssociation)da).getSourceRef().size() == 0) {
                        this.addStatus((EObject)edContainer, severity, Messages.EventDefinitionValidator_No_Source_DataItem, ModelUtil.getLabel(ed), ModelUtil.getLabel(edContainer));
                    }
                } else if (da instanceof DataOutputAssociation && ((DataOutputAssociation)da).getTargetRef() == null) {
                    this.addStatus((EObject)edContainer, severity, Messages.EventDefinitionValidator_No_Target_DataItem, ModelUtil.getLabel(ed));
                }
            }
        }
        return this.getResult();
    }
}

