/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.validation.validators;

import org.eclipse.bpmn2.CallActivity;
import org.eclipse.bpmn2.CallableElement;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.Property;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.modeler.core.model.ModelDecorator;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.validation.validators.AbstractBpmn2ElementValidator;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.drools.ExternalProcess;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.util.JbpmModelUtil;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.validation.IDiagramProfile;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.validation.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.validation.IValidationContext;

public class CallActivityValidator
extends AbstractBpmn2ElementValidator<CallActivity> {
    private IDiagramProfile profile;
    private String uuid = "uuid";

    public CallActivityValidator(IValidationContext ctx) {
        super(ctx);
    }

    public IStatus validate(CallActivity object) {
        CallableElement ref = object.getCalledElementRef();
        if (ref instanceof ExternalProcess) {
            String calledProcessId = ((ExternalProcess)ref).getId();
            boolean isVariable = false;
            String var = JbpmModelUtil.getVariableReference(calledProcessId);
            if (var != null) {
                for (EObject p : ModelUtil.collectAncestorObjects((EObject)object, (String)"properties", (Class[])new Class[]{Process.class, SubProcess.class})) {
                    String id = ((Property)p).getId();
                    if (!var.equals(id)) continue;
                    isVariable = true;
                    break;
                }
                if (!isVariable) {
                    this.addStatus((EObject)object, 4, Messages.CallActivityConstraint_Not_A_Process_Variable, new Object[]{calledProcessId});
                }
            } else if (!JbpmModelUtil.isProcessId(calledProcessId)) {
                this.addStatus((EObject)object, 4, Messages.CallActivityConstraint_Not_A_Process_ID, new Object[]{calledProcessId});
            }
        }
        EStructuralFeature feature = ModelDecorator.getAnyAttribute((EObject)object, (String)"independent");
        Boolean independent = (Boolean)object.eGet(feature);
        feature = ModelDecorator.getAnyAttribute((EObject)object, (String)"waitForCompletion");
        Boolean waitForCompletion = (Boolean)object.eGet(feature);
        if (!independent.booleanValue() && !waitForCompletion.booleanValue()) {
            this.addStatus((EObject)object, 4, Messages.CallActivityConstraint_Independent_And_WaitForCompletion_False, new Object[0]);
        }
        return this.getResult();
    }
}

