/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view;

import com.google.common.base.Preconditions;
import org.eclipse.buildship.ui.PluginImage;
import org.eclipse.buildship.ui.PluginImages;
import org.eclipse.buildship.ui.i18n.UiMessages;
import org.eclipse.buildship.ui.util.nodeselection.NodeSelection;
import org.eclipse.buildship.ui.util.nodeselection.SelectionSpecificAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public final class CollapseTreeNodesAction
extends Action
implements SelectionSpecificAction {
    private final AbstractTreeViewer treeViewer;

    public CollapseTreeNodesAction(AbstractTreeViewer treeViewer) {
        this.treeViewer = (AbstractTreeViewer)Preconditions.checkNotNull((Object)treeViewer);
        this.setText(UiMessages.Action_CollapseNodes_Text);
        this.setToolTipText(UiMessages.Action_CollapseNodes_Tooltip);
        this.setImageDescriptor(PluginImages.COLLAPSE_NODE.withState(PluginImage.ImageState.ENABLED).getImageDescriptor());
    }

    public void run() {
        ISelection selection = this.treeViewer.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            for (Object element : ((IStructuredSelection)selection).toList()) {
                this.treeViewer.collapseToLevel(element, -1);
            }
        } else {
            this.treeViewer.collapseAll();
        }
    }

    @Override
    public boolean isVisibleFor(NodeSelection selection) {
        return true;
    }

    @Override
    public boolean isEnabledFor(NodeSelection selection) {
        return true;
    }

    @Override
    public void setEnabledFor(NodeSelection selection) {
        this.setEnabled(true);
    }
}

