/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.task;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.buildship.ui.view.task.TaskView;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.ui.PlatformUI;

public final class WorkspaceProjectsChangeListener
implements IResourceChangeListener {
    private final TaskView taskView;

    public WorkspaceProjectsChangeListener(TaskView taskView) {
        this.taskView = (TaskView)Preconditions.checkNotNull((Object)taskView);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 1) {
            HashSet addedProjects = Sets.newHashSet();
            HashSet deletedProjects = Sets.newHashSet();
            this.collectChanges(event.getDelta(), addedProjects, deletedProjects);
            if (!addedProjects.isEmpty()) {
                this.notifyAboutProjectAdditions(addedProjects);
            }
            if (!deletedProjects.isEmpty()) {
                this.notifyAboutProjectRemovals(deletedProjects);
            }
        }
    }

    private void collectChanges(IResourceDelta delta, Set<IProject> addedProjects, Set<IProject> deletedProjects) {
        IResource resource = delta.getResource();
        if (resource instanceof IProject) {
            IProject project = (IProject)resource;
            int kind = delta.getKind();
            if (kind == 1) {
                addedProjects.add(project);
                return;
            }
            if (kind == 2) {
                deletedProjects.add(project);
                return;
            }
        }
        for (IResourceDelta child : delta.getAffectedChildren()) {
            this.collectChanges(child, addedProjects, deletedProjects);
        }
    }

    private void notifyAboutProjectAdditions(final Set<IProject> addedProjects) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                WorkspaceProjectsChangeListener.this.taskView.handleProjectAdditions(addedProjects);
            }
        });
    }

    private void notifyAboutProjectRemovals(final Set<IProject> deletedProjects) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                WorkspaceProjectsChangeListener.this.taskView.handleProjectRemovals(deletedProjects);
            }
        });
    }
}

