/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.editors.automake;

import java.util.ResourceBundle;
import org.eclipse.cdt.autotools.core.AutotoolsPlugin;
import org.eclipse.cdt.autotools.ui.AutotoolsUIPlugin;
import org.eclipse.cdt.internal.autotools.ui.MakeUIMessages;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.AutomakeEditorFactory;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.IReconcilingParticipant;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.MakefileContentOutlinePage;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.MakefileSourceConfiguration;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.MakefileWordDetector;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.OpenDeclarationAction;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.ProjectionMakefileUpdater;
import org.eclipse.cdt.make.core.makefile.IDirective;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class MakefileEditor
extends TextEditor
implements ISelectionChangedListener,
IReconcilingParticipant {
    protected MakefileContentOutlinePage page;
    ProjectionSupport projectionSupport;
    ProjectionMakefileUpdater fProjectionMakefileUpdater;
    private FindReplaceDocumentAdapter fFindReplaceDocumentAdapter;
    private ListenerList<IReconcilingParticipant> fReconcilingListeners = new ListenerList(1);

    MakefileSourceConfiguration getMakefileSourceConfiguration() {
        SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
        if (configuration instanceof MakefileSourceConfiguration) {
            return (MakefileSourceConfiguration)configuration;
        }
        return null;
    }

    public MakefileContentOutlinePage getOutlinePage() {
        if (this.page == null) {
            this.page = new MakefileContentOutlinePage(this);
            this.page.addSelectionChangedListener(this);
            this.page.setInput(this.getEditorInput());
        }
        return this.page;
    }

    protected void initializeEditor() {
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        this.setEditorContextMenuId("#MakefileEditorContext");
        this.setRulerContextMenuId("#MakefileRulerContext");
        this.setDocumentProvider(AutomakeEditorFactory.getDefault().getAutomakefileDocumentProvider());
        IPreferenceStore[] stores = new IPreferenceStore[]{AutotoolsPlugin.getDefault().getPreferenceStore(), EditorsUI.getPreferenceStore()};
        ChainedPreferenceStore chainedStore = new ChainedPreferenceStore(stores);
        this.setPreferenceStore((IPreferenceStore)chainedStore);
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new MakefileSourceConfiguration((IPreferenceStore)chainedStore, this));
    }

    public void dispose() {
        if (this.fProjectionMakefileUpdater != null) {
            this.fProjectionMakefileUpdater.uninstall();
            this.fProjectionMakefileUpdater = null;
        }
        super.dispose();
    }

    boolean isFoldingEnabled() {
        return AutotoolsPlugin.getDefault().getPreferenceStore().getBoolean("editor_folding_enabled");
    }

    protected boolean isTabsToSpacesConversionEnabled() {
        return false;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        this.projectionSupport = new ProjectionSupport(projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        this.projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        this.projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        this.projectionSupport.install();
        if (this.isFoldingEnabled()) {
            projectionViewer.doOperation(19);
        }
        this.fProjectionMakefileUpdater = new ProjectionMakefileUpdater();
        if (this.fProjectionMakefileUpdater != null) {
            this.fProjectionMakefileUpdater.install(this, projectionViewer);
            this.fProjectionMakefileUpdater.initialize();
        }
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    public <T> T getAdapter(Class<T> key) {
        if (ProjectionAnnotationModel.class.equals(key)) {
            Object result;
            if (this.projectionSupport != null && (result = this.projectionSupport.getAdapter(this.getSourceViewer(), key)) != null) {
                return (T)result;
            }
        } else if (key.equals(IContentOutlinePage.class)) {
            return (T)((Object)this.getOutlinePage());
        }
        return (T)super.getAdapter(key);
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        if (this.page != null) {
            this.page.update();
        }
    }

    protected void createActions() {
        super.createActions();
        ResourceBundle bundle = MakeUIMessages.getResourceBundle();
        Object a = new TextOperationAction(bundle, "ContentAssistProposal.", (ITextEditor)this, 13);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)a);
        a = new TextOperationAction(bundle, "ContentAssistTip.", (ITextEditor)this, 14);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.contextInformation");
        this.setAction("ContentAssistTip", (IAction)a);
        a = new TextOperationAction(bundle, "Comment.", (ITextEditor)this, 11);
        a.setActionDefinitionId("org.eclipse.cdt.make.ui.edit.text.makefile.comment");
        this.setAction("Comment", (IAction)a);
        this.markAsStateDependentAction("Comment", true);
        a = new TextOperationAction(bundle, "Uncomment.", (ITextEditor)this, 12);
        a.setActionDefinitionId("org.eclipse.cdt.make.ui.edit.text.makefile.uncomment");
        this.setAction("Uncomment", (IAction)a);
        this.markAsStateDependentAction("Uncomment", true);
        a = new OpenDeclarationAction((ITextEditor)this);
        a.setActionDefinitionId("org.eclipse.cdt.make.ui.edit.text.makefile.opendcl");
        this.setAction("OpenDeclarationAction", (IAction)a);
        this.markAsStateDependentAction("OpenDeclarationAction", true);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection.isEmpty()) {
            this.resetHighlightRange();
        } else if (selection instanceof IStructuredSelection) {
            Object element;
            if (!this.isActivePart() && AutotoolsUIPlugin.getActivePage() != null) {
                AutotoolsUIPlugin.getActivePage().bringToTop((IWorkbenchPart)this);
            }
            if ((element = ((IStructuredSelection)selection).getFirstElement()) instanceof IDirective) {
                IDirective statement = (IDirective)element;
                this.setSelection(statement, !this.isActivePart());
            }
        }
    }

    private boolean isActivePart() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IPartService service = window.getPartService();
        IWorkbenchPart part = service.getActivePart();
        return part != null && part.equals(this);
    }

    private FindReplaceDocumentAdapter getFindRepalceDocumentAdapter() {
        if (this.fFindReplaceDocumentAdapter == null) {
            IDocument doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
            this.fFindReplaceDocumentAdapter = new FindReplaceDocumentAdapter(doc);
        }
        return this.fFindReplaceDocumentAdapter;
    }

    public void setSelection(IDirective directive, boolean moveCursor) {
        int startLine = directive.getStartLine() - 1;
        int endLine = directive.getEndLine() - 1;
        try {
            IDocument doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
            int start = doc.getLineOffset(startLine);
            int len = doc.getLineLength(endLine) - 1;
            int length = doc.getLineOffset(endLine) + len - start;
            this.setHighlightRange(start, length, true);
            if (moveCursor) {
                IRegion region;
                String var = directive.toString().trim();
                MakefileWordDetector detector = new MakefileWordDetector();
                len = 0;
                while (len < var.length()) {
                    char c = var.charAt(len);
                    if (!detector.isWordPart(c) && !detector.isWordStart(c) && c != '-' && c != '_') break;
                    ++len;
                }
                if (len > 0) {
                    var = var.substring(0, len);
                }
                if ((region = this.getFindRepalceDocumentAdapter().find(start, var, true, true, true, false)) != null) {
                    len = region.getOffset();
                    length = region.getLength();
                    this.getSourceViewer().revealRange(len, length);
                    this.getSourceViewer().setSelectedRange(len, length);
                }
            }
        }
        catch (IllegalArgumentException x) {
            this.resetHighlightRange();
        }
        catch (BadLocationException e) {
            this.resetHighlightRange();
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        this.addAction(menu, "group.edit", "Comment");
        this.addAction(menu, "group.edit", "Uncomment");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addReconcilingParticipant(IReconcilingParticipant listener) {
        ListenerList<IReconcilingParticipant> listenerList = this.fReconcilingListeners;
        synchronized (listenerList) {
            this.fReconcilingListeners.add((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeReconcilingParticipant(IReconcilingParticipant listener) {
        ListenerList<IReconcilingParticipant> listenerList = this.fReconcilingListeners;
        synchronized (listenerList) {
            this.fReconcilingListeners.remove((Object)listener);
        }
    }

    @Override
    public void reconciled() {
        for (IReconcilingParticipant listener : this.fReconcilingListeners) {
            listener.reconciled();
        }
    }

    protected void performRevert() {
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        projectionViewer.setRedraw(false);
        try {
            boolean projectionMode = projectionViewer.isProjectionMode();
            if (projectionMode) {
                projectionViewer.disableProjection();
                if (this.fProjectionMakefileUpdater != null) {
                    this.fProjectionMakefileUpdater.uninstall();
                }
            }
            super.performRevert();
            if (projectionMode) {
                if (this.fProjectionMakefileUpdater != null) {
                    this.fProjectionMakefileUpdater.install(this, projectionViewer);
                }
                projectionViewer.enableProjection();
            }
        }
        finally {
            projectionViewer.setRedraw(true);
        }
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return;
        }
        String property = event.getProperty();
        MakefileSourceConfiguration makeConf = this.getMakefileSourceConfiguration();
        if (makeConf != null && makeConf.affectsBehavior(event)) {
            makeConf.adaptToPreferenceChange(event);
            sourceViewer.invalidateTextPresentation();
        }
        if ("editor_folding_enabled".equals(property)) {
            if (sourceViewer instanceof ProjectionViewer) {
                ProjectionViewer projectionViewer = (ProjectionViewer)sourceViewer;
                if (this.fProjectionMakefileUpdater != null) {
                    this.fProjectionMakefileUpdater.uninstall();
                }
                this.fProjectionMakefileUpdater = new ProjectionMakefileUpdater();
                if (this.fProjectionMakefileUpdater != null) {
                    this.fProjectionMakefileUpdater.install(this, projectionViewer);
                }
            }
            return;
        }
        super.handlePreferenceStoreChanged(event);
    }

    protected String[] collectContextMenuPreferencePages() {
        String[] parentPrefPageIds = super.collectContextMenuPreferencePages();
        String[] prefPageIds = new String[parentPrefPageIds.length + 2];
        int nIds = 0;
        prefPageIds[nIds++] = "org.eclipse.cdt.make.ui.preferences.MakeFileEditorPreferencePage";
        prefPageIds[nIds++] = "org.eclipse.cdt.make.ui.preferences.MakefileSettingPreferencePage";
        System.arraycopy(parentPrefPageIds, 0, prefPageIds, nIds, parentPrefPageIds.length);
        return prefPageIds;
    }
}

