/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ISemanticProblem;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBasicType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPArithmeticConversion;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPReferenceType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPDependentEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPFunctionParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CVQualifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Conversions;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Cost;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExpressionTypes;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.core.runtime.CoreException;

public class EvalConditional
extends CPPDependentEvaluation {
    private final ICPPEvaluation fCondition;
    private final ICPPEvaluation fPositive;
    private final ICPPEvaluation fNegative;
    private final boolean fPositiveThrows;
    private final boolean fNegativeThrows;
    private IASTExpression.ValueCategory fValueCategory;
    private IType fType;
    private ICPPFunction fOverload;
    private boolean fCheckedIsConstantExpression;
    private boolean fIsConstantExpression;

    public EvalConditional(ICPPEvaluation condition, ICPPEvaluation positive, ICPPEvaluation negative, boolean positiveThrows, boolean negativeThrows, IASTNode pointOfDefinition) {
        this(condition, positive, negative, positiveThrows, negativeThrows, EvalConditional.findEnclosingTemplate(pointOfDefinition));
    }

    public EvalConditional(ICPPEvaluation condition, ICPPEvaluation positive, ICPPEvaluation negative, boolean positiveThrows, boolean negativeThrows, IBinding templateDefinition) {
        super(templateDefinition);
        this.fCondition = condition;
        this.fPositive = positive;
        this.fNegative = negative;
        this.fPositiveThrows = positiveThrows;
        this.fNegativeThrows = negativeThrows;
    }

    public ICPPEvaluation getCondition() {
        return this.fCondition;
    }

    public ICPPEvaluation getPositive() {
        return this.fPositive;
    }

    public ICPPEvaluation getNegative() {
        return this.fNegative;
    }

    public boolean isPositiveThrows() {
        return this.fPositiveThrows;
    }

    public boolean isNegativeThrows() {
        return this.fNegativeThrows;
    }

    @Override
    public boolean isInitializerList() {
        return false;
    }

    @Override
    public boolean isFunctionSet() {
        return false;
    }

    public ICPPFunction getOverload(IASTNode point) {
        this.evaluate(point);
        return this.fOverload;
    }

    @Override
    public IType getType(IASTNode point) {
        this.evaluate(point);
        return this.fType;
    }

    @Override
    public IValue getValue(IASTNode point) {
        IValue condValue = this.fCondition.getValue(point);
        if (condValue == Value.UNKNOWN) {
            return Value.UNKNOWN;
        }
        Long cond = condValue.numericalValue();
        if (cond != null) {
            if (cond != 0L) {
                return this.fPositive == null ? condValue : this.fPositive.getValue(point);
            }
            return this.fNegative.getValue(point);
        }
        return Value.create(this);
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory(IASTNode point) {
        this.evaluate(point);
        return this.fValueCategory;
    }

    @Override
    public boolean isTypeDependent() {
        ICPPEvaluation positive;
        ICPPEvaluation iCPPEvaluation = positive = this.fPositive == null ? this.fCondition : this.fPositive;
        return positive.isTypeDependent() || this.fNegative.isTypeDependent();
    }

    @Override
    public boolean isValueDependent() {
        return this.fCondition.isValueDependent() || this.fPositive != null && this.fPositive.isValueDependent() || this.fNegative.isValueDependent();
    }

    @Override
    public boolean isConstantExpression(IASTNode point) {
        if (!this.fCheckedIsConstantExpression) {
            this.fCheckedIsConstantExpression = true;
            this.fIsConstantExpression = this.computeIsConstantExpression(point);
        }
        return this.fIsConstantExpression;
    }

    private boolean computeIsConstantExpression(IASTNode point) {
        return this.fCondition.isConstantExpression(point) && (this.fPositive == null || this.fPositive.isConstantExpression(point)) && this.fNegative.isConstantExpression(point);
    }

    private void evaluate(IASTNode point) {
        if (this.fValueCategory != null) {
            return;
        }
        this.fValueCategory = IASTExpression.ValueCategory.PRVALUE;
        ICPPEvaluation positive = this.fPositive == null ? this.fCondition : this.fPositive;
        IType t2 = positive.getType(point);
        IType t3 = this.fNegative.getType(point);
        IType uqt2 = SemanticUtil.getNestedType(t2, 13);
        IType uqt3 = SemanticUtil.getNestedType(t3, 13);
        if (uqt2 instanceof ISemanticProblem || uqt2 instanceof ICPPUnknownType) {
            this.fType = uqt2;
            return;
        }
        if (uqt3 instanceof ISemanticProblem || uqt3 instanceof ICPPUnknownType) {
            this.fType = uqt3;
            return;
        }
        boolean void2 = this.isVoidType(uqt2);
        boolean void3 = this.isVoidType(uqt3);
        if (void2 || void3) {
            this.fType = this.fPositiveThrows ? Conversions.lvalue_to_rvalue(t3, false) : (this.fNegativeThrows ? Conversions.lvalue_to_rvalue(t2, false) : (void2 && void3 ? uqt2 : ProblemType.UNKNOWN_FOR_EXPRESSION));
            return;
        }
        IASTExpression.ValueCategory vcat2 = positive.getValueCategory(point);
        IASTExpression.ValueCategory vcat3 = this.fNegative.getValueCategory(point);
        if (t2.isSameType(t3)) {
            if (vcat2 == vcat3) {
                this.fType = t2;
                this.fValueCategory = vcat2;
            } else {
                this.fType = ExpressionTypes.prvalueType(t2);
                this.fValueCategory = IASTExpression.ValueCategory.PRVALUE;
            }
            return;
        }
        boolean isClassType2 = uqt2 instanceof ICPPClassType;
        boolean isClassType3 = uqt3 instanceof ICPPClassType;
        if (isClassType2 || isClassType3) {
            Cost cost2 = this.convertToMatch(t2, vcat2, uqt2, t3, vcat3, uqt3, point);
            Cost cost3 = this.convertToMatch(t3, vcat3, uqt3, t2, vcat2, uqt2, point);
            if (cost2.converts() || cost3.converts()) {
                if (cost2.converts()) {
                    if (cost3.converts() || cost2.isAmbiguousUDC()) {
                        this.fType = ProblemType.UNKNOWN_FOR_EXPRESSION;
                    }
                } else if (cost3.isAmbiguousUDC()) {
                    this.fType = ProblemType.UNKNOWN_FOR_EXPRESSION;
                }
                return;
            }
        } else if (vcat2 == vcat3 && vcat2.isGLValue() && uqt2.isSameType(uqt3)) {
            CVQualifier cv3;
            CVQualifier cv2 = SemanticUtil.getCVQualifier(t2);
            if (cv2.isAtLeastAsQualifiedAs(cv3 = SemanticUtil.getCVQualifier(t3))) {
                this.fType = t2;
                this.fValueCategory = vcat2;
            } else if (cv3.isAtLeastAsQualifiedAs(cv2)) {
                this.fType = t3;
                this.fValueCategory = vcat3;
            } else {
                this.fType = ProblemType.UNKNOWN_FOR_EXPRESSION;
            }
            return;
        }
        if (isClassType2 || isClassType3) {
            this.fOverload = CPPSemantics.findOverloadedConditionalOperator(point, this.getTemplateDefinitionScope(), positive, this.fNegative);
            this.fType = this.fOverload != null ? ExpressionTypes.typeFromFunctionCall(this.fOverload) : ProblemType.UNKNOWN_FOR_EXPRESSION;
            return;
        }
        if ((t2 = Conversions.lvalue_to_rvalue(t2, false)).isSameType(t3 = Conversions.lvalue_to_rvalue(t3, false))) {
            this.fType = t2;
        } else {
            this.fType = CPPArithmeticConversion.convertCppOperandTypes(4, t2, t3);
            if (this.fType == null) {
                this.fType = Conversions.compositePointerType(t2, t3, point);
                if (this.fType == null) {
                    this.fType = ProblemType.UNKNOWN_FOR_EXPRESSION;
                }
            }
        }
    }

    private Cost convertToMatch(IType t1, IASTExpression.ValueCategory vcat1, IType uqt1, IType t2, IASTExpression.ValueCategory vcat2, IType uqt2, IASTNode point) {
        try {
            Cost c;
            CPPReferenceType target;
            Cost c2;
            if (vcat2.isGLValue() && (c2 = Conversions.checkImplicitConversionSequence(target = new CPPReferenceType(t2, vcat2 == IASTExpression.ValueCategory.XVALUE), t1, vcat1, Conversions.UDCMode.ALLOWED, Conversions.Context.REQUIRE_DIRECT_BINDING, point)).converts()) {
                this.fType = t2;
                this.fValueCategory = vcat2;
                return c2;
            }
            if (uqt1 instanceof ICPPClassType && uqt2 instanceof ICPPClassType) {
                int dist = SemanticUtil.calculateInheritanceDepth(uqt1, uqt2, point);
                if (dist >= 0) {
                    CVQualifier cv1 = SemanticUtil.getCVQualifier(t1);
                    CVQualifier cv2 = SemanticUtil.getCVQualifier(t2);
                    if (cv2.isAtLeastAsQualifiedAs(cv1)) {
                        this.fType = t2;
                        this.fValueCategory = IASTExpression.ValueCategory.PRVALUE;
                        return new Cost(t1, t2, Cost.Rank.IDENTITY);
                    }
                    return Cost.NO_CONVERSION;
                }
                if (SemanticUtil.calculateInheritanceDepth(uqt2, uqt1, point) >= 0) {
                    return Cost.NO_CONVERSION;
                }
            }
            if (vcat2 != IASTExpression.ValueCategory.PRVALUE) {
                t2 = Conversions.lvalue_to_rvalue(t2, false);
            }
            if ((c = Conversions.checkImplicitConversionSequence(t2, t1, vcat1, Conversions.UDCMode.ALLOWED, Conversions.Context.ORDINARY, point)).converts()) {
                this.fType = t2;
                this.fValueCategory = IASTExpression.ValueCategory.PRVALUE;
                return c;
            }
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        return Cost.NO_CONVERSION;
    }

    private boolean isVoidType(IType t) {
        return t instanceof ICPPBasicType && ((ICPPBasicType)t).getKind() == IBasicType.Kind.eVoid;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        short firstBytes = 6;
        if (this.fPositiveThrows) {
            firstBytes = (short)(firstBytes | 0x20);
        }
        if (this.fNegativeThrows) {
            firstBytes = (short)(firstBytes | 0x40);
        }
        buffer.putShort(firstBytes);
        buffer.marshalEvaluation(this.fCondition, includeValue);
        buffer.marshalEvaluation(this.fPositive, includeValue);
        buffer.marshalEvaluation(this.fNegative, includeValue);
        this.marshalTemplateDefinition(buffer);
    }

    public static ISerializableEvaluation unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        boolean pth = (firstBytes & 0x20) != 0;
        boolean nth = (firstBytes & 0x40) != 0;
        ICPPEvaluation cond = (ICPPEvaluation)buffer.unmarshalEvaluation();
        ICPPEvaluation pos = (ICPPEvaluation)buffer.unmarshalEvaluation();
        ICPPEvaluation neg = (ICPPEvaluation)buffer.unmarshalEvaluation();
        IBinding templateDefinition = buffer.unmarshalBinding();
        return new EvalConditional(cond, pos, neg, pth, nth, templateDefinition);
    }

    @Override
    public ICPPEvaluation instantiate(InstantiationContext context, int maxDepth) {
        ICPPEvaluation condition = this.fCondition.instantiate(context, maxDepth);
        ICPPEvaluation positive = this.fPositive == null ? null : this.fPositive.instantiate(context, maxDepth);
        ICPPEvaluation negative = this.fNegative.instantiate(context, maxDepth);
        if (condition == this.fCondition && positive == this.fPositive && negative == this.fNegative) {
            return this;
        }
        return new EvalConditional(condition, positive, negative, this.fPositiveThrows, this.fNegativeThrows, this.getTemplateDefinition());
    }

    @Override
    public ICPPEvaluation computeForFunctionCall(CPPFunctionParameterMap parameterMap, ICPPEvaluation.ConstexprEvaluationContext context) {
        ICPPEvaluation condition = this.fCondition.computeForFunctionCall(parameterMap, context.recordStep());
        Long conditionValue = condition.getValue(context.getPoint()).numericalValue();
        if (conditionValue != null) {
            if (conditionValue != 0L) {
                return this.fPositive == null ? null : this.fPositive.computeForFunctionCall(parameterMap, context.recordStep());
            }
            return this.fNegative.computeForFunctionCall(parameterMap, context.recordStep());
        }
        ICPPEvaluation positive = this.fPositive == null ? null : this.fPositive.computeForFunctionCall(parameterMap, context.recordStep());
        ICPPEvaluation negative = this.fNegative.computeForFunctionCall(parameterMap, context.recordStep());
        if (condition == this.fCondition && positive == this.fPositive && negative == this.fNegative) {
            return this;
        }
        return new EvalConditional(condition, positive, negative, this.fPositiveThrows, this.fNegativeThrows, this.getTemplateDefinition());
    }

    @Override
    public int determinePackSize(ICPPTemplateParameterMap tpMap) {
        int r = this.fCondition.determinePackSize(tpMap);
        r = CPPTemplates.combinePackSize(r, this.fNegative.determinePackSize(tpMap));
        if (this.fPositive != null) {
            r = CPPTemplates.combinePackSize(r, this.fPositive.determinePackSize(tpMap));
        }
        return r;
    }

    @Override
    public boolean referencesTemplateParameter() {
        return this.fCondition.referencesTemplateParameter() || this.fPositive != null && this.fPositive.referencesTemplateParameter() || this.fNegative.referencesTemplateParameter();
    }
}

