/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPDependentEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPFunctionParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalInitList;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExpressionTypes;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.LookupData;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeOfDependentExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeTraits;
import org.eclipse.core.runtime.CoreException;

public class EvalTypeId
extends CPPDependentEvaluation {
    private final IType fInputType;
    private final ICPPEvaluation[] fArguments;
    private final boolean fRepresentsNewExpression;
    private IType fOutputType;
    private ICPPFunction fConstructor = CPPFunction.UNINITIALIZED_FUNCTION;
    private boolean fCheckedIsTypeDependent;
    private boolean fIsTypeDependent;
    private boolean fCheckedIsConstantExpression;
    private boolean fIsConstantExpression;

    public EvalTypeId(IType type, IASTNode pointOfDefinition, ICPPEvaluation ... arguments) {
        this(type, EvalTypeId.findEnclosingTemplate(pointOfDefinition), false, arguments);
    }

    public EvalTypeId(IType type, IBinding templateDefinition, ICPPEvaluation ... arguments) {
        this(type, templateDefinition, false, arguments);
    }

    private EvalTypeId(IType type, IBinding templateDefinition, boolean forNewExpression, ICPPEvaluation ... arguments) {
        super(templateDefinition);
        if (arguments == null) {
            throw new NullPointerException("arguments");
        }
        this.fInputType = type;
        this.fArguments = arguments;
        this.fRepresentsNewExpression = forNewExpression;
    }

    public static EvalTypeId createForNewExpression(IType type, IASTNode pointOfDefinition, ICPPEvaluation ... arguments) {
        return new EvalTypeId(type, EvalTypeId.findEnclosingTemplate(pointOfDefinition), true, arguments);
    }

    public IType getInputType() {
        return this.fInputType;
    }

    public ICPPEvaluation[] getArguments() {
        return this.fArguments;
    }

    @Override
    public boolean isInitializerList() {
        return false;
    }

    @Override
    public boolean isFunctionSet() {
        return false;
    }

    @Override
    public IType getType(IASTNode point) {
        if (this.fOutputType == null) {
            this.fOutputType = this.computeType();
        }
        return this.fOutputType;
    }

    private IType computeType() {
        if (this.isTypeDependent()) {
            return new TypeOfDependentExpression(this);
        }
        IType type = ExpressionTypes.typeFromReturnType(this.fInputType);
        if (this.fRepresentsNewExpression) {
            return new CPPPointerType(type);
        }
        return type;
    }

    @Override
    public IValue getValue(IASTNode point) {
        if (this.isValueDependent()) {
            return Value.create(this);
        }
        if (this.isTypeDependent()) {
            return Value.create(this);
        }
        if (this.fRepresentsNewExpression) {
            return Value.UNKNOWN;
        }
        if (this.fOutputType instanceof ICPPClassType) {
            return Value.UNKNOWN;
        }
        if (this.fArguments.length == 1) {
            return this.fArguments[0].getValue(point);
        }
        return Value.UNKNOWN;
    }

    @Override
    public boolean isTypeDependent() {
        if (!this.fCheckedIsTypeDependent) {
            this.fCheckedIsTypeDependent = true;
            this.fIsTypeDependent = CPPTemplates.isDependentType(this.fInputType) || EvalTypeId.containsDependentType(this.fArguments);
        }
        return this.fIsTypeDependent;
    }

    @Override
    public boolean isValueDependent() {
        if (CPPTemplates.isDependentType(this.fInputType)) {
            return true;
        }
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            if (arg.isValueDependent()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isConstantExpression(IASTNode point) {
        if (!this.fCheckedIsConstantExpression) {
            this.fCheckedIsConstantExpression = true;
            this.fIsConstantExpression = this.computeIsConstantExpression(point);
        }
        return this.fIsConstantExpression;
    }

    private boolean computeIsConstantExpression(IASTNode point) {
        return !this.fRepresentsNewExpression && EvalTypeId.areAllConstantExpressions(this.fArguments, point) && EvalTypeId.isNullOrConstexprFunc(this.getConstructor(point));
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory(IASTNode point) {
        return ExpressionTypes.valueCategoryFromReturnType(this.fInputType);
    }

    public ICPPFunction getConstructor(IASTNode point) {
        if (this.fConstructor == CPPFunction.UNINITIALIZED_FUNCTION) {
            this.fConstructor = this.computeConstructor(point);
        }
        return this.fConstructor;
    }

    private ICPPFunction computeConstructor(IASTNode point) {
        if (this.isTypeDependent()) {
            return null;
        }
        IType simplifiedType = SemanticUtil.getNestedType(this.fInputType, 1);
        if (simplifiedType instanceof ICPPClassType) {
            ICPPClassType classType = (ICPPClassType)simplifiedType;
            ICPPEvaluation[] arguments = this.fArguments;
            ICPPFunction[] constructors = ClassTypeHelper.getConstructors(classType, point);
            if (arguments.length == 1 && arguments[0] instanceof EvalInitList) {
                ICPPConstructor ctor;
                if (TypeTraits.isAggregateClass(classType, point)) {
                    return this.findDefaultConstructor(classType, (ICPPConstructor[])constructors);
                }
                if (((EvalInitList)arguments[0]).getClauses().length == 0 && (ctor = this.findDefaultConstructor(classType, (ICPPConstructor[])constructors)) != null) {
                    return ctor;
                }
                ICPPConstructor[] ctors = this.getInitializerListConstructors((ICPPConstructor[])constructors, point);
                if (ctors.length != 0) {
                    constructors = ctors;
                } else {
                    arguments = ((EvalInitList)arguments[0]).getClauses();
                }
            }
            LookupData data = new LookupData(classType.getNameCharArray(), null, point);
            data.foundItems = constructors;
            data.setFunctionArguments(false, arguments);
            try {
                IBinding binding = CPPSemantics.resolveFunction(data, constructors, true);
                if (binding instanceof ICPPFunction) {
                    return (ICPPFunction)binding;
                }
            }
            catch (DOMException e) {
                CCorePlugin.log(e);
            }
        }
        return null;
    }

    private ICPPConstructor findDefaultConstructor(ICPPClassType classType, ICPPConstructor[] constructors) {
        ICPPConstructor[] iCPPConstructorArray = constructors;
        int n = constructors.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPConstructor ctor = iCPPConstructorArray[n2];
            if (ctor.isImplicit() && ClassTypeHelper.getMethodKind(classType, ctor) == ClassTypeHelper.MethodKind.DEFAULT_CTOR) {
                return ctor;
            }
            ++n2;
        }
        return null;
    }

    private ICPPConstructor[] getInitializerListConstructors(ICPPConstructor[] constructors, IASTNode point) {
        ICPPConstructor[] result = ICPPConstructor.EMPTY_CONSTRUCTOR_ARRAY;
        ICPPClassTemplate template = CPPVisitor.get_initializer_list(point);
        ICPPConstructor[] iCPPConstructorArray = constructors;
        int n = constructors.length;
        int n2 = 0;
        while (n2 < n) {
            IBinding specialized;
            IType type;
            IType[] parameterTypes;
            ICPPConstructor ctor = iCPPConstructorArray[n2];
            if (ctor.getRequiredArgumentCount() <= 1 && (parameterTypes = ctor.getType().getParameterTypes()).length != 0 && (type = parameterTypes[0]) instanceof ICPPSpecialization && (specialized = ((ICPPSpecialization)((Object)type)).getSpecializedBinding()) instanceof ICPPClassTemplate && template.isSameType((IType)((Object)specialized))) {
                result = ArrayUtil.append(result, ctor);
            }
            ++n2;
        }
        return ArrayUtil.trim(result);
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        short firstBytes = 14;
        if (this.fRepresentsNewExpression) {
            firstBytes = (short)(firstBytes | 0x20);
        }
        buffer.putShort(firstBytes);
        buffer.marshalType(this.fInputType);
        buffer.putInt(this.fArguments.length);
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            buffer.marshalEvaluation(arg, includeValue);
            ++n2;
        }
        this.marshalTemplateDefinition(buffer);
    }

    public static ISerializableEvaluation unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        IType type = buffer.unmarshalType();
        ICPPEvaluation[] args = null;
        int len = buffer.getInt();
        args = new ICPPEvaluation[len];
        int i = 0;
        while (i < args.length) {
            args[i] = (ICPPEvaluation)buffer.unmarshalEvaluation();
            ++i;
        }
        IBinding templateDefinition = buffer.unmarshalBinding();
        boolean forNewExpression = (firstBytes & 0x20) != 0;
        return new EvalTypeId(type, templateDefinition, forNewExpression, args);
    }

    @Override
    public ICPPEvaluation instantiate(InstantiationContext context, int maxDepth) {
        ICPPFunction constructor;
        IType simplifiedType;
        ICPPEvaluation[] args = EvalTypeId.instantiateCommaSeparatedSubexpressions(this.fArguments, context, maxDepth);
        IType type = CPPTemplates.instantiateType(this.fInputType, context);
        if (args == this.fArguments && type == this.fInputType) {
            return this;
        }
        EvalTypeId result = new EvalTypeId(type, this.getTemplateDefinition(), this.fRepresentsNewExpression, args);
        if (!result.isTypeDependent() && (simplifiedType = SemanticUtil.getNestedType(type, 1)) instanceof ICPPClassType && ((constructor = result.getConstructor(context.getPoint())) == null || constructor instanceof IProblemBinding || constructor.isDeleted())) {
            return EvalFixed.INCOMPLETE;
        }
        return result;
    }

    @Override
    public ICPPEvaluation computeForFunctionCall(CPPFunctionParameterMap parameterMap, ICPPEvaluation.ConstexprEvaluationContext context) {
        ICPPEvaluation[] args = this.fArguments;
        int i = 0;
        while (i < this.fArguments.length) {
            ICPPEvaluation arg = this.fArguments[i].computeForFunctionCall(parameterMap, context.recordStep());
            if (arg != this.fArguments[i]) {
                if (args == this.fArguments) {
                    args = new ICPPEvaluation[this.fArguments.length];
                    System.arraycopy(this.fArguments, 0, args, 0, this.fArguments.length);
                }
                args[i] = arg;
            }
            ++i;
        }
        if (args == this.fArguments) {
            return this;
        }
        return new EvalTypeId(this.fInputType, this.getTemplateDefinition(), this.fRepresentsNewExpression, args);
    }

    @Override
    public int determinePackSize(ICPPTemplateParameterMap tpMap) {
        int r = CPPTemplates.determinePackSize(this.fInputType, tpMap);
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            r = CPPTemplates.combinePackSize(r, arg.determinePackSize(tpMap));
            ++n2;
        }
        return r;
    }

    @Override
    public boolean referencesTemplateParameter() {
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            if (arg.referencesTemplateParameter()) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

