/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import java.util.ArrayList;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.model.IRegisterDescriptor;
import org.eclipse.cdt.debug.internal.core.model.CoreModelMessages;
import org.eclipse.cdt.debug.internal.core.model.IRegisterGroupDescriptor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RegisterGroupsPersistance {
    private static final String BLANK_STRING = "";
    private static final String DEFAULT_LAUNCH_CONFIGURATION_TARGET_ATTRIBUTE = "org.eclipse.cdt.launch.DEBUGGER_REGISTER_GROUPS";
    private static final String ELEMENT_REGISTER_GROUP_LIST = "registerGroups";
    private static final String ATTR_REGISTER_GROUP_MEMENTO = "memento";
    private static final String ELEMENT_GROUP = "group";
    private static final String ELEMENT_REGISTER_GROUP = "registerGroup";
    private static final String ATTR_REGISTER_GROUP_NAME = "name";
    private static final String ATTR_REGISTER_GROUP_ENABLED = "enabled";
    private static final String ELEMENT_REGISTER = "register";
    private static final String ATTR_REGISTER_NAME = "name";
    private static final String ATTR_REGISTER_ORIGINAL_GROUP_NAME = "originalGroupName";
    private final ILaunchConfiguration fLaunchConfig;
    private String fLaunchConfigTargetAttribute = "org.eclipse.cdt.launch.DEBUGGER_REGISTER_GROUPS";

    public RegisterGroupsPersistance(ILaunchConfiguration configuration) {
        this.fLaunchConfig = configuration;
    }

    public void setLaunchConfigurationTargetAttribute(String launchConfigurationTargetAttribute) {
        this.fLaunchConfigTargetAttribute = launchConfigurationTargetAttribute;
    }

    public String getLaunchConfigurationTargetAttribute() {
        return this.fLaunchConfigTargetAttribute;
    }

    public IRegisterGroupDescriptor[] parseGroups() {
        ArrayList<IRegisterGroupDescriptor> groups = new ArrayList<IRegisterGroupDescriptor>();
        try {
            String memento = this.fLaunchConfig.getAttribute(DEFAULT_LAUNCH_CONFIGURATION_TARGET_ATTRIBUTE, BLANK_STRING);
            if (memento != null && memento.length() > 0) {
                Element element;
                Element node = DebugPlugin.parseDocument((String)memento);
                if (node.getNodeType() != 1) {
                    this.abort("Unable to restore register groups - invalid memento.", null);
                }
                if (!ELEMENT_REGISTER_GROUP_LIST.equals((element = node).getNodeName())) {
                    this.abort("Unable to restore register groups - expecting register group list element.", null);
                }
                Node childNode = element.getFirstChild();
                while (childNode != null) {
                    String groupMemento;
                    IRegisterGroupDescriptor groupdesc;
                    Element child;
                    if (childNode.getNodeType() == 1 && ELEMENT_GROUP.equals((child = (Element)childNode).getNodeName()) && (groupdesc = this.createGroupFromMemento(groupMemento = child.getAttribute(ATTR_REGISTER_GROUP_MEMENTO))) != null) {
                        groups.add(groupdesc);
                    }
                    childNode = childNode.getNextSibling();
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return groups.toArray(new IRegisterGroupDescriptor[groups.size()]);
    }

    public void saveGroups(IRegisterGroupDescriptor[] groups) throws CoreException {
        try {
            ILaunchConfigurationWorkingCopy wc = this.fLaunchConfig.getWorkingCopy();
            wc.setAttribute(this.fLaunchConfigTargetAttribute, groups.length > 0 ? this.getMemento(groups) : BLANK_STRING);
            wc.doSave();
        }
        catch (CoreException e) {
            this.abort(String.valueOf(e.getMessage()) + ", cause: " + e.getCause(), e);
        }
    }

    protected IRegisterDescriptor findDescriptor(String originalGroupName, String name) {
        return new RegisterDescriptor(originalGroupName, name);
    }

    private IRegisterGroupDescriptor createGroupFromMemento(String memento) throws CoreException {
        String groupName;
        Element element;
        Element node = DebugPlugin.parseDocument((String)memento);
        if (node.getNodeType() != 1) {
            this.abort(CoreModelMessages.getString("CRegisterGroup.0"), null);
        }
        if (!ELEMENT_REGISTER_GROUP.equals((element = node).getNodeName())) {
            this.abort(CoreModelMessages.getString("CRegisterGroup.1"), null);
        }
        if ((groupName = element.getAttribute("name")) == null || groupName.length() == 0) {
            this.abort(CoreModelMessages.getString("CRegisterGroup.2"), null);
        }
        String e = element.getAttribute(ATTR_REGISTER_GROUP_ENABLED);
        boolean enabled = Boolean.parseBoolean(e);
        RegisterGroupDescriptor group = new RegisterGroupDescriptor(memento, groupName, enabled);
        return group;
    }

    private String getMemento(IRegisterGroupDescriptor[] groups) throws CoreException {
        Document document = DebugPlugin.newDocument();
        Element element = document.createElement(ELEMENT_REGISTER_GROUP_LIST);
        IRegisterGroupDescriptor[] iRegisterGroupDescriptorArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            IRegisterGroupDescriptor group = iRegisterGroupDescriptorArray[n2];
            Element child = document.createElement(ELEMENT_GROUP);
            child.setAttribute(ATTR_REGISTER_GROUP_MEMENTO, this.getMemento(group));
            element.appendChild(child);
            ++n2;
        }
        document.appendChild(element);
        return DebugPlugin.serializeDocument((Document)document);
    }

    private String getMemento(IRegisterGroupDescriptor group) throws CoreException {
        Document document = DebugPlugin.newDocument();
        Element element = document.createElement(ELEMENT_REGISTER_GROUP);
        element.setAttribute("name", group.getName());
        element.setAttribute(ATTR_REGISTER_GROUP_ENABLED, String.valueOf(group.isEnabled()));
        IRegisterDescriptor[] registerDescriptors = group.getChildren();
        int i = 0;
        while (i < registerDescriptors.length) {
            Element child = document.createElement(ELEMENT_REGISTER);
            child.setAttribute("name", registerDescriptors[i].getName());
            child.setAttribute(ATTR_REGISTER_ORIGINAL_GROUP_NAME, registerDescriptors[i].getGroupName());
            element.appendChild(child);
            ++i;
        }
        document.appendChild(element);
        return DebugPlugin.serializeDocument((Document)document);
    }

    private void abort(String message, Throwable exception) throws CoreException {
        Status status = new Status(4, "org.eclipse.cdt.debug.core", 4, message, exception);
        throw new CoreException((IStatus)status);
    }

    class RegisterDescriptor
    implements IRegisterDescriptor {
        private final String fGroupName;
        private final String fName;

        private RegisterDescriptor(String oGroupName, String rname) {
            this.fGroupName = oGroupName;
            this.fName = rname;
        }

        @Override
        public String getName() {
            return this.fName;
        }

        @Override
        public String getGroupName() {
            return this.fGroupName;
        }
    }

    private class RegisterGroupDescriptor
    implements IRegisterGroupDescriptor {
        private final String fMemento;
        private final String fName;
        private final boolean fEnabled;
        IRegisterDescriptor[] fRegisterDescriptors = null;

        public RegisterGroupDescriptor(String memento, String groupName, boolean enabled) {
            this.fMemento = memento;
            this.fName = groupName;
            this.fEnabled = enabled;
        }

        @Override
        public String getName() {
            return this.fName;
        }

        @Override
        public boolean isEnabled() {
            return this.fEnabled;
        }

        @Override
        public IRegisterDescriptor[] getChildren() throws CoreException {
            if (this.fRegisterDescriptors == null) {
                Element node;
                Element element = node = DebugPlugin.parseDocument((String)this.fMemento);
                ArrayList<IRegisterDescriptor> list = new ArrayList<IRegisterDescriptor>();
                Node childNode = element.getFirstChild();
                while (childNode != null) {
                    Element child;
                    if (childNode.getNodeType() == 1 && RegisterGroupsPersistance.ELEMENT_REGISTER.equals((child = (Element)childNode).getNodeName())) {
                        String name = child.getAttribute("name");
                        String originalGroupName = child.getAttribute(RegisterGroupsPersistance.ATTR_REGISTER_ORIGINAL_GROUP_NAME);
                        if (name == null || name.length() == 0 || originalGroupName == null || originalGroupName.length() == 0) {
                            RegisterGroupsPersistance.this.abort(CoreModelMessages.getString("CRegisterGroup.3"), null);
                        } else {
                            IRegisterDescriptor d = RegisterGroupsPersistance.this.findDescriptor(originalGroupName, name);
                            if (d != null) {
                                list.add(d);
                            } else {
                                CDebugCorePlugin.log(CoreModelMessages.getString("CRegisterGroup.4"));
                            }
                        }
                    }
                    childNode = childNode.getNextSibling();
                }
                this.fRegisterDescriptors = list.toArray(new IRegisterDescriptor[list.size()]);
            }
            return this.fRegisterDescriptors;
        }
    }
}

