/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view;

import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerExecutionState;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerThread;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view.IMulticoreVisualizerConstants;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view.MulticoreVisualizerCore;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view.MulticoreVisualizerGraphicObject;
import org.eclipse.cdt.visualizer.ui.util.Colors;
import org.eclipse.cdt.visualizer.ui.util.GUIUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;

public class MulticoreVisualizerThread
extends MulticoreVisualizerGraphicObject {
    public static final int THREAD_SPOT_SIZE = 18;
    public static final int MIN_PARENT_WIDTH = 22;
    protected MulticoreVisualizerCore m_core;
    protected VisualizerThread m_thread;
    protected boolean m_processSelected = true;

    public MulticoreVisualizerThread(MulticoreVisualizerCore core, VisualizerThread thread) {
        this.m_core = core;
        this.m_thread = thread;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.m_thread = null;
    }

    public MulticoreVisualizerCore getCore() {
        return this.m_core;
    }

    public void setCore(MulticoreVisualizerCore core) {
        this.m_core = core;
    }

    public VisualizerThread getThread() {
        return this.m_thread;
    }

    public int getPID() {
        return this.m_thread.getPID();
    }

    public int getTID() {
        return this.m_thread.getTID();
    }

    public VisualizerExecutionState getState() {
        return this.m_thread.getState();
    }

    public void setProcessSelected(boolean processSelected) {
        this.m_processSelected = processSelected;
    }

    public boolean getProcessSelected() {
        return this.m_processSelected;
    }

    protected Color getThreadStateColor() {
        switch (this.m_thread.getState()) {
            case RUNNING: {
                return IMulticoreVisualizerConstants.COLOR_RUNNING_THREAD;
            }
            case SUSPENDED: {
                return IMulticoreVisualizerConstants.COLOR_SUSPENDED_THREAD;
            }
            case CRASHED: {
                return IMulticoreVisualizerConstants.COLOR_CRASHED_THREAD;
            }
            case EXITED: {
                return IMulticoreVisualizerConstants.COLOR_EXITED_THREAD;
            }
        }
        assert (false);
        return Colors.BLACK;
    }

    @Override
    public void paintContent(GC gc) {
        if (this.m_core.getWidth() >= 22) {
            gc.setBackground(this.getThreadStateColor());
            int x = this.m_bounds.x;
            int y = this.m_bounds.y;
            int w = 18;
            int h = 18;
            int step1 = 3;
            int step2 = 6;
            int alpha1 = 128;
            int alpha2 = 196;
            int alpha3 = 255;
            if (!this.m_processSelected) {
                alpha1 -= 64;
                alpha2 -= 64;
                alpha3 -= 64;
            }
            gc.setAlpha(alpha1);
            gc.fillOval(x, y, w, h);
            gc.setAlpha(alpha2);
            gc.fillOval(x + step1, y + step1, w - step1 * 2, h - step1 * 2);
            gc.setAlpha(alpha3);
            gc.fillOval(x + step2, y + step2, w - step2 * 2, h - step2 * 2);
            gc.setAlpha(255);
            if (this.m_thread.isProcessThread()) {
                gc.setForeground(IMulticoreVisualizerConstants.COLOR_PROCESS_THREAD);
                gc.drawOval(x, y, w - 1, h - 1);
            }
            gc.setBackground(IMulticoreVisualizerConstants.COLOR_THREAD_TEXT_BG);
            gc.setForeground(IMulticoreVisualizerConstants.COLOR_THREAD_TEXT_FG);
            String displayTID = Integer.toString(this.m_thread.getTID());
            GUIUtils.drawText((GC)gc, (String)displayTID, (int)(x + w + 4), (int)(y + 2));
            if (this.m_selected) {
                gc.setForeground(IMulticoreVisualizerConstants.COLOR_SELECTED);
                gc.drawOval(x - 2, y - 2, w + 3, h + 3);
                gc.drawOval(x - 3, y - 3, w + 5, h + 5);
            }
        }
    }

    public String getTooltip(int x, int y) {
        return this.m_thread.getLocationInfo();
    }
}

