/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.events;

import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.mi.service.command.events.MIStoppedEvent;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIFrame;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;

@Immutable
public class MISignalEvent
extends MIStoppedEvent {
    private final String sigName;
    private final String sigMeaning;

    protected MISignalEvent(IRunControl.IExecutionDMContext ctx, int token, MIResult[] results, MIFrame frame, String sigName, String sigMeaning) {
        super(ctx, token, results, frame);
        this.sigName = sigName;
        this.sigMeaning = sigMeaning;
    }

    public String getName() {
        return this.sigName;
    }

    public String getMeaning() {
        return this.sigMeaning;
    }

    public static MISignalEvent parse(IRunControl.IExecutionDMContext dmc, int token, MIResult[] results) {
        String sigName = "";
        String sigMeaning = "";
        int i = 0;
        while (i < results.length) {
            String var = results[i].getVariable();
            MIValue value = results[i].getMIValue();
            String str = "";
            if (value instanceof MIConst) {
                str = ((MIConst)value).getString();
            }
            if (var.equals("signal-name")) {
                sigName = str;
            } else if (var.equals("signal-meaning")) {
                sigMeaning = str;
            }
            ++i;
        }
        MIStoppedEvent stoppedEvent = MIStoppedEvent.parse(dmc, token, results);
        return new MISignalEvent((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), token, results, stoppedEvent.getFrame(), sigName, sigMeaning);
    }

    public static /* bridge */ /* synthetic */ MIStoppedEvent parse(IRunControl.IExecutionDMContext iExecutionDMContext, int n, MIResult[] mIResultArray) {
        return MISignalEvent.parse(iExecutionDMContext, n, mIResultArray);
    }
}

