/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.testing.internal;

import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.dltk.ruby.ast.FakeModuleDeclaration;

public class ResolverUtils {
    public static ISourceRange getSourceRange(IMember member) {
        try {
            ISourceRange sourceRange = member.getSourceRange();
            ISourceRange nameRange = member.getNameRange();
            if (nameRange != null && nameRange.getLength() > 0) {
                return ResolverUtils.adjustRange(member.getSourceModule().getSource(), sourceRange.getOffset(), nameRange.getOffset() + nameRange.getLength());
            }
            return sourceRange;
        }
        catch (ModelException modelException) {
            return null;
        }
    }

    public static ISourceRange adjustRange(String source, int start, int end) {
        while (start < source.length() && Character.isWhitespace(source.charAt(start))) {
            ++start;
        }
        while (end > start && Character.isWhitespace(source.charAt(end - 1))) {
            --end;
        }
        return new SourceRange(start, end - start);
    }

    public static ISourceRange adjustRange(String source, ISourceRange range) {
        return ResolverUtils.adjustRange(source, range.getOffset(), range.getOffset() + range.getLength());
    }

    public static ModuleDeclaration parse(ISourceModule module) {
        ModuleDeclaration declaration = SourceParserUtil.getModuleDeclaration((ISourceModule)module);
        if (declaration instanceof FakeModuleDeclaration) {
            return null;
        }
        return declaration;
    }
}

