/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs;

import java.util.List;
import org.eclipse.e4.tools.emf.ui.common.IModelResource;
import org.eclipse.e4.tools.emf.ui.internal.Messages;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ControlFactory;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.SaveDialogBoundsSettingsDialog;
import org.eclipse.e4.ui.dialogs.filteredtree.PatternFilter;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractIdDialog<ContributionClass, ElementClass extends MApplicationElement>
extends SaveDialogBoundsSettingsDialog {
    protected EModelService modelService;
    protected TableViewer viewer;
    protected EditingDomain domain;
    protected IModelResource resource;
    protected ContributionClass contribution;
    protected Messages messages;

    public AbstractIdDialog(Shell parentShell, IModelResource resource, ContributionClass toolbarContribution, EditingDomain domain, EModelService modelService, Messages Messages2) {
        super(parentShell);
        this.resource = resource;
        this.modelService = modelService;
        this.messages = Messages2;
        this.domain = domain;
        this.contribution = toolbarContribution;
    }

    protected abstract String getShellTitle();

    protected abstract String getDialogTitle();

    protected abstract String getDialogMessage();

    protected abstract String getLabelText();

    protected abstract List<ElementClass> getViewerInput();

    protected abstract EAttribute getFeatureLiteral();

    protected abstract String getListItemInformation(ElementClass var1);

    protected boolean isResizable() {
        return true;
    }

    protected IBaseLabelProvider getLabelProvider() {
        return new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new DefaultStyledLabelProvider());
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.getShellTitle());
        this.setTitle(this.getDialogTitle());
        this.setMessage(this.getDialogMessage());
        Composite comp = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(comp, 0);
        container.setLayoutData((Object)new GridData(1808));
        container.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label(container, 0);
        l.setText(this.getLabelText());
        Text idField = new Text(container, 2688);
        idField.setLayoutData((Object)new GridData(768));
        PatternFilter filter = new PatternFilter(true){

            protected boolean isParentMatch(Viewer viewer, Object element) {
                return viewer instanceof AbstractTreeViewer && super.isParentMatch(viewer, element);
            }
        };
        l = new Label(container, 0);
        this.viewer = new TableViewer(container);
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider(this.getLabelProvider());
        this.viewer.addFilter((ViewerFilter)filter);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AbstractIdDialog.this.okPressed();
            }
        });
        ControlFactory.attachFiltering(idField, this.viewer, filter);
        this.viewer.setInput(this.getViewerInput());
        return comp;
    }

    protected void okPressed() {
        if (!this.viewer.getSelection().isEmpty()) {
            MApplicationElement el = (MApplicationElement)((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
            Command cmd = SetCommand.create((EditingDomain)this.domain, this.contribution, (Object)this.getFeatureLiteral(), (Object)el.getElementId());
            if (cmd.canExecute()) {
                this.domain.getCommandStack().execute(cmd);
                super.okPressed();
            }
        }
    }

    private class DefaultStyledLabelProvider
    extends BaseLabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private DefaultStyledLabelProvider() {
        }

        public StyledString getStyledText(Object element) {
            MApplicationElement el = (MApplicationElement)element;
            String elementId = el.getElementId() != null && el.getElementId().trim().length() > 0 ? el.getElementId() : "(Id missing)";
            StyledString str = new StyledString(elementId);
            String infoString = AbstractIdDialog.this.getListItemInformation(el);
            if (infoString != null && infoString.trim().length() > 0) {
                str.append(" - " + AbstractIdDialog.this.getListItemInformation(el), StyledString.DECORATIONS_STYLER);
            }
            return str;
        }

        public Image getImage(Object element) {
            return null;
        }
    }
}

