/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.core.api.controllers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.eef.EEFRuleAuditDescription;
import org.eclipse.eef.EEFValidationRuleDescription;
import org.eclipse.eef.EefPackage;
import org.eclipse.eef.core.api.controllers.IConsumer;
import org.eclipse.eef.core.api.controllers.IEEFController;
import org.eclipse.eef.core.api.controllers.IValidationRuleResult;
import org.eclipse.eef.core.api.utils.EvalFactory;
import org.eclipse.eef.core.internal.controllers.InvalidValidationRuleResult;
import org.eclipse.eef.core.internal.controllers.ValidationRuleResult;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;

public abstract class AbstractEEFController
implements IEEFController {
    protected IInterpreter interpreter;
    protected IVariableManager variableManager;
    private IConsumer<List<IValidationRuleResult>> validationConsumer;

    public AbstractEEFController(IVariableManager variableManager, IInterpreter interpreter) {
        this.variableManager = variableManager;
        this.interpreter = interpreter;
    }

    protected EvalFactory.Eval<Object> newEval() {
        return EvalFactory.of(this.interpreter, this.variableManager);
    }

    @Override
    public void onValidation(IConsumer<List<IValidationRuleResult>> consumer) {
        this.validationConsumer = consumer;
    }

    @Override
    public void removeValidationConsumer() {
        this.validationConsumer = null;
    }

    @Override
    public void refresh() {
        List<IValidationRuleResult> validationRuleResults = this.getValidationRuleResults(this.getValidationRulesContainer(), this.getValidationRulesReference());
        if (this.validationConsumer != null) {
            this.validationConsumer.apply(validationRuleResults);
        }
    }

    protected abstract EObject getValidationRulesContainer();

    protected abstract EReference getValidationRulesReference();

    private List<IValidationRuleResult> getValidationRuleResults(EObject eObject, EReference validationRulesReference) {
        ArrayList<IValidationRuleResult> validationRuleResults = new ArrayList<IValidationRuleResult>();
        ArrayList<EEFValidationRuleDescription> descriptions = new ArrayList<EEFValidationRuleDescription>();
        Object validationRules = eObject.eGet((EStructuralFeature)validationRulesReference);
        if (validationRules instanceof Iterable) {
            for (Object validationRule : (Iterable)validationRules) {
                if (!(validationRule instanceof EEFValidationRuleDescription)) continue;
                descriptions.add((EEFValidationRuleDescription)validationRule);
            }
        }
        EAttribute auditEAttribute = EefPackage.Literals.EEF_RULE_AUDIT_DESCRIPTION__AUDIT_EXPRESSION;
        EAttribute messageEAttribute = EefPackage.Literals.EEF_VALIDATION_RULE_DESCRIPTION__MESSAGE_EXPRESSION;
        for (EEFValidationRuleDescription validationRule : descriptions) {
            boolean isValid = true;
            for (EEFRuleAuditDescription audit : validationRule.getAudits()) {
                String auditExpression = audit.getAuditExpression();
                Boolean result = this.newEval().logIfBlank(auditEAttribute).logIfInvalidType(Boolean.class).evaluate(auditExpression);
                boolean bl = isValid = isValid && result != null && result != false;
                if (!isValid) break;
            }
            if (isValid) {
                validationRuleResults.add(new ValidationRuleResult(validationRule));
                continue;
            }
            EvalFactory.Eval<Object> eval = this.newEval();
            String messageExpression = validationRule.getMessageExpression();
            String message = eval.logIfBlank(messageEAttribute).logIfInvalidType(String.class).evaluate(messageExpression);
            validationRuleResults.add(new InvalidValidationRuleResult(validationRule, message, this.newEval(), validationRule.getSeverity().getValue()));
        }
        return validationRuleResults;
    }
}

