/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.core.internal;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.eef.EEFPageDescription;
import org.eclipse.eef.EEFViewDescription;
import org.eclipse.eef.common.api.utils.Util;
import org.eclipse.eef.core.api.EEFGroup;
import org.eclipse.eef.core.api.EEFPage;
import org.eclipse.eef.core.api.EEFView;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.IEEFDomainClassTester;
import org.eclipse.eef.core.api.InputDescriptor;
import org.eclipse.eef.core.api.controllers.IConsumer;
import org.eclipse.eef.core.api.utils.EvalFactory;
import org.eclipse.eef.core.internal.DomainClassPredicate;
import org.eclipse.eef.core.internal.EEFCorePlugin;
import org.eclipse.eef.core.internal.EEFPageImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;

public class EEFViewImpl
implements EEFView {
    private IVariableManager variableManager;
    private IInterpreter interpreter;
    private EEFViewDescription eefViewDescription;
    private EditingContextAdapter contextAdapter;
    private List<EEFPage> eefPages = new ArrayList<EEFPage>();
    private IEEFDomainClassTester domainClassTester;

    public EEFViewImpl(EEFViewDescription eefViewDescription, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter contextAdapter, IEEFDomainClassTester domainClassTester) {
        this.variableManager = variableManager;
        this.interpreter = interpreter;
        this.eefViewDescription = eefViewDescription;
        this.contextAdapter = contextAdapter;
        this.domainClassTester = domainClassTester;
    }

    @Override
    public void initialize() {
        EEFCorePlugin.getPlugin().debug("EEFViewImpl#initialize()");
        for (final EEFPageDescription eefPageDescription : this.getDescription().getPages()) {
            String preconditionExpression = eefPageDescription.getPreconditionExpression();
            Boolean preconditionValid = EvalFactory.of(this.interpreter, this.variableManager).logIfInvalidType(Boolean.class).evaluate(preconditionExpression);
            if (preconditionValid != null && !preconditionValid.booleanValue()) continue;
            IConsumer<Object> consumer = new IConsumer<Object>(){

                @Override
                public void apply(Object value) {
                    DomainClassPredicate domainClassPredicate = new DomainClassPredicate(eefPageDescription.getDomainClass(), EEFViewImpl.this.domainClassTester);
                    Iterable iterable = Util.asIterable((Object)value, EObject.class);
                    Iterable eObjects = Iterables.filter((Iterable)iterable, (Predicate)domainClassPredicate);
                    boolean isUnique = true;
                    Iterator iterator = eObjects.iterator();
                    while (iterator.hasNext()) {
                        EObject eObject = (EObject)iterator.next();
                        if (isUnique && iterator.hasNext()) {
                            isUnique = false;
                        }
                        EEFPageImpl ePage = EEFViewImpl.this.createPage(eefPageDescription, eObject, isUnique);
                        ePage.initialize();
                        EEFViewImpl.this.eefPages.add(ePage);
                    }
                }
            };
            Object self = this.variableManager.getVariables().get("self");
            String pageSemanticCandidateExpression = eefPageDescription.getSemanticCandidateExpression();
            EvalFactory.of(this.interpreter, this.variableManager).defaultValue(self).call(pageSemanticCandidateExpression, consumer);
        }
    }

    private EEFPageImpl createPage(EEFPageDescription description, Object semanticCandidate, boolean isUnique) {
        IVariableManager childVariableManager = this.variableManager.createChild();
        if (semanticCandidate != null) {
            childVariableManager.put("self", semanticCandidate);
        }
        return new EEFPageImpl(this, description, childVariableManager, this.interpreter, this.domainClassTester, isUnique);
    }

    @Override
    public void setInput(InputDescriptor input) {
        Object selfValue = this.variableManager.getVariables().get("self");
        EObject eObject = input.getSemanticElement();
        if (eObject != selfValue) {
            this.variableManager.clear();
            this.variableManager.put("self", (Object)eObject);
            this.variableManager.put("input", (Object)input);
            for (final EEFPage eefPage : this.eefPages) {
                IConsumer<Object> pageConsumer = new IConsumer<Object>(){

                    @Override
                    public void apply(Object value) {
                        for (Object pageSemanticCandidate : Util.asIterable((Object)value, Object.class)) {
                            eefPage.getVariableManager().put("self", pageSemanticCandidate);
                        }
                    }
                };
                Object viewSelf = this.variableManager.getVariables().get("self");
                String pageSemanticCandidateExpression = eefPage.getDescription().getSemanticCandidateExpression();
                EvalFactory.of(this.interpreter, this.variableManager).defaultValue(viewSelf).call(pageSemanticCandidateExpression, pageConsumer);
                List<EEFGroup> groups = eefPage.getGroups();
                for (final EEFGroup eefGroup : groups) {
                    IConsumer<Object> groupConsumer = new IConsumer<Object>(){

                        @Override
                        public void apply(Object value) {
                            eefGroup.getVariableManager().put("self", value);
                        }
                    };
                    Object pageSelf = eefPage.getVariableManager().getVariables().get("self");
                    String groupSemanticCandidateExpression = eefGroup.getDescription().getSemanticCandidateExpression();
                    EvalFactory.of(this.interpreter, eefPage.getVariableManager()).defaultValue(pageSelf).call(groupSemanticCandidateExpression, groupConsumer);
                }
            }
        }
    }

    @Override
    public List<EEFPage> getPages() {
        return this.eefPages;
    }

    @Override
    public EEFViewDescription getDescription() {
        return this.eefViewDescription;
    }

    @Override
    public IInterpreter getInterpreter() {
        return this.interpreter;
    }

    @Override
    public IVariableManager getVariableManager() {
        return this.variableManager;
    }

    @Override
    public EditingContextAdapter getContextAdapter() {
        return this.contextAdapter;
    }
}

