/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.core.internal.controllers;

import org.eclipse.eef.EEFButtonDescription;
import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.eef.EefPackage;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.AbstractEEFWidgetController;
import org.eclipse.eef.core.api.controllers.IConsumer;
import org.eclipse.eef.core.api.controllers.IEEFButtonController;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;

public class EEFButtonController
extends AbstractEEFWidgetController
implements IEEFButtonController {
    private EEFButtonDescription description;
    private EditingContextAdapter contextAdapter;
    private IConsumer<String> newButtonLabelConsumer;

    public EEFButtonController(EEFButtonDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter contextAdapter) {
        super(variableManager, interpreter);
        this.description = description;
        this.contextAdapter = contextAdapter;
    }

    @Override
    public void onNewButtonLabel(IConsumer<String> consumer) {
        this.newButtonLabelConsumer = consumer;
    }

    @Override
    public void removeNewButtonLabelConsumer() {
        this.newButtonLabelConsumer = null;
    }

    @Override
    protected EEFWidgetDescription getDescription() {
        return this.description;
    }

    @Override
    public void refresh() {
        super.refresh();
        String buttonLabelExpression = this.description.getButtonLabelExpression();
        this.newEval().logIfInvalidType(String.class).defaultValue("...").call(buttonLabelExpression, this.newButtonLabelConsumer);
    }

    @Override
    public void pushed() {
        this.contextAdapter.performModelChange(new Runnable(){

            @Override
            public void run() {
                String pushExpression = EEFButtonController.this.description.getPushExpression();
                EAttribute attr = EefPackage.Literals.EEF_BUTTON_DESCRIPTION__PUSH_EXPRESSION;
                EEFButtonController.this.newEval().logIfBlank(attr).call(pushExpression);
            }
        });
    }
}

