/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.properties.ui.legacy.internal.extension.impl;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.eef.properties.ui.legacy.internal.EEFPropertiesUiLegacyPlugin;
import org.eclipse.eef.properties.ui.legacy.internal.Messages;
import org.eclipse.eef.properties.ui.legacy.internal.extension.AbstractRegistryEventListener;
import org.eclipse.eef.properties.ui.legacy.internal.extension.impl.LegacyPropertySectionItemDescriptor;
import org.eclipse.eef.properties.ui.legacy.internal.extension.impl.LegacyPropertySectionRegistry;
import org.eclipse.jface.viewers.IFilter;

public class LegacyPropertySectionsRegistryEventListener
extends AbstractRegistryEventListener {
    public static final String TAG_PROPERTY_SECTIONS = "propertySections";
    public static final String CONTRIBUTOR_ID_ATTR = "contributorId";
    public static final String TAG_PROPERTY_SECTION = "propertySection";
    public static final String TAB_ATTR = "tab";
    public static final String ID_ATTR = "id";
    public static final String CLASS_ATTR = "class";
    public static final String AFTER_SECTION_ATTR = "afterSection";
    public static final String ENABLES_FOR_ATTR = "enablesFor";
    public static final String FILTER_ATTR = "filter";
    private static final int ENABLES_FOR_ANY = -1;
    private LegacyPropertySectionRegistry propertySectionRegistry;

    public LegacyPropertySectionsRegistryEventListener(String namespace, String extensionPointID, LegacyPropertySectionRegistry itemRegistry) {
        super(namespace, extensionPointID);
        this.propertySectionRegistry = itemRegistry;
    }

    @Override
    protected boolean validateConfigurationElement(IConfigurationElement configurationElement) {
        boolean isValid = false;
        if (TAG_PROPERTY_SECTIONS.equals(configurationElement.getName())) {
            if (!this.isValidAttribute(configurationElement, CONTRIBUTOR_ID_ATTR)) {
                String message = MessageFormat.format(Messages.RegistryEventListener_missingAttribute, configurationElement.getNamespaceIdentifier(), CONTRIBUTOR_ID_ATTR);
                EEFPropertiesUiLegacyPlugin.getImplementation().logError(message, null);
            } else {
                isValid = true;
            }
        } else if (TAG_PROPERTY_SECTION.equals(configurationElement.getName())) {
            if (!this.isValidAttribute(configurationElement, TAB_ATTR)) {
                String message = MessageFormat.format(Messages.RegistryEventListener_missingAttribute, configurationElement.getNamespaceIdentifier(), TAB_ATTR);
                EEFPropertiesUiLegacyPlugin.getImplementation().logError(message, null);
            } else if (!this.isValidAttribute(configurationElement, ID_ATTR)) {
                String message = MessageFormat.format(Messages.RegistryEventListener_missingAttribute, configurationElement.getNamespaceIdentifier(), ID_ATTR);
                EEFPropertiesUiLegacyPlugin.getImplementation().logError(message, null);
            } else if (!this.isValidAttribute(configurationElement, CLASS_ATTR)) {
                String message = MessageFormat.format(Messages.RegistryEventListener_missingAttribute, configurationElement.getNamespaceIdentifier(), CLASS_ATTR);
                EEFPropertiesUiLegacyPlugin.getImplementation().logError(message, null);
            } else {
                isValid = true;
            }
        }
        return isValid;
    }

    private boolean isValidAttribute(IConfigurationElement configurationElement, String attributeName) {
        return configurationElement.getAttribute(attributeName) != null && !"".equals(configurationElement.getAttribute(attributeName));
    }

    @Override
    protected boolean processAddition(IConfigurationElement configurationElement) {
        if (TAG_PROPERTY_SECTION.equals(configurationElement.getName())) {
            String enablesForStr;
            int enablesForTest;
            String tab = configurationElement.getAttribute(TAB_ATTR);
            String id = configurationElement.getAttribute(ID_ATTR);
            String afterSection = configurationElement.getAttribute(AFTER_SECTION_ATTR);
            int enablesFor = -1;
            IFilter filter = null;
            if (configurationElement.getAttribute(ENABLES_FOR_ATTR) != null && (enablesForTest = Integer.parseInt(enablesForStr = configurationElement.getAttribute(ENABLES_FOR_ATTR))) > 0) {
                enablesFor = enablesForTest;
            }
            try {
                if (configurationElement.getAttribute(FILTER_ATTR) != null) {
                    filter = (IFilter)configurationElement.createExecutableExtension(FILTER_ATTR);
                }
                LegacyPropertySectionItemDescriptor legacySectionDescriptor = new LegacyPropertySectionItemDescriptor(tab, filter, configurationElement, id, enablesFor, afterSection);
                this.propertySectionRegistry.add(legacySectionDescriptor);
            }
            catch (CoreException e) {
                String message = MessageFormat.format(Messages.RegistryEventListener_cannotInstantiateExtension, id);
                EEFPropertiesUiLegacyPlugin.getImplementation().logError(message, (Exception)((Object)e));
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean processRemoval(IConfigurationElement configurationElement) {
        return this.propertySectionRegistry.remove(configurationElement.getAttribute(ID_ATTR)) != null;
    }
}

