/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.domain;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.egf.common.helper.URIHelper;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.domain.DiagnosticResourceException;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.core.platform.EGFPlatformPlugin;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPointDelta;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPointListener;
import org.eclipse.egf.core.workspace.EGFWorkspaceSynchronizer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelDelta;

public final class PlatformResourceLoadedListener
implements EGFWorkspaceSynchronizer.Delegate {
    private static volatile PlatformResourceLoadedListener resourceLoadedListener = new PlatformResourceLoadedListener();
    private static volatile ResourceManager resourceManager = new ResourceManager();
    private final WorkspaceListener listener = new WorkspaceListener();
    protected IPlatformExtensionPointListener platformListener = new IPlatformExtensionPointListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void platformExtensionPointChanged(IPlatformExtensionPointDelta delta) {
            PlatformResourceLoadedListener platformResourceLoadedListener = PlatformResourceLoadedListener.this;
            synchronized (platformResourceLoadedListener) {
                Resource resource;
                IPlatformFcore fcore;
                TransactionalEditingDomain editingDomain = PlatformResourceLoadedListener.this.getEditingDomain();
                UniqueEList deltaChangedFcores = new UniqueEList();
                HashMap<Resource, IPlatformFcore> deltaRemovedFcores = new HashMap<Resource, IPlatformFcore>();
                IPlatformFcore[] iPlatformFcoreArray = (IPlatformFcore[])delta.getRemovedPlatformExtensionPoints(IPlatformFcore.class);
                int n = iPlatformFcoreArray.length;
                int n2 = 0;
                while (n2 < n) {
                    fcore = iPlatformFcoreArray[n2];
                    resource = editingDomain.getResourceSet().getResource(fcore.getURI(), false);
                    if (resource != null) {
                        deltaRemovedFcores.put(resource, fcore);
                    }
                    ++n2;
                }
                iPlatformFcoreArray = (IPlatformFcore[])delta.getAddedPlatformExtensionPoints(IPlatformFcore.class);
                n = iPlatformFcoreArray.length;
                n2 = 0;
                while (n2 < n) {
                    block17: {
                        block18: {
                            fcore = iPlatformFcoreArray[n2];
                            resource = editingDomain.getResourceSet().getResource(fcore.getURI(), false);
                            if (resource == null) break block17;
                            if (resource.getContents().size() != 0 || resource.getErrors().isEmpty()) break block18;
                            IPlatformFcore deletedFcore = (IPlatformFcore)deltaRemovedFcores.get(resource);
                            if (deletedFcore != null) {
                                deltaRemovedFcores.remove(resource);
                            }
                            resource.unload();
                            resource.getResourceSet().getResources().remove((Object)resource);
                            if (EGFCorePlugin.getDefault().isDebugging()) {
                                EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"TargetPlatformResourceLoadedListener.platformExtensionPointChanged(...) - discard loaded empty resource with errors ''{0}''", (Object)fcore.toString()));
                            }
                            if ((resource = editingDomain.getResourceSet().getResource(fcore.getURI(), true)) == null) break block17;
                            if (deletedFcore != null) {
                                deltaRemovedFcores.put(resource, deletedFcore);
                            }
                        }
                        if (deltaRemovedFcores.remove(resource) != null) {
                            deltaChangedFcores.add(resource);
                        }
                    }
                    ++n2;
                }
                if (!deltaRemovedFcores.isEmpty()) {
                    for (Resource resource2 : deltaRemovedFcores.keySet()) {
                        PlatformResourceLoadedListener.getResourceManager().removeResource(resource2);
                    }
                }
                if (!deltaChangedFcores.isEmpty()) {
                    for (Resource resource2 : deltaChangedFcores) {
                        PlatformResourceLoadedListener.getResourceManager().reloadResource(resource2);
                    }
                }
            }
        }
    };

    public static ResourceManager getResourceManager() {
        return resourceManager;
    }

    public static PlatformResourceLoadedListener getResourceLoadedListener() {
        return resourceLoadedListener;
    }

    private PlatformResourceLoadedListener() {
        PDECore.getDefault().getModelManager().addPluginModelListener((IPluginModelListener)this.listener);
    }

    private TransactionalEditingDomain getEditingDomain() {
        return TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(EGFCorePlugin.EDITING_DOMAIN_ID);
    }

    public synchronized boolean handleResourcePersisted(Resource resource) {
        for (ResourceListener resourceListener : PlatformResourceLoadedListener.getResourceManager().listeners) {
            resourceListener.internalUpdate(resource);
        }
        return true;
    }

    public synchronized boolean handleResourceMoved(Resource movedResource, URI newURI) {
        boolean isFcore = "fcore".equals(movedResource.getURI().fileExtension());
        boolean isMovedToFcore = "fcore".equals(newURI.fileExtension());
        if (isFcore && isMovedToFcore || !isFcore) {
            Resource resource = this.getEditingDomain().getResourceSet().getResource(movedResource.getURI(), false);
            if (resource != null || this.getEditingDomain().getResourceSet().getResource(newURI, false) != null) {
                PlatformResourceLoadedListener.getResourceManager().movedResource(resource, newURI);
            }
        } else {
            return this.handleResourceDeleted(movedResource);
        }
        return true;
    }

    public synchronized boolean handleResourceDeleted(Resource deletedResource) {
        IPlatformFcore fcore = EGFCorePlugin.getPlatformFcore(deletedResource);
        if (fcore == null) {
            PlatformResourceLoadedListener.getResourceManager().removeResource(deletedResource);
        }
        return true;
    }

    public synchronized boolean handleResourceChanged(Resource changedResource) {
        List users = (List)PlatformResourceLoadedListener.getResourceManager().observers.get(changedResource);
        if (users == null) {
            PlatformResourceLoadedListener.getResourceManager().reloadResource(changedResource);
            return true;
        }
        boolean hasSavedResource = false;
        boolean isDirty = false;
        for (ResourceUser user : users) {
            hasSavedResource |= user.userHasSavedResource();
            isDirty |= user.isDirty();
        }
        if (!hasSavedResource && !isDirty) {
            PlatformResourceLoadedListener.getResourceManager().reloadResource(changedResource);
            return true;
        }
        if (!hasSavedResource && isDirty) {
            for (ResourceListener resourceListener : PlatformResourceLoadedListener.getResourceManager().listeners) {
                resourceListener.externalUpdate(changedResource);
            }
            return true;
        }
        for (ResourceListener resourceListener : PlatformResourceLoadedListener.getResourceManager().listeners) {
            resourceListener.internalUpdate(changedResource);
        }
        return true;
    }

    public synchronized void dispose() {
        PDECore.getDefault().getModelManager().removePluginModelListener((IPluginModelListener)this.listener);
        EGFPlatformPlugin.getPlatformManager().removePlatformExtensionPointListener(this.platformListener);
        PlatformResourceLoadedListener.getResourceManager().dispose();
        resourceManager = null;
    }

    public static interface ResourceListener {
        public void resourceDeleted(Resource var1);

        public void resourceMoved(Resource var1, URI var2);

        public void resourceReloaded(Resource var1);

        public void externalUpdate(Resource var1);

        public void internalUpdate(Resource var1);
    }

    public static class ResourceManager {
        private final List<ResourceListener> listeners = new ArrayList<ResourceListener>();
        private final Map<Resource, List<ResourceUser>> observers = new HashMap<Resource, List<ResourceUser>>();

        protected void dispose() {
            this.listeners.clear();
            this.observers.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addObserver(ResourceUser resourceUser) {
            Class<PlatformResourceLoadedListener> clazz = PlatformResourceLoadedListener.class;
            synchronized (PlatformResourceLoadedListener.class) {
                Resource resource = resourceUser.getResource();
                List<ResourceUser> list = this.observers.get(resource);
                if (list == null) {
                    list = new ArrayList<ResourceUser>();
                    this.observers.put(resource, list);
                }
                list.add(resourceUser);
                this.listeners.add(resourceUser.getListener());
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeObserver(ResourceUser resourceUser) {
            PlatformResourceLoadedListener platformResourceLoadedListener = resourceLoadedListener;
            synchronized (platformResourceLoadedListener) {
                Resource resource = resourceUser.getResource();
                List<ResourceUser> list = this.observers.get(resource);
                if (list == null) {
                    return;
                }
                list.remove(resourceUser);
                if (list.isEmpty()) {
                    try {
                        resource.unload();
                        this.observers.remove(resource);
                        if (!this.noMoreObserver()) {
                            resource.load(Collections.EMPTY_MAP);
                        }
                    }
                    catch (IOException ioe) {
                        resource.getErrors().add((Object)new DiagnosticResourceException(resource, ioe));
                    }
                }
                this.listeners.remove(resourceUser.getListener());
                if (this.noMoreObserver()) {
                    this.clear();
                }
            }
        }

        private void clear() {
            final TransactionalEditingDomain editingDomain = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(EGFCorePlugin.EDITING_DOMAIN_ID);
            try {
                editingDomain.runExclusive(new Runnable(){

                    public void run() {
                        ResourceSet resourceSet = editingDomain.getResourceSet();
                        Iterator it = resourceSet.getResources().iterator();
                        while (it.hasNext()) {
                            Resource resource = (Resource)it.next();
                            resource.unload();
                            it.remove();
                        }
                    }
                });
                if (EGFCorePlugin.getDefault().isDebugging()) {
                    EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"''{0}'' _ clear", (Object)EGFCorePlugin.EDITING_DOMAIN_ID));
                }
            }
            catch (InterruptedException e) {
                EGFCorePlugin.getDefault().logError(e);
            }
        }

        private boolean noMoreObserver() {
            for (List<ResourceUser> users : this.observers.values()) {
                if (users.isEmpty()) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeResource(Resource resource) {
            if (resource == null) {
                throw new IllegalArgumentException();
            }
            PlatformResourceLoadedListener platformResourceLoadedListener = resourceLoadedListener;
            synchronized (platformResourceLoadedListener) {
                Iterator<ResourceUser> iterator;
                boolean isDirty = false;
                List<ResourceUser> users = this.observers.get(resource);
                if (users != null && (iterator = users.iterator()).hasNext()) {
                    ResourceUser user = iterator.next();
                    isDirty = user.isDirty();
                }
                for (ResourceListener resourceListener : this.listeners) {
                    resourceListener.resourceDeleted(resource);
                }
                if (!isDirty) {
                    resource.unload();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reloadResource(Resource resource) {
            if (resource == null) {
                throw new IllegalArgumentException();
            }
            PlatformResourceLoadedListener platformResourceLoadedListener = resourceLoadedListener;
            synchronized (platformResourceLoadedListener) {
                try {
                    resource.unload();
                    resource.load(Collections.EMPTY_MAP);
                }
                catch (IOException ioe) {
                    resource.getErrors().add((Object)new DiagnosticResourceException(resource, ioe));
                }
                for (ResourceListener resourceListener : this.listeners) {
                    resourceListener.resourceReloaded(resource);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void movedResource(Resource movedResource, URI newURI) {
            if (newURI == null) {
                throw new IllegalArgumentException();
            }
            TransactionalEditingDomain editingDomain = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(EGFCorePlugin.EDITING_DOMAIN_ID);
            PlatformResourceLoadedListener platformResourceLoadedListener = resourceLoadedListener;
            synchronized (platformResourceLoadedListener) {
                ResourceSet resourceSet = editingDomain.getResourceSet();
                Resource resource = resourceSet.getResource(newURI, false);
                if (resource != null && resource.getContents().size() == 0 && !resource.getErrors().isEmpty()) {
                    resource.unload();
                    resourceSet.getResources().remove((Object)resource);
                    if (EGFCorePlugin.getDefault().isDebugging()) {
                        EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"TargetPlatformResourceLoadedListener$ResourceManager.movedResource(...) - discard loaded empty resource with errors ''{0}''", (Object)URIHelper.toString((URI)newURI)));
                    }
                    movedResource = editingDomain.getResourceSet().getResource(newURI, true);
                } else if (movedResource != null) {
                    movedResource.setURI(newURI);
                }
                if (movedResource != null) {
                    URI oldURI = movedResource.getURI();
                    for (ResourceListener resourceListener : this.listeners) {
                        resourceListener.resourceMoved(movedResource, oldURI);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean resourceHasBeenExternallyChanged(Resource resource) {
            if (resource == null) {
                throw new IllegalArgumentException();
            }
            PlatformResourceLoadedListener platformResourceLoadedListener = resourceLoadedListener;
            synchronized (platformResourceLoadedListener) {
                List<ResourceUser> users;
                block6: {
                    users = this.observers.get(resource);
                    if (users != null) break block6;
                    return false;
                }
                boolean resourceHasBeenExternallyChanged = false;
                Iterator<ResourceUser> iterator = users.iterator();
                if (iterator.hasNext()) {
                    ResourceUser user = iterator.next();
                    resourceHasBeenExternallyChanged = user.resourceHasBeenExternallyChanged();
                }
                return resourceHasBeenExternallyChanged;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void populateUndoContext(IOperationHistory operationHistory, ObjectUndoContext undoContext, Resource resource) {
            if (resource == null || undoContext == null) {
                throw new IllegalArgumentException();
            }
            PlatformResourceLoadedListener platformResourceLoadedListener = resourceLoadedListener;
            synchronized (platformResourceLoadedListener) {
                List<ResourceUser> users = this.observers.get(resource);
                if (users == null) {
                    return;
                }
                ObjectUndoContext innerUndoContext = null;
                for (ResourceUser user : users) {
                    if (user.getUndoContext() == undoContext) continue;
                    innerUndoContext = user.getUndoContext();
                    break;
                }
                if (innerUndoContext != null) {
                    IUndoableOperation operation;
                    IUndoableOperation[] iUndoableOperationArray = operationHistory.getUndoHistory(innerUndoContext);
                    int n = iUndoableOperationArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        operation = iUndoableOperationArray[n2];
                        operation.addContext((IUndoContext)undoContext);
                        ++n2;
                    }
                    iUndoableOperationArray = operationHistory.getRedoHistory((IUndoContext)innerUndoContext);
                    n = iUndoableOperationArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        operation = iUndoableOperationArray[n2];
                        operation.addContext((IUndoContext)undoContext);
                        ++n2;
                    }
                }
            }
        }
    }

    public static interface ResourceUser {
        public Resource getResource();

        public ResourceListener getListener();

        public boolean isDirty();

        public boolean userHasSavedResource();

        public boolean resourceHasBeenExternallyChanged();

        public IOperationHistory getOperationHistory();

        public ObjectUndoContext getUndoContext();
    }

    public class WorkspaceListener
    implements IPluginModelListener {
        public void modelsChanged(PluginModelDelta delta) {
            TransactionalEditingDomain editingDomain = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(EGFCorePlugin.EDITING_DOMAIN_ID);
            ModelEntry[] modelEntryArray = delta.getChangedEntries();
            int n = modelEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                ModelEntry entry = modelEntryArray[n2];
                String id = entry.getId();
                for (Resource r : editingDomain.getResourceSet().getResources()) {
                    if (!id.equals(r.getURI().segment(1))) continue;
                    this.reloadResource(r);
                }
                ++n2;
            }
        }

        private void reloadResource(Resource r) {
            System.out.println("reload " + r.getURI());
            r.unload();
            try {
                r.load(Collections.EMPTY_MAP);
            }
            catch (IOException e) {
                EGFPlatformPlugin.getDefault().logError((Throwable)e);
            }
        }
    }
}

