/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.codegen.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class ProjectCreationHelper {
    private String name;
    private String[] natures;

    public String getName() {
        return this.name;
    }

    public IProject getProject() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.name);
    }

    public IProject createProject() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.name);
        if (!project.exists()) {
            project.create(null);
        }
        if (!project.isOpen()) {
            project.open(null);
        }
        IProjectDescription description = project.getDescription();
        description.setNatureIds(this.natures);
        project.setDescription(description, null);
        return project;
    }

    public static void addJarToBuildPath(String path, IJavaProject javaProject) throws JavaModelException {
        IClasspathEntry newLibraryEntry = JavaCore.newLibraryEntry((IPath)new Path(path), null, null);
        ProjectCreationHelper.addToClasspath(javaProject, newLibraryEntry);
    }

    public static void addJarToBuildPath(IPath path, IJavaProject javaProject) throws JavaModelException {
        IClasspathEntry newLibraryEntry = JavaCore.newLibraryEntry((IPath)path, null, null);
        ProjectCreationHelper.addToClasspath(javaProject, newLibraryEntry);
    }

    public static void addVariableEntryToBuildPath(IPath path, IJavaProject javaProject) throws JavaModelException {
        IClasspathEntry newLibraryEntry = JavaCore.newVariableEntry((IPath)path, null, null);
        ProjectCreationHelper.addToClasspath(javaProject, newLibraryEntry);
    }

    public static void addAllJarsToBuildPath(IFolder folder, IJavaProject javaProject) throws CoreException {
        try {
            folder.refreshLocal(100, (IProgressMonitor)new NullProgressMonitor());
            IResource[] iResourceArray = folder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IFile && resource.getRawLocation().toString().endsWith(".jar")) {
                    ProjectCreationHelper.addJarToBuildPath(resource.getRawLocation(), javaProject);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void addToClasspath(IJavaProject javaProject, IClasspathEntry newEntry) throws JavaModelException {
        if (newEntry == null) {
            return;
        }
        IClasspathEntry[] oldEntries = javaProject.getRawClasspath();
        IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length + 1];
        System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
        newEntries[oldEntries.length] = newEntry;
        javaProject.setRawClasspath(newEntries, null);
    }

    public static final void removeFromClasspath(IJavaProject javaProject, IPath toBeRemoved) throws JavaModelException {
        IClasspathEntry[] oldEntries = javaProject.getRawClasspath();
        ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
        IClasspathEntry[] iClasspathEntryArray = oldEntries;
        int n = oldEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
            if (!classpathEntry.getPath().equals((Object)toBeRemoved)) {
                newEntries.add(classpathEntry);
            }
            ++n2;
        }
        IClasspathEntry[] newEntriesArray = new IClasspathEntry[newEntries.size()];
        javaProject.setRawClasspath(newEntries.toArray(newEntriesArray), null);
    }

    public IJavaProject createJavaProject() throws CoreException {
        IProject project = this.createProject();
        return this.createJavaProject(project);
    }

    public IJavaProject createJavaProject(IProject project) {
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (!javaProject.isOpen()) {
                javaProject.open(null);
            }
            this.createBinFolder(project, javaProject);
            this.clearSourcePath(javaProject);
            IClasspathEntry sourceFolder = this.createSourceFolder("src", project);
            ProjectCreationHelper.addToClasspath(javaProject, sourceFolder);
            this.addJREContainerToProject(javaProject);
            return javaProject;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void addJREContainerToProject(IJavaProject javaProject) throws JavaModelException {
        ProjectCreationHelper.addToClasspath(javaProject, JavaRuntime.getDefaultJREContainerEntry());
    }

    private void clearSourcePath(IJavaProject javaProject) throws JavaModelException {
        javaProject.setRawClasspath(new IClasspathEntry[0], (IProgressMonitor)new NullProgressMonitor());
    }

    public void addJavaNature(IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[natures.length] = "org.eclipse.jdt.core.javanature";
        description.setNatureIds(newNatures);
        project.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
    }

    private IClasspathEntry createSourceFolder(String path, IProject project) throws CoreException {
        IFolder srcFolder = project.getFolder((IPath)new Path(path));
        if (!srcFolder.exists()) {
            srcFolder.create(false, true, null);
            IPath sourceFolderPath = srcFolder.getFullPath();
            IClasspathEntry entry = JavaCore.newSourceEntry((IPath)sourceFolderPath);
            return entry;
        }
        return null;
    }

    public IFolder createSourceFolder(String path, IProject project, IJavaProject javaProject) throws CoreException {
        IFolder srcFolder = project.getFolder((IPath)new Path(path));
        if (!srcFolder.exists()) {
            srcFolder.create(false, true, null);
            IPath sourceFolderPath = srcFolder.getFullPath();
            IClasspathEntry entry = JavaCore.newSourceEntry((IPath)sourceFolderPath);
            ProjectCreationHelper.addToClasspath(javaProject, entry);
            return srcFolder;
        }
        return null;
    }

    private void createBinFolder(IProject project, IJavaProject javaProject) throws CoreException, JavaModelException {
        this.createOutputFolder("bin", project, javaProject);
    }

    private void createOutputFolder(String path, IProject project, IJavaProject javaProject) throws CoreException, JavaModelException {
        try {
            IFolder binFolder = project.getFolder((IPath)new Path(path));
            if (!binFolder.exists()) {
                binFolder.create(true, true, null);
                javaProject.setOutputLocation(binFolder.getFullPath(), null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public IFolder createFolder(String name, IProject project) {
        IFolder folder = project.getFolder(name);
        if (!folder.exists()) {
            try {
                folder.create(0, true, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return folder;
    }

    public IFolder getFolder(String name, IProject project) {
        IFolder folder = project.getFolder(name);
        return folder;
    }

    public IFile createFile(String name, IFolder folder, String content) {
        IFile file = folder.getFile("web.xml");
        try {
            if (!file.exists()) {
                byte[] bytes = content.getBytes();
                ByteArrayInputStream source = new ByteArrayInputStream(bytes);
                file.create((InputStream)source, 0, null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return file;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String[] getNatures() {
        return this.natures;
    }

    public void setNatures(String[] natures) {
        this.natures = natures;
    }

    public static void refreshProject(IResource resource, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(null){

            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                try {
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    root.refreshLocal(2, monitor);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        };
        op.run(monitor);
    }
}

