/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui;

import org.eclipse.emf.cdo.common.util.CDORenameContext;
import org.eclipse.emf.cdo.explorer.ui.bundle.OM;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RenameDialog
extends TitleAreaDialog {
    private final CDORenameContext renameContext;
    private String name;
    private Text nameText;

    public RenameDialog(Shell parentShell, CDORenameContext renameContext) {
        super(parentShell);
        this.renameContext = renameContext;
        this.name = renameContext.getName();
        this.setShellStyle(65648);
    }

    public String getName() {
        return this.name;
    }

    protected Control createDialogArea(Composite parent) {
        String title = "Rename " + this.renameContext.getType();
        this.getShell().setText(title);
        this.setTitle(title);
        this.setTitleImage(OM.getImage("icons/wiz/rename.gif"));
        this.setMessage("Enter the new " + this.getAttributeName() + " of the " + this.renameContext.getType().toLowerCase() + ".");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout containerGridLayout = new GridLayout(2, false);
        containerGridLayout.marginWidth = 10;
        containerGridLayout.marginHeight = 10;
        container.setLayout((Layout)containerGridLayout);
        Label oldLabel = new Label(container, 0);
        oldLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        oldLabel.setText("Current " + this.getAttributeName() + ":");
        Text oldNameText = new Text(container, 2056);
        oldNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        oldNameText.setText(this.name);
        Label newLabel = new Label(container, 0);
        newLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        newLabel.setText("New " + this.getAttributeName() + ":");
        this.nameText = new Text(container, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.nameText.setText(this.name);
        this.nameText.setFocus();
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RenameDialog.this.name = RenameDialog.this.nameText.getText();
                String error = RenameDialog.this.renameContext.validateName(RenameDialog.this.name);
                RenameDialog.this.setErrorMessage(error);
                Button button = RenameDialog.this.getButton(0);
                if (button != null) {
                    button.setEnabled(error == null);
                }
            }
        });
        int lastDot = this.name.lastIndexOf(46);
        if (lastDot != -1) {
            this.nameText.setSelection(0, lastDot);
        } else {
            this.nameText.selectAll();
        }
        return area;
    }

    protected String getAttributeName() {
        return "name";
    }

    protected Point getInitialSize() {
        return new Point(450, 250);
    }
}

