/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import java.util.List;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.net4j.util.concurrent.IRWLockManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockObjectsRequest
extends CDOClientRequest<CDOSessionProtocol.LockObjectsResult> {
    private int viewID;
    private IRWLockManager.LockType lockType;
    private long timeout;
    private List<CDORevisionKey> revisionKeys;
    private boolean recursive;

    public LockObjectsRequest(CDOClientProtocol protocol, List<CDORevisionKey> revisionKeys, int viewID, IRWLockManager.LockType lockType, boolean recursive, long timeout) {
        this(protocol, 24, revisionKeys, viewID, lockType, recursive, timeout);
    }

    protected LockObjectsRequest(CDOClientProtocol protocol, short signalID, List<CDORevisionKey> revisionKeys, int viewID, IRWLockManager.LockType lockType, boolean recursive, long timeout) {
        super(protocol, signalID);
        this.viewID = viewID;
        this.lockType = lockType;
        this.timeout = timeout;
        this.revisionKeys = revisionKeys;
        this.recursive = recursive;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        out.writeInt(this.viewID);
        out.writeCDOLockType(this.lockType);
        out.writeBoolean(this.recursive);
        out.writeLong(this.timeout);
        out.writeInt(this.revisionKeys.size());
        for (CDORevisionKey revKey : this.revisionKeys) {
            out.writeCDORevisionKey(revKey);
        }
    }

    @Override
    protected CDOSessionProtocol.LockObjectsResult confirming(CDODataInput in) throws IOException {
        boolean succesful = in.readBoolean();
        boolean timeout = in.readBoolean();
        boolean waitForUpdate = in.readBoolean();
        long requiredTimestamp = in.readLong();
        int nStaleRevisions = in.readInt();
        CDORevisionKey[] staleRevisions = new CDORevisionKey[nStaleRevisions];
        int i = 0;
        while (i < nStaleRevisions) {
            staleRevisions[i] = in.readCDORevisionKey();
            ++i;
        }
        long timestamp = in.readLong();
        int n = in.readInt();
        CDOLockState[] newLockStates = new CDOLockState[n];
        int i2 = 0;
        while (i2 < n) {
            newLockStates[i2] = in.readCDOLockState();
            ++i2;
        }
        return new CDOSessionProtocol.LockObjectsResult(succesful, timeout, waitForUpdate, requiredTimestamp, staleRevisions, newLockStates, timestamp);
    }
}

